/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientPoliciesResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.admin.client.resource.RolePoliciesResource;
import org.keycloak.admin.client.resource.RoleScopeResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.testsuite.adapter.example.authorization.AbstractBaseServletAuthzAdapterTest;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class AbstractServletAuthzAdapterTest
extends AbstractBaseServletAuthzAdapterTest {
    @Test
    public void testCanNotAccessWhenEnforcing() throws Exception {
        this.performTests(() -> {
            this.importResourceServerSettings();
            ResourcesResource resources = this.getAuthorizationResource().resources();
            ResourceRepresentation resource = (ResourceRepresentation)resources.findByName("Protected Resource").get(0);
            resource.setUri("/index.jsp");
            resources.resource(resource.getId()).update(resource);
        }, () -> {
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl().toString() + "/enforcing/resource");
            this.assertWasDenied();
        });
    }

    @Test
    public void testRegularUserPermissions() throws Exception {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.assertWasNotDenied();
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertFalse((boolean)this.hasText("Do  user premium thing"));
            Assert.assertFalse((boolean)this.hasText("Do administration thing"));
            this.navigateToUserPremiumPage();
            this.assertWasDenied();
            this.navigateToAdminPage();
            this.assertWasDenied();
        });
    }

    @Test
    public void testUserPremiumPermissions() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.assertWasNotDenied();
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertTrue((boolean)this.hasText("Do  user premium thing"));
            Assert.assertFalse((boolean)this.hasText("Do administration thing"));
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            this.navigateToAdminPage();
            this.assertWasDenied();
        });
    }

    @Test
    public void testAdminPermissions() throws Exception {
        this.performTests(() -> {
            this.login("admin", "admin");
            this.assertWasNotDenied();
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertTrue((boolean)this.hasText("Do administration thing"));
            Assert.assertFalse((boolean)this.hasText("Do  user premium thing"));
            this.navigateToUserPremiumPage();
            this.assertWasDenied();
            this.navigateToAdminPage();
            this.assertWasNotDenied();
        });
    }

    @Test
    public void testGrantPremiumAccessToUser() throws Exception {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.assertWasNotDenied();
            this.navigateToUserPremiumPage();
            this.assertWasDenied();
            this.updatePermissionPolicies("Premium Resource Permission", "Any User Policy");
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            this.updatePermissionPolicies("Premium Resource Permission", "Only Premium User Policy");
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            this.assertWasDenied();
            this.createUserPolicy("Temporary Premium Access Policy", "alice");
            this.updatePermissionPolicies("Premium Resource Permission", "Temporary Premium Access Policy");
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
        });
    }

    @Test
    public void testGrantAdministrativePermissions() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.navigateToAdminPage();
            this.assertWasDenied();
            RealmResource realmResource = this.realmsResouce().realm("servlet-authz");
            UsersResource usersResource = realmResource.users();
            List users = usersResource.search("jdoe", null, null, null, null, null);
            Assert.assertFalse((boolean)users.isEmpty());
            UserResource userResource = usersResource.get(((UserRepresentation)users.get(0)).getId());
            RoleRepresentation adminRole = realmResource.roles().get("admin").toRepresentation();
            userResource.roles().realmLevel().add(Arrays.asList(adminRole));
            this.login("jdoe", "jdoe");
            this.navigateToAdminPage();
            this.assertWasNotDenied();
        });
    }

    @Test
    @Ignore
    public void testAccessPublicResource() throws Exception {
        this.performTests(() -> {
            this.driver.navigate().to(this.getResourceServerUrl() + "/public-html.html");
            WaitUtils.waitForPageToLoad();
            Assert.assertTrue((boolean)this.hasText("This is public resource that should be accessible without login."));
        });
    }

    @Test
    public void testRequiredRole() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            RolesResource rolesResource = this.getClientResource("servlet-authz-app").roles();
            rolesResource.create(new RoleRepresentation("required-role", "", false));
            RolePolicyRepresentation policy = new RolePolicyRepresentation();
            policy.setName("Required Role Policy");
            policy.addRole("user_premium", false);
            policy.addRole("servlet-authz-app/required-role", false);
            RolePoliciesResource rolePolicy = this.getAuthorizationResource().policies().role();
            rolePolicy.create(policy);
            policy = rolePolicy.findByName(policy.getName());
            this.updatePermissionPolicies("Premium Resource Permission", policy.getName());
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            policy.getRoles().clear();
            policy.addRole("user_premium", false);
            policy.addRole("servlet-authz-app/required-role", true);
            rolePolicy.findById(policy.getId()).update(policy);
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasDenied();
            UsersResource users = this.realmsResouce().realm("servlet-authz").users();
            UserRepresentation user = (UserRepresentation)users.search("jdoe").get(0);
            RoleScopeResource roleScopeResource = users.get(user.getId()).roles().clientLevel(this.getClientResource("servlet-authz-app").toRepresentation().getId());
            RoleRepresentation requiredRole = rolesResource.get("required-role").toRepresentation();
            roleScopeResource.add(Arrays.asList(requiredRole));
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            policy.getRoles().clear();
            policy.addRole("user_premium", false);
            policy.addRole("servlet-authz-app/required-role", false);
            rolePolicy.findById(policy.getId()).update(policy);
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
            roleScopeResource.remove(Arrays.asList(requiredRole));
            this.login("jdoe", "jdoe");
            this.navigateToUserPremiumPage();
            this.assertWasNotDenied();
        });
    }

    @Test
    public void testOnlySpecificClient() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.assertWasNotDenied();
            ClientPolicyRepresentation policy = new ClientPolicyRepresentation();
            policy.setName("Only Client Policy");
            policy.addClient(new String[]{"admin-cli"});
            ClientPoliciesResource policyResource = this.getAuthorizationResource().policies().client();
            Response response = policyResource.create(policy);
            response.close();
            policy = policyResource.findByName(policy.getName());
            this.updatePermissionPolicies("Protected Resource Permission", policy.getName());
            this.login("jdoe", "jdoe");
            this.assertWasDenied();
            policy.addClient(new String[]{"servlet-authz-app"});
            policyResource.findById(policy.getId()).update(policy);
            this.login("jdoe", "jdoe");
            this.assertWasNotDenied();
        });
    }

    @Test
    public void testAccessResourceWithAnyScope() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl() + "/protected/scopes.jsp");
            WaitUtils.waitForPageToLoad();
            Assert.assertTrue((boolean)this.hasText("Granted"));
        });
    }

    @Test
    public void testMultipleURLsForResourceRealmConfig() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index1.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource1 index1.jsp");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index2.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource1 index2.jsp");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern1/page.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource2/pattern1");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern2/page.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource2/pattern2");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/test");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/sub-resource2/test");
            this.updatePermissionPolicies("Permission for multiple url resource", "Deny Policy");
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index1.jsp");
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().not()).contains("sub-resource1 index1.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("You can not access this resource.");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index2.jsp");
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().not()).contains("sub-resource1 index2.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("You can not access this resource.");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern1/page.jsp");
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().not()).contains("sub-resource2/pattern1");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("You can not access this resource.");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern2/page.jsp");
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().not()).contains("sub-resource2/pattern2");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("You can not access this resource.");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/test");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/sub-resource2/test");
            this.updatePermissionPolicies("Permission for multiple url resource", "All Users Policy");
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index1.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource1 index1.jsp");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource1/index2.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource1 index2.jsp");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern1/page.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource2/pattern1");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/pattern2/page.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("sub-resource2/pattern2");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/test");
            this.driver.navigate().to(this.getResourceServerUrl() + "/keycloak-7269/sub-resource2/test.jsp");
            WaitUtils.waitUntilElement((By)By.tagName((String)"h2")).text().contains("keycloak-7269/sub-resource2/test");
        });
    }
}

