/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.testsuite.adapter.example.authorization.AbstractBasePhotozExampleAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public abstract class AbstractPhotozAccountResourcesAdapterTest
extends AbstractBasePhotozExampleAdapterTest {
    @Test
    public void testOwnerSharingResource() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.clientPage.accountShareResource("Alice-Family-Album", "jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login().init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.clientPage.accountShareRemoveScope("Alice-Family-Album", "jdoe", "album:delete");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.accountRevokeResource("Alice-Family-Album", "jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login().init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
    }

    @Test
    public void testRequestResourceToOwner() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.accountGrantResource("Alice-Family-Album", "jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login().init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.accountGrantRemoveScope("Alice-Family-Album", "jdoe", "album:delete");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.clientPage.accountGrantResource("Alice-Family-Album", "jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login().init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
    }

    @Test
    public void testCsrfGrantAccess() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.accountMyResources();
        this.clientPage.executeScript("document.forms[0].stateChecker.value = 'invalid'");
        this.clientPage.grantResource("Alice-Family-Album", "jdoe");
        this.clientPage.assertError();
    }

    @Test
    public void testCsrfRevokeResource() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.accountGrantResource("Alice-Family-Album", "jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.accountMyResource("Alice-Family-Album");
        this.clientPage.executeScript("document.forms[0].stateChecker.value = 'invalid'");
        this.clientPage.revokeResource("Alice-Family-Album", "jdoe");
        this.clientPage.assertError();
    }

    @Test
    public void testCrfCheckSharingResource() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album", true);
        this.clientPage.accountMyResource("Alice-Family-Album");
        this.clientPage.executeScript("document.forms['shareForm'].stateChecker.value = 'invalid'");
        this.clientPage.shareResource("jdoe");
        this.clientPage.assertError();
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login().init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.accountMyResource("Alice-Family-Album");
        this.clientPage.shareResource("jdoe");
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        this.loginToClientPage(this.jdoeUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
    }
}

