/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public abstract class AbstractBaseServletAuthzAdapterTest
extends AbstractExampleAdapterTest {
    protected static final String REALM_NAME = "servlet-authz";
    protected static final String RESOURCE_SERVER_ID = "servlet-authz-app";
    @ArquillianResource
    private Deployer deployer;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/servlet-authz-realm.json")));
    }

    protected void performTests(ExceptionRunnable assertion) {
        this.performTests(() -> this.importResourceServerSettings(), assertion);
    }

    protected void performTests(ExceptionRunnable beforeDeploy, ExceptionRunnable assertion) {
        try {
            beforeDeploy.run();
            this.deployer.deploy(RESOURCE_SERVER_ID);
            assertion.run();
        }
        catch (FileNotFoundException cause) {
            throw new RuntimeException("Failed to import authorization settings", cause);
        }
        catch (Exception cause) {
            throw new RuntimeException("Error while executing tests", cause);
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    protected boolean hasLink(String text) {
        return this.getLink(text) != null;
    }

    protected boolean hasText(String text) {
        return this.driver.getPageSource().contains(text);
    }

    protected WebElement getLink(String text) {
        return this.driver.findElement(By.xpath((String)("//a[text() = '" + text + "']")));
    }

    protected void importResourceServerSettings() throws FileNotFoundException {
        this.getAuthorizationResource().importSettings((ResourceServerRepresentation)IOUtil.loadJson((InputStream)new FileInputStream(new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/servlet-authz-app-authz-service.json")), ResourceServerRepresentation.class));
    }

    protected AuthorizationResource getAuthorizationResource() {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    protected ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }

    private void logOut() {
        this.navigateTo();
        UIUtils.clickLink((WebElement)this.driver.findElement(By.xpath((String)"//a[text() = 'Sign Out']")));
    }

    protected void login(String username, String password) {
        try {
            this.navigateTo();
            if (this.driver.getCurrentUrl().startsWith(this.getResourceServerUrl().toString())) {
                this.logOut();
                this.navigateTo();
            }
            this.loginPage.form().login(username, password);
        }
        catch (Exception cause) {
            throw new RuntimeException("Login failed", cause);
        }
    }

    protected void navigateTo() {
        this.driver.navigate().to(this.getResourceServerUrl() + "/");
        WaitUtils.waitForPageToLoad();
    }

    protected void assertWasDenied() {
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).text().contains("You can not access this resource.");
    }

    protected void assertWasNotDenied() {
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.tagName((String)"body")).text().not()).contains("You can not access this resource.");
    }

    protected URL getResourceServerUrl() {
        try {
            return new URL(this.appServerContextRootPage + "/" + RESOURCE_SERVER_ID);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain resource server url.", e);
        }
    }

    protected void navigateToDynamicMenuPage() {
        this.navigateTo();
        UIUtils.clickLink((WebElement)this.getLink("Dynamic Menu"));
    }

    protected void navigateToUserPremiumPage() {
        this.navigateTo();
        UIUtils.clickLink((WebElement)this.getLink("User Premium"));
    }

    protected void navigateToAdminPage() {
        this.navigateTo();
        UIUtils.clickLink((WebElement)this.getLink("Administration"));
    }

    protected void updatePermissionPolicies(String permissionName, String ... policyNames) {
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            if (!permissionName.equalsIgnoreCase(policy.getName())) continue;
            StringBuilder policies = new StringBuilder("[");
            for (String policyName : policyNames) {
                if (policies.length() > 1) {
                    policies.append(",");
                }
                policies.append("\"").append(policyName).append("\"");
            }
            policies.append("]");
            policy.getConfig().put("applyPolicies", policies.toString());
            this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
        }
    }

    protected void createUserPolicy(String name, String ... userNames) {
        UserPolicyRepresentation policy = new UserPolicyRepresentation();
        policy.setName(name);
        for (String userName : userNames) {
            policy.addUser(userName);
        }
        Assert.assertFalse((boolean)policy.getUsers().isEmpty());
        Response response = this.getAuthorizationResource().policies().user().create(policy);
        response.close();
    }

    protected static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

