/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.example.authorization.AbstractPhotozJavascriptExecutorTest;
import org.keycloak.testsuite.adapter.page.PhotozClientAuthzTestApp;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JavascriptTestExecutorWithAuthorization;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public abstract class AbstractBasePhotozExampleAdapterTest
extends AbstractPhotozJavascriptExecutorTest {
    protected static final String RESOURCE_SERVER_ID = "photoz-restful-api";
    protected static final String ALICE_ALBUM_NAME = "Alice-Family-Album";
    private static final int TOKEN_LIFESPAN_LEEWAY = 3;
    @ArquillianResource
    private Deployer deployer;
    @Page
    @JavascriptBrowser
    protected PhotozClientAuthzTestApp clientPage;
    @Page
    @JavascriptBrowser
    private OAuthGrant oAuthGrantPage;
    protected JavascriptTestExecutorWithAuthorization testExecutor;
    @FindBy(id="output")
    @JavascriptBrowser
    protected WebElement outputArea;
    @FindBy(id="events")
    @JavascriptBrowser
    protected WebElement eventsArea;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("photoz");
        this.oAuthGrantPage.setAuthRealm("photoz");
    }

    @Before
    public void beforePhotozExampleAdapterTest() throws Exception {
        DroneUtils.addWebDriver((WebDriver)this.jsDriver);
        this.deployIgnoreIfDuplicate(RESOURCE_SERVER_ID);
        this.clientPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith(this.clientPage.toString());
        this.testExecutor = JavascriptTestExecutorWithAuthorization.create((WebDriver)this.jsDriver, (OIDCLogin)this.jsDriverTestRealmLoginPage);
        this.clientPage.setTestExecutorPlayground(this.testExecutor, this.appServerContextRootPage + "/" + RESOURCE_SERVER_ID);
        this.jsDriver.manage().deleteAllCookies();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            HttpGet request = new HttpGet(this.clientPage.toString() + "/unsecured/clean");
            httpClient.execute((HttpUriRequest)request).close();
        }
    }

    @Before
    public void fixBrokenDeserializationOnEAP6() throws IOException, CliException, TimeoutException, InterruptedException {
        if (AppServerTestEnricher.isEAP6AppServer()) {
            OnlineManagementClient client = AppServerTestEnricher.getManagementClient();
            Administration administration = new Administration(client);
            client.execute("/system-property=jackson.deserialization.whitelist.packages:add(value=org.keycloak.example.photoz)");
            administration.reloadIfRequired();
        }
    }

    @After
    public void afterPhotozExampleAdapterTest() {
        this.deployer.undeploy(RESOURCE_SERVER_ID);
        DroneUtils.removeWebDriver();
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/photoz/photoz-realm.json"));
        realm.setAccessTokenLifespan(Integer.valueOf(33));
        testRealms.add(realm);
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.importResourceServerSettings();
    }

    protected List<ResourceRepresentation> getResourcesOfUser(String username) throws FileNotFoundException {
        return this.getAuthorizationResource().resources().resources().stream().filter(resource -> resource.getOwner().getName().equals(username)).collect(Collectors.toList());
    }

    protected void printUpdatedPolicies() throws FileNotFoundException {
        this.log.debug((Object)"Check updated policies");
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            this.log.debugf("Policy: %s", (Object)policy.getName());
            for (String key : policy.getConfig().keySet()) {
                this.log.debugf("-- key: %s, value: %s", (Object)key, policy.getConfig().get(key));
            }
        }
        this.log.debug((Object)"------------------------------");
    }

    protected void assertOnTestAppUrl(WebDriver jsDriver, Object output, WebElement events) {
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith(this.clientPage.toString(), jsDriver);
    }

    protected void assertWasDenied(Map<String, Object> response) {
        MatcherAssert.assertThat((Object)response.get("status"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)401L)));
    }

    protected void assertWasNotDenied(Map<String, Object> response) {
        MatcherAssert.assertThat((Object)response.get("status"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200L)));
    }

    private void importResourceServerSettings() throws FileNotFoundException {
        ResourceServerRepresentation authSettings = (ResourceServerRepresentation)IOUtil.loadJson((InputStream)new FileInputStream(new File(TEST_APPS_HOME_DIR + "/photoz/photoz-restful-api-authz-service.json")), ResourceServerRepresentation.class);
        authSettings.getPolicies().stream().filter(x -> "Only Owner Policy".equals(x.getName())).forEach(x -> x.getConfig().put("mavenArtifactVersion", System.getProperty("project.version")));
        this.getAuthorizationResource().importSettings(authSettings);
    }

    protected AuthorizationResource getAuthorizationResource() throws FileNotFoundException {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    protected ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm("photoz").clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }

    protected void loginToClientPage(UserRepresentation user, String ... scopes) throws InterruptedException {
        this.log.debugf("--logging in as '%s' with password: '%s'; scopes: %s", (Object)user.getUsername(), (Object)((CredentialRepresentation)user.getCredentials().get(0)).getValue(), (Object)Arrays.toString(scopes));
        if (this.testExecutor.isLoggedIn()) {
            this.testExecutor.logout(this::assertOnTestAppUrl);
            this.jsDriver.manage().deleteAllCookies();
            this.jsDriver.navigate().to(this.testRealmLoginPage.toString());
            this.jsDriver.manage().deleteAllCookies();
        }
        this.clientPage.navigateTo();
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginFormWithScopesWithPossibleConsentPage(user, this::assertOnTestAppUrl, this.oAuthGrantPage, scopes).init(this.defaultArguments(), this::assertSuccessfullyLoggedIn);
        new WebDriverWait(this.jsDriver, 10L).until(this::isLoaded);
    }

    public boolean isLoaded(WebDriver w) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)w;
        Map o = (Map)jsExecutor.executeScript("return window.authorization.config", new Object[0]);
        return o != null && o.containsKey("token_endpoint");
    }

    protected void setManageAlbumScopeRequired() {
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("manage-albums");
        clientScope.setProtocol("openid-connect");
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("manage-albums");
        mapper.setProtocol("openid-connect");
        mapper.setProtocolMapper("oidc-usermodel-client-role-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        config.put("userinfo.token.claim", "true");
        config.put("usermodel.clientRoleMapping.clientId", RESOURCE_SERVER_ID);
        mapper.setConfig(config);
        clientScope.setProtocolMappers(Arrays.asList(mapper));
        RealmResource realmResource = this.realmsResouce().realm("photoz");
        ClientScopesResource clientScopes = realmResource.clientScopes();
        Response resp = clientScopes.create(clientScope);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String clientScopeId = ApiUtil.getCreatedId((Response)resp);
        ClientResource resourceServer = this.getClientResource(RESOURCE_SERVER_ID);
        clientScopes.get(clientScopeId).getScopeMappings().clientLevel(resourceServer.toRepresentation().getId()).add(Arrays.asList(resourceServer.roles().get("manage-albums").toRepresentation()));
        ClientResource html5ClientApp = this.getClientResource("photoz-html5-client");
        html5ClientApp.addOptionalClientScope(clientScopeId);
        html5ClientApp.getScopeMappings().realmLevel().add(Arrays.asList(realmResource.roles().get("user").toRepresentation(), realmResource.roles().get("admin").toRepresentation()));
        ClientRepresentation clientRep = html5ClientApp.toRepresentation();
        clientRep.setFullScopeAllowed(Boolean.valueOf(false));
        html5ClientApp.update(clientRep);
    }

    protected void deployIgnoreIfDuplicate(String name) {
        try {
            this.deployer.deploy(name);
        }
        catch (Exception e) {
            if (e instanceof DeploymentException && e.getMessage().contains("Duplicate resource")) {
                this.log.warnf("Duplicate resource '%s'. Trying to undeploy and deploy again...", (Object)name);
                this.deployer.undeploy(name);
                this.deployer.deploy(name);
                return;
            }
            throw e;
        }
    }
}

