/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.arquillian.DeploymentArchiveProcessorUtils;
import org.keycloak.testsuite.utils.io.IOUtil;

public abstract class AbstractServletsAdapterTest
extends AbstractAdapterTest {
    protected static WebArchive servletDeploymentMultiTenant(String name, Class ... servletClasses) {
        WebArchive servletDeployment = AbstractServletsAdapterTest.servletDeployment(name, null, servletClasses);
        String webInfPath = "/adapter-test/" + name + "/WEB-INF/";
        String config1 = "tenant1-keycloak.json";
        String config2 = "tenant2-keycloak.json";
        URL config1Url = AbstractServletsAdapterTest.class.getResource(webInfPath + config1);
        Assert.assertNotNull((String)("config1Url should be in " + webInfPath + config1), (Object)config1Url);
        URL config2Url = AbstractServletsAdapterTest.class.getResource(webInfPath + config2);
        Assert.assertNotNull((String)("config2Url should be in " + webInfPath + config2), (Object)config2Url);
        ((WebArchive)servletDeployment.add((Asset)new UrlAsset(config1Url), "/WEB-INF/classes/" + config1)).add((Asset)new UrlAsset(config2Url), "/WEB-INF/classes/" + config2);
        DeploymentArchiveProcessorUtils.modifyOIDCAdapterConfig((Archive)servletDeployment, (String)("/WEB-INF/classes/" + config1));
        DeploymentArchiveProcessorUtils.modifyOIDCAdapterConfig((Archive)servletDeployment, (String)("/WEB-INF/classes/" + config2));
        return servletDeployment;
    }

    protected static WebArchive servletDeployment(String name, Class ... servletClasses) {
        return AbstractServletsAdapterTest.servletDeployment(name, "keycloak.json", servletClasses);
    }

    protected static WebArchive servletDeployment(String name, String adapterConfig, Class ... servletClasses) {
        String webInfPath = "/adapter-test/" + name + "/WEB-INF/";
        URL keycloakJSON = AbstractServletsAdapterTest.class.getResource(webInfPath + adapterConfig);
        URL webXML = AbstractServletsAdapterTest.class.getResource(webInfPath + "web.xml");
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war"))).addClasses(servletClasses)).addAsWebInfResource(webXML, "web.xml")).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        AbstractServletsAdapterTest.addSameSiteUndertowHandlers(deployment);
        URL keystore = AbstractServletsAdapterTest.class.getResource(webInfPath + "keystore.jks");
        if (keystore != null) {
            deployment.addAsWebInfResource(keystore, "classes/keystore.jks");
        }
        if (keycloakJSON != null) {
            deployment.addAsWebInfResource(keycloakJSON, "keycloak.json");
        }
        AbstractServletsAdapterTest.addContextXml((Archive)deployment, name);
        return deployment;
    }

    public static WebArchive samlServletDeployment(String name, Class ... servletClasses) {
        return AbstractServletsAdapterTest.samlServletDeployment(name, "web.xml", servletClasses);
    }

    public static WebArchive samlServletDeployment(String name, String webXMLPath, Class ... servletClasses) {
        return AbstractServletsAdapterTest.samlServletDeployment(name, webXMLPath, null, servletClasses);
    }

    public static WebArchive samlServletDeployment(String name, String webXMLPath, Integer clockSkewSec, Class ... servletClasses) {
        return AbstractServletsAdapterTest.samlServletDeployment(name, name, webXMLPath, clockSkewSec, servletClasses);
    }

    public static WebArchive samlServletDeployment(String name, String customArchiveName, String webXMLPath, Integer clockSkewSec, Class ... servletClasses) {
        String webXMLContent;
        String baseSAMLPath = "/adapter-test/keycloak-saml/";
        String webInfPath = baseSAMLPath + name + "/WEB-INF/";
        URL keycloakSAMLConfig = AbstractServletsAdapterTest.class.getResource(webInfPath + "keycloak-saml.xml");
        Assert.assertNotNull((String)("keycloak-saml.xml should be in " + webInfPath), (Object)keycloakSAMLConfig);
        URL webXML = AbstractServletsAdapterTest.class.getResource(baseSAMLPath + webXMLPath);
        Assert.assertNotNull((String)("web.xml should be in " + baseSAMLPath + webXMLPath), (Object)keycloakSAMLConfig);
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(customArchiveName + ".war"))).addClasses(servletClasses)).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        AbstractServletsAdapterTest.addSameSiteUndertowHandlers(deployment);
        URL roleMappingsConfig = AbstractServletsAdapterTest.class.getResource(webInfPath + "role-mappings.properties");
        if (roleMappingsConfig != null) {
            deployment.addAsWebInfResource(roleMappingsConfig, "role-mappings.properties");
        }
        try {
            webXMLContent = IOUtils.toString((InputStream)webXML.openStream(), (Charset)Charset.forName("UTF-8")).replace("%CONTEXT_PATH%", name);
            if (clockSkewSec != null) {
                String keycloakSamlXMLContent = IOUtils.toString((InputStream)keycloakSAMLConfig.openStream(), (Charset)Charset.forName("UTF-8")).replace("%CLOCK_SKEW%", "${allowed.clock.skew:" + String.valueOf(clockSkewSec) + "}");
                deployment.addAsWebInfResource((Asset)new StringAsset(keycloakSamlXMLContent), "keycloak-saml.xml");
            } else {
                deployment.addAsWebInfResource(keycloakSAMLConfig, "keycloak-saml.xml");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        deployment.add((Asset)new StringAsset(webXMLContent), "/WEB-INF/web.xml");
        URL keystore = AbstractServletsAdapterTest.class.getResource(webInfPath + "keystore.jks");
        if (keystore != null) {
            deployment.addAsWebInfResource(keystore, "keystore.jks");
        }
        AbstractServletsAdapterTest.addContextXml((Archive)deployment, name);
        return deployment;
    }

    public static WebArchive samlServletDeploymentMultiTenant(String name, String webXMLPath, String config1, String config2, String keystore1, String keystore2, Class ... servletClasses) {
        String webXMLContent;
        String baseSAMLPath = "/adapter-test/keycloak-saml/";
        String webInfPath = baseSAMLPath + name + "/WEB-INF/";
        URL webXML = AbstractServletsAdapterTest.class.getResource(baseSAMLPath + webXMLPath);
        Assert.assertNotNull((String)("web.xml should be in " + baseSAMLPath + webXMLPath), (Object)webXML);
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war"))).addClasses(servletClasses)).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        AbstractServletsAdapterTest.addSameSiteUndertowHandlers(deployment);
        try {
            webXMLContent = IOUtils.toString((InputStream)webXML.openStream(), (Charset)Charset.forName("UTF-8")).replace("%CONTEXT_PATH%", name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        deployment.add((Asset)new StringAsset(webXMLContent), "/WEB-INF/web.xml");
        URL config1Url = AbstractServletsAdapterTest.class.getResource(webInfPath + config1);
        Assert.assertNotNull((String)("config1Url should be in " + webInfPath + config1), (Object)config1Url);
        deployment.add((Asset)new UrlAsset(config1Url), "/WEB-INF/classes/" + config1);
        URL config2Url = AbstractServletsAdapterTest.class.getResource(webInfPath + config2);
        Assert.assertNotNull((String)("config2Url should be in " + webInfPath + config2), (Object)config2Url);
        deployment.add((Asset)new UrlAsset(config2Url), "/WEB-INF/classes/" + config2);
        URL keystore1Url = AbstractServletsAdapterTest.class.getResource(webInfPath + keystore1);
        Assert.assertNotNull((String)("keystore1Url should be in " + webInfPath + keystore1), (Object)keystore1Url);
        deployment.add((Asset)new UrlAsset(keystore1Url), "/WEB-INF/classes/" + keystore1);
        URL keystore2Url = AbstractServletsAdapterTest.class.getResource(webInfPath + keystore2);
        Assert.assertNotNull((String)("keystore2Url should be in " + webInfPath + keystore2), (Object)keystore2Url);
        deployment.add((Asset)new UrlAsset(keystore2Url), "/WEB-INF/classes/" + keystore2);
        AbstractServletsAdapterTest.addContextXml((Archive)deployment, name);
        return deployment;
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/demorealm.json"));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
    }

    protected void setAdapterAndServerTimeOffset(int timeOffset, String ... servletUris) {
        this.setTimeOffset(timeOffset);
        for (String servletUri : servletUris) {
            this.setAdapterServletTimeOffset(timeOffset, servletUri);
        }
    }

    protected void setAdapterServletTimeOffset(int timeOffset, String servletUri) {
        String timeOffsetUri = UriBuilder.fromUri((String)servletUri).queryParam("timeOffset", new Object[]{timeOffset}).build(new Object[0]).toString();
        DroneUtils.getCurrentDriver().navigate().to(timeOffsetUri);
        WaitUtils.waitForPageToLoad();
        String pageSource = DroneUtils.getCurrentDriver().getPageSource();
        this.log.info((Object)pageSource);
    }
}

