/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpGet;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Retry;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.AbstractAdapterClusteredTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.io.IOUtil;

public abstract class AbstractSAMLAdapterClusteredTest
extends AbstractAdapterClusteredTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml-behind-lb.json"));
        if (!"localhost".equals(ServerURLs.APP_SERVER_HOST)) {
            for (RealmRepresentation realm : testRealms) {
                Optional<ClientRepresentation> clientRepresentation = realm.getClients().stream().filter(c -> c.getClientId().equals("http://localhost:8580/employee-distributable/")).findFirst();
                clientRepresentation.ifPresent(cr -> {
                    cr.setBaseUrl(cr.getBaseUrl().replace("localhost", ServerURLs.APP_SERVER_HOST));
                    cr.setRedirectUris(cr.getRedirectUris().stream().map(url -> url.replace("localhost", ServerURLs.APP_SERVER_HOST)).collect(Collectors.toList()));
                    cr.setAttributes(cr.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String)entry.getValue()).replace("localhost", ServerURLs.APP_SERVER_HOST))));
                });
            }
        }
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmSAMLPostLoginPage.setAuthRealm("demo");
        this.loginPage.setAuthRealm("demo");
        this.loginActionsPage.setAuthRealm("demo");
    }

    @Override
    protected void deploy() {
        this.deployer.deploy("employee-distributable");
        this.deployer.deploy("employee-distributable_2");
    }

    @Override
    protected void undeploy() {
        this.deployer.undeploy("employee-distributable");
        this.deployer.undeploy("employee-distributable_2");
    }

    private void testLogoutViaSessionIndex(URL employeeUrl, boolean forceRefreshAtOtherNode, BiConsumer<SamlClientBuilder, String> logoutFunction) {
        Users.setPasswordFor((UserRepresentation)this.bburkeUser, (String)"password");
        String employeeUrlString = this.getProxiedUrl(employeeUrl);
        SamlClientBuilder builder = new SamlClientBuilder().navigateTo(employeeUrlString).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).build().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))).addStep(() -> this.updateProxy("ha-node-2", NODE_2_URI, NODE_1_URI));
        if (forceRefreshAtOtherNode) {
            builder.navigateTo(employeeUrlString).doNotFollowRedirects().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke")));
        }
        logoutFunction.accept(builder, employeeUrlString);
        SamlClient samlClient = builder.execute();
        this.delayedCheckLoggedOut(samlClient, employeeUrlString);
        this.updateProxy("ha-node-1", NODE_1_URI, NODE_2_URI);
        this.delayedCheckLoggedOut(samlClient, employeeUrlString);
    }

    private void delayedCheckLoggedOut(SamlClient samlClient, String url) {
        Retry.execute(() -> samlClient.execute(new SamlClient.Step[]{(client, currentURI, currentResponse, context) -> new HttpGet(url), (client, currentURI, currentResponse, context) -> {
            Assert.assertThat((Object)currentResponse, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))));
            return null;
        }}), (int)10, (long)300L);
    }

    private void logoutViaAdminConsole() {
        RealmResource demoRealm = this.adminClient.realm("demo");
        String bburkeId = ApiUtil.findUserByUsername((RealmResource)demoRealm, (String)"bburke").getId();
        demoRealm.users().get(bburkeId).logout();
        this.log.infov("Logged out via admin console", new Object[0]);
    }

    @Test
    public void testAdminInitiatedBackchannelLogout(@ArquillianResource @OperateOnDeployment(value="employee-distributable") URL employeeUrl) throws Exception {
        this.testLogoutViaSessionIndex(employeeUrl, false, (builder, url) -> builder.addStep(this::logoutViaAdminConsole));
    }

    @Test
    public void testAdminInitiatedBackchannelLogoutWithAssertionOfLoggedIn(@ArquillianResource @OperateOnDeployment(value="employee-distributable") URL employeeUrl) throws Exception {
        this.testLogoutViaSessionIndex(employeeUrl, true, (builder, url) -> builder.addStep(this::logoutViaAdminConsole));
    }

    @Test
    public void testUserInitiatedFrontchannelLogout(@ArquillianResource @OperateOnDeployment(value="employee-distributable") URL employeeUrl) throws Exception {
        this.testLogoutViaSessionIndex(employeeUrl, false, (builder, url) -> builder.navigateTo(url + "?GLO=true").processSamlResponse(SamlClient.Binding.POST).build().processSamlResponse(SamlClient.Binding.POST).build());
    }

    @Test
    public void testUserInitiatedFrontchannelLogoutWithAssertionOfLoggedIn(@ArquillianResource @OperateOnDeployment(value="employee-distributable") URL employeeUrl) throws Exception {
        this.testLogoutViaSessionIndex(employeeUrl, true, (builder, url) -> builder.navigateTo(url + "?GLO=true").processSamlResponse(SamlClient.Binding.POST).build().processSamlResponse(SamlClient.Binding.POST).build());
    }

    @Test
    public void testNodeRestartResiliency(@ArquillianResource @OperateOnDeployment(value="employee-distributable") URL employeeUrl) throws Exception {
        ContainerInfo containerInfo = (ContainerInfo)this.testContext.getAppServerBackendsInfo().get(0);
        Users.setPasswordFor((UserRepresentation)this.bburkeUser, (String)"password");
        String employeeUrlString = this.getProxiedUrl(employeeUrl);
        SamlClient samlClient = new SamlClientBuilder().navigateTo(employeeUrlString).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).build().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))).execute();
        this.controller.stop(containerInfo.getQualifier());
        this.updateProxy("ha-node-2", NODE_2_URI, NODE_1_URI);
        samlClient.execute(new SamlClientBuilder().navigateTo(employeeUrlString).doNotFollowRedirects().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))).getSteps());
        this.controller.start(containerInfo.getQualifier());
        this.updateProxy("ha-node-1", NODE_1_URI, NODE_2_URI);
        samlClient.execute(new SamlClientBuilder().navigateTo(employeeUrlString).doNotFollowRedirects().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))).getSteps());
    }
}

