/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.AfterClass;
import org.junit.Before;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.AppServerContextRoot;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ServerURLs;

@AppServerContainer(value="")
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractAdapterTest
extends AbstractAuthTest {
    @Page
    protected AppServerContextRoot appServerContextRootPage;
    public static final String JBOSS_DEPLOYMENT_STRUCTURE_XML = "jboss-deployment-structure.xml";
    public static final URL jbossDeploymentStructure = AbstractServletsAdapterTest.class.getResource("/adapter-test/jboss-deployment-structure.xml");
    public static final String UNDERTOW_HANDLERS_CONF = "undertow-handlers.conf";
    public static final URL undertowHandlersConf = AbstractServletsAdapterTest.class.getResource("/adapter-test/samesite/undertow-handlers.conf");
    public static final String TOMCAT_CONTEXT_XML = "context.xml";
    public static final URL tomcatContext = AbstractServletsAdapterTest.class.getResource("/adapter-test/context.xml");
    protected static boolean sslConfigured = false;

    @Before
    public void setUpAppServer() throws Exception {
        if (!sslConfigured && this.shouldConfigureSSL()) {
            AppServerTestEnricher.enableHTTPSForAppServer();
            sslConfigured = true;
        }
    }

    @AfterClass
    public static void resetSSLConfig() {
        sslConfigured = false;
    }

    protected boolean shouldConfigureSSL() {
        return AppServerTestEnricher.APP_SERVER_SSL_REQUIRED && (AppServerTestEnricher.CURRENT_APP_SERVER.contains("eap") || AppServerTestEnricher.CURRENT_APP_SERVER.contains("wildfly"));
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.addAdapterTestRealms(testRealms);
        for (RealmRepresentation tr : testRealms) {
            this.log.info((Object)("Setting redirect-uris in test realm '" + tr.getRealm() + "' as " + (this.isRelative() ? "" : "non-") + "relative"));
            this.modifyClientRedirectUris(tr, "http://localhost:8080", "");
            this.modifyClientRedirectUris(tr, "^((?:/.*|)/\\*)", ServerURLs.getAppServerContextRoot() + "$1", ServerURLs.getAuthServerContextRoot() + "$1");
            this.modifyClientWebOrigins(tr, "http://localhost:8080", ServerURLs.getAppServerContextRoot(), ServerURLs.getAuthServerContextRoot());
            this.modifyClientUrls(tr, "http://localhost:8080", "");
            this.modifySamlMasterURLs(tr, "http://localhost:8080", "");
            this.modifySAMLClientsAttributes(tr, "http://localhost:8080", "");
            if (this.isRelative()) {
                this.modifyClientUrls(tr, ServerURLs.getAppServerContextRoot().toString(), "");
                this.modifySamlMasterURLs(tr, "/", ServerURLs.getAppServerContextRoot() + "/");
                this.modifySAMLClientsAttributes(tr, "8080", ServerURLs.AUTH_SERVER_PORT);
            } else {
                this.modifyClientUrls(tr, "^(/.*)", ServerURLs.getAppServerContextRoot() + "$1");
                this.modifySamlMasterURLs(tr, "^(/.*)", ServerURLs.getAppServerContextRoot() + "$1");
                this.modifySAMLClientsAttributes(tr, "^(/.*)", ServerURLs.getAppServerContextRoot() + "$1");
                this.modifyClientJWKSUrl(tr, "^(/.*)", ServerURLs.getAppServerContextRoot() + "$1");
            }
            if (!ServerURLs.AUTH_SERVER_SSL_REQUIRED) continue;
            tr.setSslRequired("all");
        }
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    private void modifyClientJWKSUrl(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            realm.getClients().stream().filter(client -> "client-jwt".equals(client.getClientAuthenticatorType()) && client.getAttributes().containsKey("jwks.url")).forEach(client -> {
                Map attr = client.getAttributes();
                attr.put("jwks.url", ((String)attr.get("jwks.url")).replaceFirst(regex, replacement));
                client.setAttributes(attr);
            });
        }
    }

    public abstract void addAdapterTestRealms(List<RealmRepresentation> var1);

    public boolean isRelative() {
        return this.testContext.isRelativeAdapterTest();
    }

    protected void modifyClientRedirectUris(RealmRepresentation realm, String regex, String ... replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                List redirectUris = client.getRedirectUris();
                if (redirectUris == null) continue;
                ArrayList<String> newRedirectUris = new ArrayList<String>();
                for (String uri : redirectUris) {
                    for (String uriReplacement : replacement) {
                        newRedirectUris.add(uri.replaceAll(regex, uriReplacement));
                    }
                }
                client.setRedirectUris(newRedirectUris);
            }
        }
    }

    protected void modifyClientUrls(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                String adminUrl;
                String baseUrl = client.getBaseUrl();
                if (baseUrl != null) {
                    client.setBaseUrl(baseUrl.replaceAll(regex, replacement));
                }
                if ((adminUrl = client.getAdminUrl()) == null) continue;
                client.setAdminUrl(adminUrl.replaceAll(regex, replacement));
            }
        }
    }

    protected void modifyClientWebOrigins(RealmRepresentation realm, String regex, String ... replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                List webOrigins = client.getWebOrigins();
                if (webOrigins == null) continue;
                ArrayList<String> newWebOrigins = new ArrayList<String>();
                for (String uri : webOrigins) {
                    for (String originReplacement : replacement) {
                        newWebOrigins.add(uri.replaceAll(regex, originReplacement));
                    }
                }
                client.setWebOrigins(newWebOrigins);
            }
        }
    }

    protected void modifySAMLClientsAttributes(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                if (client.getProtocol() == null || !client.getProtocol().equals("saml")) continue;
                this.log.debug((Object)("Modifying attributes of SAML client: " + client.getClientId()));
                for (Map.Entry entry : client.getAttributes().entrySet()) {
                    client.getAttributes().put((String)entry.getKey(), ((String)entry.getValue()).replaceAll(regex, replacement));
                }
            }
        }
    }

    protected void modifySamlMasterURLs(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                if (client.getProtocol() == null || !client.getProtocol().equals("saml")) continue;
                this.log.debug((Object)("Modifying master URL of SAML client: " + client.getClientId()));
                String masterUrl = client.getAdminUrl();
                if (masterUrl == null) {
                    masterUrl = client.getBaseUrl();
                }
                masterUrl = masterUrl.replaceFirst(regex, replacement);
                client.setAdminUrl(masterUrl + (!masterUrl.endsWith("/saml") ? "/saml" : ""));
            }
        }
    }

    protected void fixClientUrisUsingDeploymentUrl(RealmRepresentation realm, String clientId, String deploymentUrl) {
        for (ClientRepresentation client : realm.getClients()) {
            List redirectUris;
            if (!clientId.equals(client.getClientId())) continue;
            if (client.getBaseUrl() != null) {
                client.setBaseUrl(deploymentUrl);
            }
            if (client.getAdminUrl() != null) {
                client.setAdminUrl(deploymentUrl);
            }
            if ((redirectUris = client.getRedirectUris()) == null) continue;
            ArrayList<String> newRedirectUris = new ArrayList<String>();
            for (String uri : redirectUris) {
                newRedirectUris.add(deploymentUrl + "/*");
            }
            client.setRedirectUris(newRedirectUris);
        }
    }

    public static void addContextXml(Archive archive, String contextPath) {
        try {
            String contextXmlContent = IOUtils.toString((InputStream)tomcatContext.openStream(), (String)"UTF-8").replace("%CONTEXT_PATH%", contextPath);
            archive.add((Asset)new StringAsset(contextXmlContent), "/META-INF/context.xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void addSameSiteUndertowHandlers(WebArchive archive) {
        if (SuiteContext.BROWSER_STRICT_COOKIES) {
            archive.addAsWebInfResource(undertowHandlersConf, UNDERTOW_HANDLERS_CONF);
        }
    }
}

