/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.TermsAndConditionsPage;
import org.keycloak.testsuite.util.UserBuilder;

public class TermsAndConditionsTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected TermsAndConditionsPage termsPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void addTermsAndConditionRequiredAction() {
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        UserBuilder.edit(user).requiredAction("terms_and_conditions");
        this.adminClient.realm("test").users().get(user.getId()).update(user);
        RequiredActionProviderRepresentation rep = this.adminClient.realm("test").flows().getRequiredAction("terms_and_conditions");
        rep.setEnabled(true);
        this.adminClient.realm("test").flows().updateRequiredAction("terms_and_conditions", rep);
    }

    @Test
    public void termsAccepted() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.termsPage.isCurrent());
        this.termsPage.acceptTerms();
        this.events.expectRequiredAction(EventType.CUSTOM_REQUIRED_ACTION).removeDetail("redirect_uri").detail("custom_required_action", "terms_and_conditions").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Map attributes = user.getAttributes();
        Assert.assertNotNull((String)"timestamp for terms acceptance was not stored in user attributes", (Object)attributes);
        List termsAndConditions = (List)attributes.get("terms_and_conditions");
        Assert.assertTrue((String)"timestamp for terms acceptance was not stored in user attributes as terms_and_conditions", (termsAndConditions.size() == 1 ? 1 : 0) != 0);
        String timestamp = (String)termsAndConditions.get(0);
        Assert.assertNotNull((String)"expected non-null timestamp for terms acceptance in user attribute terms_and_conditions", (Object)timestamp);
        try {
            Integer.parseInt(timestamp);
        }
        catch (NumberFormatException e) {
            Assert.fail((String)("timestamp for terms acceptance is not a valid integer: '" + timestamp + "'"));
        }
    }

    @Test
    public void termsDeclined() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.termsPage.isCurrent());
        this.termsPage.declineTerms();
        this.events.expectLogin().event(EventType.CUSTOM_REQUIRED_ACTION_ERROR).detail("custom_required_action", "terms_and_conditions").error("rejected_by_user").removeDetail("consent").session((Matcher<String>)Matchers.nullValue(String.class)).assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Map attributes = user.getAttributes();
        if (attributes != null) {
            Assert.assertNull((String)"expected null for terms acceptance user attribute terms_and_conditions", attributes.get("terms_and_conditions"));
        }
    }

    @Test
    public void termsDisabled() {
        RequiredActionProviderRepresentation rep = this.adminClient.realm("test").flows().getRequiredAction("terms_and_conditions");
        rep.setEnabled(false);
        this.adminClient.realm("test").flows().updateRequiredAction("terms_and_conditions", rep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.events.expectLogin().assertEvent();
    }
}

