/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.LinkedList;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.SecondBrowser;
import org.openqa.selenium.WebDriver;

public class RequiredActionResetPasswordTest
extends AbstractTestRealmKeycloakTest {
    @Drone
    @SecondBrowser
    private WebDriver driver2;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
    }

    @After
    public void after() {
        ApiUtil.resetUserPassword((UserResource)this.testRealm().users().get(this.findUser("test-user@localhost").getId()), (String)"password", (boolean)false);
    }

    @Test
    public void tempPassword() throws Exception {
        this.requireUpdatePassword();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        Assert.assertFalse((boolean)this.changePasswordPage.isCancelDisplayed());
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "new-password");
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void logoutSessionsCheckboxNotPresent() {
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        UserResource testUser = this.testRealm().users().get(this.findUser("test-user@localhost").getId());
        oauth2.doLogin("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        Assert.assertEquals((long)1L, (long)testUser.getUserSessions().size());
        this.requireUpdatePassword();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        Assert.assertFalse((boolean)this.changePasswordPage.isLogoutSessionDisplayed());
        this.changePasswordPage.changePassword("All Right Then, Keep Your Secrets", "All Right Then, Keep Your Secrets");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.events.expectLogin().assertEvent();
        Assert.assertEquals((String)"All sessions are still active", (long)2L, (long)testUser.getUserSessions().size());
    }

    private void requireUpdatePassword() {
        UserRepresentation userRep = this.findUser("test-user@localhost");
        if (userRep.getRequiredActions() == null) {
            userRep.setRequiredActions(new LinkedList());
        }
        userRep.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        this.testRealm().users().get(userRep.getId()).update(userRep);
    }
}

