/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;
import org.keycloak.testsuite.pages.TermsAndConditionsPage;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RequiredActionPriorityTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;
    @Page
    protected TermsAndConditionsPage termsPage;
    @Page
    protected LoginConfigTotpPage totpPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setupRequiredActions() {
        this.setRequiredActionEnabled("test", "terms_and_conditions", true, false);
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").build();
        String testUserId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
        this.setRequiredActionEnabled("test", testUserId, UserModel.RequiredAction.UPDATE_PASSWORD.name(), true);
        this.setRequiredActionEnabled("test", testUserId, UserModel.RequiredAction.UPDATE_PROFILE.name(), true);
        this.setRequiredActionEnabled("test", testUserId, "terms_and_conditions", true);
    }

    @Test
    public void executeRequiredActionsWithDefaultPriority() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.termsPage.assertCurrent();
        this.termsPage.acceptTerms();
        this.events.expectRequiredAction(EventType.CUSTOM_REQUIRED_ACTION).removeDetail("redirect_uri").detail("custom_required_action", "terms_and_conditions").assertEvent();
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("updated_first_name", "New first").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void executeRequiredActionsWithCustomPriority() throws Exception {
        this.testRealm().flows().raiseRequiredActionPriority(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        this.testRealm().flows().lowerRequiredActionPriority("terms_and_conditions");
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("updated_first_name", "New first").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.termsPage.assertCurrent();
        this.termsPage.acceptTerms();
        this.events.expectRequiredAction(EventType.CUSTOM_REQUIRED_ACTION).removeDetail("redirect_uri").detail("custom_required_action", "terms_and_conditions").assertEvent();
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void setupTotpAfterUpdatePassword() {
        String testUserId = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost").getId();
        this.setRequiredActionEnabled("test", testUserId, UserModel.RequiredAction.CONFIGURE_TOTP.name(), true);
        this.setRequiredActionEnabled("test", testUserId, UserModel.RequiredAction.UPDATE_PASSWORD.name(), true);
        this.setRequiredActionEnabled("test", testUserId, "terms_and_conditions", false);
        this.setRequiredActionEnabled("test", testUserId, UserModel.RequiredAction.UPDATE_PROFILE.name(), false);
        this.testRealm().flows().raiseRequiredActionPriority(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        this.testRealm().flows().raiseRequiredActionPriority(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.totpPage.assertCurrent();
        this.totpPage.clickManual();
        String pageSource = this.driver.getPageSource();
        MatcherAssert.assertThat((Object)pageSource, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Unable to scan?")));
        MatcherAssert.assertThat((Object)pageSource, (Matcher)Matchers.containsString((String)"Scan barcode?"));
        TimeBasedOTP totp = new TimeBasedOTP();
        this.totpPage.configure(totp.generateTOTP(this.totpPage.getTotpSecret()), "userLabel");
        this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent();
        this.appPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.appPage.getRequestType(), (Matcher)Matchers.is((Object)AppPage.RequestType.AUTH_RESPONSE));
        this.events.expectLogin().assertEvent();
    }
}

