/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;

public class RequiredActionMultipleActionsTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PASSWORD.name());
    }

    @Test
    public void updateProfileAndPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String codeId = null;
        if (this.changePasswordPage.isCurrent()) {
            codeId = this.updatePassword(codeId);
            this.updateProfilePage.assertCurrent();
            this.updateProfile(codeId);
        } else if (this.updateProfilePage.isCurrent()) {
            codeId = this.updateProfile(codeId);
            this.changePasswordPage.assertCurrent();
            this.updatePassword(codeId);
        } else {
            Assert.fail((String)"Expected to update password and profile before login");
        }
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().session(codeId).assertEvent();
    }

    public String updatePassword(String codeId) {
        this.changePasswordPage.changePassword("new-password", "new-password");
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD);
        if (codeId != null) {
            expectedEvent.detail("code_id", codeId);
        }
        return (String)expectedEvent.assertEvent().getDetails().get("code_id");
    }

    public String updateProfile(String codeId) {
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("updated_first_name", "New first").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com");
        if (codeId != null) {
            expectedEvent.detail("code_id", codeId);
        }
        return (String)expectedEvent.assertEvent().getDetails().get("code_id");
    }
}

