/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.actions.AbstractAppInitiatedActionTest;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;
import org.keycloak.testsuite.util.UserBuilder;

public class AppInitiatedActionUpdateProfileTest
extends AbstractAppInitiatedActionTest {
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;
    @Page
    protected ErrorPage errorPage;

    public AppInitiatedActionUpdateProfileTest() {
        super(UserModel.RequiredAction.UPDATE_PROFILE.name());
    }

    protected boolean isDynamicForm() {
        return false;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void beforeTest() {
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").firstName("Tom").lastName("Brady").build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"john-doh@localhost");
        user = UserBuilder.create().enabled(true).username("john-doh@localhost").email("john-doh@localhost").firstName("John").lastName("Doh").build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void updateProfile() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("previous_first_name", "Tom").detail("updated_first_name", "New first").detail("previous_last_name", "Brady").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.events.expectLogin().assertEvent();
        this.assertKcActionStatus("success");
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)user.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
    }

    @Test
    public void updateProfileLoginFirst() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.doAIA();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectLogin().assertEvent();
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("previous_first_name", "Tom").detail("updated_first_name", "New first").detail("previous_last_name", "Brady").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.events.expectLogin().assertEvent();
        this.assertKcActionStatus("success");
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)user.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
    }

    @Test
    public void cancelUpdateProfile() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.cancel();
        this.assertKcActionStatus("cancelled");
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"Tom", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)user.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
    }

    @Test
    public void updateUsername() {
        this.doAIA();
        this.loginPage.login("john-doh@localhost", "password");
        String userId = ActionUtil.findUserWithAdminClient(this.adminClient, "john-doh@localhost").getId();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "john-doh@localhost", "new");
        this.events.expectLogin().event(EventType.UPDATE_PROFILE).detail("previous_first_name", "John").detail("updated_first_name", "New first").detail("previous_last_name", "Doh").detail("updated_last_name", "New last").detail("username", "john-doh@localhost").user(userId).session((Matcher<String>)Matchers.nullValue(String.class)).removeDetail("consent").assertEvent();
        this.assertKcActionStatus("success");
        this.events.expectLogin().detail("username", "john-doh@localhost").user(userId).assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "new");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"john-doh@localhost", (Object)user.getEmail());
        Assert.assertEquals((Object)"new", (Object)user.getUsername());
        this.getCleanup().addUserId(user.getId());
    }

    @Test
    public void updateProfileMissingFirstName() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("", "New last", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        if (this.isDynamicForm()) {
            Assert.assertEquals((Object)"Please specify this field.", (Object)this.updateProfilePage.getInputErrors().getFirstNameError());
        } else {
            Assert.assertEquals((Object)"Please specify first name.", (Object)this.updateProfilePage.getInputErrors().getFirstNameError());
        }
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingLastName() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        if (this.isDynamicForm()) {
            Assert.assertEquals((Object)"Please specify this field.", (Object)this.updateProfilePage.getInputErrors().getLastNameError());
        } else {
            Assert.assertEquals((Object)"Please specify last name.", (Object)this.updateProfilePage.getInputErrors().getLastNameError());
        }
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingEmail() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Please specify email.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileInvalidEmail() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "invalidemail", "invalid");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"invalidemail", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingUsername() {
        this.doAIA();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Please specify username.", (Object)this.updateProfilePage.getInputErrors().getUsernameError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicateUsername() {
        this.doAIA();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Username already exists.", (Object)this.updateProfilePage.getInputErrors().getUsernameError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicatedEmail() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "keycloak-user@localhost", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"keycloak-user@localhost", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Email already exists.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileExpiredCookies() {
        this.doAIA();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.driver.manage().deleteAllCookies();
        this.updateProfilePage.update("New first", "New last", "keycloak-user@localhost", "test-user@localhost");
        this.errorPage.assertCurrent();
        String backToAppLink = this.errorPage.getBackToApplicationLink();
        ClientRepresentation client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").toRepresentation();
        Assert.assertEquals((Object)backToAppLink, (Object)client.getBaseUrl());
    }
}

