/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AppInitiatedActionTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void executeUnknownAction() {
        this.oauth.kcAction("nosuch").openLoginForm();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String kcActionStatus = (String)this.oauth.getCurrentQuery().get("kc_action_status");
        Assert.assertEquals((Object)"error", (Object)kcActionStatus);
    }

    @Test
    public void executeUnsupportedAction() {
        this.oauth.kcAction("terms_and_conditions").openLoginForm();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String kcActionStatus = (String)this.oauth.getCurrentQuery().get("kc_action_status");
        Assert.assertEquals((Object)"error", (Object)kcActionStatus);
    }

    @Test
    public void executeDisabledAction() {
        RequiredActionProviderRepresentation configureTotp = this.testRealm().flows().getRequiredAction("CONFIGURE_TOTP");
        configureTotp.setEnabled(false);
        try {
            this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", configureTotp);
            this.oauth.kcAction(UserModel.RequiredAction.CONFIGURE_TOTP.name()).openLoginForm();
            this.loginPage.login("test-user@localhost", "password");
            Assert.assertTrue((boolean)this.appPage.isCurrent());
            String kcActionStatus = (String)this.oauth.getCurrentQuery().get("kc_action_status");
            Assert.assertEquals((Object)"error", (Object)kcActionStatus);
        }
        finally {
            configureTotp.setEnabled(true);
            this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", configureTotp);
        }
    }
}

