/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account.custom;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class CustomThemeTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setAccountTheme("address");
        UserRepresentation user2 = UserBuilder.create().enabled(true).username("test-user-no-access@localhost").email("test-user-no-access@localhost").password("password").build();
        RealmBuilder.edit(testRealm).user(user2);
    }

    @Test
    public void changeProfile() throws Exception {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getAttribute("street"));
        this.profilePage.updateAttribute("street", "Elm 1");
        Assert.assertEquals((Object)"Elm 1", (Object)this.profilePage.getAttribute("street"));
        this.profilePage.updateAttribute("street", "Elm 2");
        Assert.assertEquals((Object)"Elm 2", (Object)this.profilePage.getAttribute("street"));
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
    }
}

