/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.account.custom.AbstractCustomAccountManagementTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.auth.page.login.OneTimeCode;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.openqa.selenium.WebDriver;

public class CustomAuthFlowOTPTest
extends AbstractCustomAccountManagementTest {
    private final TimeBasedOTP totp = new TimeBasedOTP();
    @Page
    private OneTimeCode testLoginOneTimeCodePage;
    @Page
    private LoginConfigTotpPage loginConfigTotpPage;

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testLoginOneTimeCodePage.setAuthRealm(this.testRealmPage);
    }

    @Override
    @Before
    public void beforeTest() {
        super.beforeTest();
    }

    private void configureRequiredActions() {
        ArrayList<String> requiredActions = new ArrayList<String>();
        requiredActions.add(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        this.testUser.setRequiredActions(requiredActions);
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
    }

    private void configureOTP() {
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        String totpSecret = this.testRealmLoginPage.form().totpForm().getTotpSecret();
        this.testRealmLoginPage.form().totpForm().setTotp(this.totp.generateTOTP(totpSecret));
        this.testRealmLoginPage.form().totpForm().submit();
        this.testRealmAccountManagementPage.signOut();
        this.testUser = this.testRealmResource().users().get(this.testUser.getId()).toRepresentation();
        Users.setPasswordFor((UserRepresentation)this.testUser, (String)"password");
        Assert.assertTrue((boolean)this.testUser.getRequiredActions().isEmpty());
    }

    @Test
    public void requireOTPTest() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setBrowserFlow("browser");
        this.testRealmResource().update(realm);
        this.updateRequirement("browser", AuthenticationExecutionModel.Requirement.REQUIRED, (AuthenticationExecutionInfoRepresentation authExec) -> authExec.getDisplayName().equals("Browser - Conditional OTP"));
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void conditionalOTPNoDefault() {
        this.configureRequiredActions();
        this.configureOTP();
        HashMap<String, String> config = new HashMap<String, String>();
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPDefaultSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPDefaultForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void conditionalOTPNoDefaultWithChecks() {
        this.configureRequiredActions();
        this.configureOTP();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "noSuchUserSkipAttribute");
        config.put("skipOtpRole", "no_such_otp_role");
        config.put("forceOtpRole", "no_such_otp_role");
        config.put("noOtpRequiredForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        config.put("forceOtpForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPDefaultSkipWithChecks() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "noSuchUserSkipAttribute");
        config.put("skipOtpRole", "no_such_otp_role");
        config.put("forceOtpRole", "no_such_otp_role");
        config.put("noOtpRequiredForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        config.put("forceOtpForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPDefaultForceWithChecks() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "noSuchUserSkipAttribute");
        config.put("skipOtpRole", "no_such_otp_role");
        config.put("forceOtpRole", "no_such_otp_role");
        config.put("noOtpRequiredForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        config.put("forceOtpForHeaderPattern", "NoSuchHost: nolocalhost:65536");
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPUserAttributeSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "userSkipAttribute");
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testUser.singleAttribute("userSkipAttribute", "skip");
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPUserAttributeForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "userSkipAttribute");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testUser.singleAttribute("userSkipAttribute", "force");
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPRoleSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("skipOtpRole", "otp_role");
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        RoleRepresentation role = this.getOrCreateOTPRole();
        ArrayList<RoleRepresentation> realmRoles = new ArrayList<RoleRepresentation>();
        realmRoles.add(role);
        this.testRealmResource().users().get(this.testUser.getId()).roles().realmLevel().add(realmRoles);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPRoleForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("forceOtpRole", "otp_role");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        RoleRepresentation role = this.getOrCreateOTPRole();
        ArrayList<RoleRepresentation> realmRoles = new ArrayList<RoleRepresentation>();
        realmRoles.add(role);
        this.testRealmResource().users().get(this.testUser.getId()).roles().realmLevel().add(realmRoles);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPRoleForceViaGroup() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("forceOtpRole", "otp_role");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        GroupRepresentation group = this.getOrCreateOTPRoleInGroup();
        this.testRealmResource().users().get(this.testUser.getId()).joinGroup(group.getId());
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertTrue((boolean)this.loginConfigTotpPage.isCurrent());
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    private RoleRepresentation getOrCreateOTPRole() {
        try {
            return this.testRealmResource().roles().get("otp_role").toRepresentation();
        }
        catch (NotFoundException ex) {
            RoleRepresentation role = new RoleRepresentation("otp_role", "", false);
            this.testRealmResource().roles().create(role);
            return this.testRealmResource().roles().get("otp_role").toRepresentation();
        }
    }

    private GroupRepresentation getOrCreateOTPRoleInGroup() {
        GroupRepresentation group = new GroupRepresentation();
        group.setName("otp_group");
        RoleRepresentation role = this.getOrCreateOTPRole();
        this.testRealmResource().groups().add(group);
        GroupRepresentation groupRep = (GroupRepresentation)this.testRealmResource().groups().groups("otp_group", Integer.valueOf(0), Integer.valueOf(1)).get(0);
        this.testRealmResource().groups().group(groupRep.getId()).roles().realmLevel().add(Arrays.asList(role));
        return (GroupRepresentation)this.testRealmResource().groups().groups("otp_group", Integer.valueOf(0), Integer.valueOf(1)).get(0);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void conditionalOTPRequestHeaderSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        String port = ServerURLs.AUTH_SERVER_PORT;
        config.put("noOtpRequiredForHeaderPattern", "Host: localhost:" + port);
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void conditionalOTPRequestHeaderForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        String port = ServerURLs.AUTH_SERVER_PORT;
        config.put("forceOtpForHeaderPattern", "Host: localhost:" + port);
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        Assert.assertEquals((Object)PageUtils.getPageTitle((WebDriver)this.driver), (Object)"Mobile Authenticator Setup");
        this.configureOTP();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    private void setConditionalOTPForm(Map<String, String> config) {
        List authFlows = this.getAuthMgmtResource().getFlows();
        for (AuthenticationFlowRepresentation flow : authFlows) {
            if (!"ConditionalOTPFlow".equals(flow.getAlias())) continue;
            RealmRepresentation realm = this.testRealmResource().toRepresentation();
            realm.setBrowserFlow("browser");
            this.testRealmResource().update(realm);
            this.getAuthMgmtResource().deleteFlow(flow.getId());
            break;
        }
        String flowAlias = "ConditionalOTPFlow";
        String provider = "auth-conditional-otp-form";
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(flowAlias);
        flow.setDescription("");
        flow.setProviderId("basic-flow");
        flow.setTopLevel(true);
        flow.setBuiltIn(false);
        Response response = this.getAuthMgmtResource().createFlow(flow);
        Assert.assertEquals((String)(flowAlias + " create success"), (long)201L, (long)response.getStatus());
        response.close();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("provider", "auth-username-password-form");
        this.getAuthMgmtResource().addExecution(flowAlias, data);
        this.updateRequirement(flowAlias, "auth-username-password-form", AuthenticationExecutionModel.Requirement.REQUIRED);
        data.clear();
        data.put("provider", provider);
        this.getAuthMgmtResource().addExecution(flowAlias, data);
        this.updateRequirement(flowAlias, provider, AuthenticationExecutionModel.Requirement.REQUIRED);
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setBrowserFlow(flowAlias);
        this.testRealmResource().update(realm);
        String executionId = this.getExecution(flowAlias, provider).getId();
        AuthenticatorConfigRepresentation authConfig = new AuthenticatorConfigRepresentation();
        authConfig.setAlias("Config alias");
        authConfig.setConfig(config);
        response = this.getAuthMgmtResource().newExecutionConfig(executionId, authConfig);
        Assert.assertEquals((String)"new execution success", (long)201L, (long)response.getStatus());
        this.getCleanup().addAuthenticationConfigId(ApiUtil.getCreatedId((Response)response));
        response.close();
    }
}

