/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.account.AbstractRestServiceTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.testsuite.util.ThirdBrowser;
import org.keycloak.testsuite.util.TokenUtil;
import org.openqa.selenium.WebDriver;

public class SessionRestServiceTest
extends AbstractRestServiceTest {
    @Drone
    @SecondBrowser
    protected WebDriver secondBrowser;
    @Drone
    @ThirdBrowser
    protected WebDriver thirdBrowser;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        super.configureTestRealm(testRealm);
        testRealm.getClients().add(ClientBuilder.create().clientId("public-client-0").name("Public Client 0").baseUrl("http://client0.example.com").redirectUris(OAuthClient.APP_ROOT + "/auth").publicClient().build());
        testRealm.getClients().add(ClientBuilder.create().clientId("public-client-1").name("Public Client 1").baseUrl("http://client1.example.com").redirectUris(OAuthClient.APP_ROOT + "/auth").publicClient().build());
        testRealm.getClients().add(ClientBuilder.create().clientId("confidential-client-0").name("Confidential Client 0").secret("secret").serviceAccount().directAccessGrants().redirectUris(OAuthClient.APP_ROOT + "/auth").build());
        testRealm.getClients().add(ClientBuilder.create().clientId("confidential-client-1").name("Confidential Client 1").secret("secret").serviceAccount().directAccessGrants().redirectUris(OAuthClient.APP_ROOT + "/auth").build());
    }

    @Test
    public void testProfilePreviewPermissions() throws IOException {
        TokenUtil noaccessToken = new TokenUtil("no-account-access", "password");
        TokenUtil viewToken = new TokenUtil("view-account-access", "password");
        Assert.assertEquals((long)403L, (long)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(noaccessToken.getToken()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doDelete((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(noaccessToken.getToken()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doDelete((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(viewToken.getToken()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doDelete((String)this.getAccountUrl("sessions/bogusId"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(noaccessToken.getToken()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doDelete((String)this.getAccountUrl("sessions/bogusId"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(viewToken.getToken()).asStatus());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testGetSessions() throws Exception {
        this.oauth.setDriver(this.secondBrowser);
        this.codeGrant("public-client-0");
        List<SessionRepresentation> sessions = this.getSessions();
        Assert.assertEquals((long)2L, (long)sessions.size());
        for (SessionRepresentation session : sessions) {
            Assert.assertNotNull((Object)session.getId());
            Assert.assertThat((Object)session.getIpAddress(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"127.0.0.1"), (Matcher)Matchers.equalTo((Object)"0:0:0:0:0:0:0:1")));
            Assert.assertTrue((session.getLastAccess() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((session.getExpires() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((session.getStarted() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)session.getClients(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"direct-grant"), (Matcher)Matchers.is((Object)"public-client-0")))));
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testGetDevicesResponse() throws Exception {
        Assume.assumeTrue((String)"Browser must be htmlunit. Otherwise we are not able to set desired BrowserHeaders", (boolean)System.getProperty("browser").equals("htmlUnit"));
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0) Gecko/20100101 Firefox/15.0.1");
        OAuthClient.AccessTokenResponse tokenResponse = this.codeGrant("public-client-0");
        this.joinSsoSession("public-client-1");
        List<DeviceRepresentation> devices = this.getDevicesOtherThanOther(tokenResponse.getAccessToken());
        Assert.assertEquals((String)"Should have a single device", (long)1L, (long)devices.size());
        DeviceRepresentation device = devices.get(0);
        Assert.assertTrue((boolean)device.getCurrent());
        Assert.assertEquals((Object)"Windows", (Object)device.getOs());
        Assert.assertEquals((Object)"10", (Object)device.getOsVersion());
        Assert.assertEquals((Object)"Other", (Object)device.getDevice());
        List sessions = device.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        SessionRepresentation session = (SessionRepresentation)sessions.get(0);
        Assert.assertEquals((Object)"127.0.0.1", (Object)session.getIpAddress());
        Assert.assertTrue((device.getLastAccess() == session.getLastAccess() ? 1 : 0) != 0);
        List clients = session.getClients();
        Assert.assertEquals((long)2L, (long)clients.size());
        Assert.assertThat((Object)session.getClients(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"public-client-0"), (Matcher)Matchers.is((Object)"public-client-1")))));
        Assert.assertThat((Object)session.getClients(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientName", (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"Public Client 0"), (Matcher)Matchers.is((Object)"Public Client 1")))));
    }

    @Test
    public void testGetDevicesSessions() throws Exception {
        ContainerAssume.assumeAuthServerUndertow();
        Assume.assumeTrue((String)"Browser must be htmlunit. Otherwise we are not able to set desired BrowserHeaders", (boolean)System.getProperty("browser").equals("htmlUnit"));
        WebDriver firstBrowser = this.oauth.getDriver();
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:15.0) Gecko/20100101 Firefox/15.0.1");
        this.codeGrant("public-client-0");
        List<DeviceRepresentation> devices = this.getDevicesOtherThanOther();
        Assert.assertEquals((String)"Should have a single device", (long)1L, (long)devices.size());
        List fedoraDevices = devices.stream().filter(deviceRepresentation -> "Fedora".equals(deviceRepresentation.getOs())).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have a single Fedora device", (long)1L, (long)fedoraDevices.size());
        fedoraDevices.stream().forEach(device -> {
            List sessions = device.getSessions();
            Assert.assertEquals((long)1L, (long)sessions.size());
            Assert.assertThat((Object)sessions, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"browser", (Matcher)Matchers.is((Object)"Firefox/15.0.1"))));
        });
        this.oauth.setDriver(this.secondBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Gecko/20100101 Firefox/15.0.1");
        this.codeGrant("public-client-0");
        devices = this.getDevicesOtherThanOther();
        Assert.assertEquals((String)"Should have two devices", (long)2L, (long)devices.size());
        fedoraDevices = devices.stream().filter(deviceRepresentation -> "Fedora".equals(deviceRepresentation.getOs())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)fedoraDevices.size());
        List windowsDevices = devices.stream().filter(deviceRepresentation -> "Windows".equals(deviceRepresentation.getOs())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)windowsDevices.size());
        windowsDevices.stream().forEach(device -> {
            List sessions = device.getSessions();
            Assert.assertEquals((long)1L, (long)sessions.size());
            Assert.assertThat((Object)sessions, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"browser", (Matcher)Matchers.is((Object)"Firefox/15.0.1"))));
        });
        this.oauth.setDriver(firstBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36 Edge/12.0");
        this.codeGrant("public-client-0");
        this.oauth.setDriver(this.secondBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Gecko/20100101 Firefox/15.0.1");
        this.codeGrant("public-client-0");
        this.oauth.setDriver(this.thirdBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Version/11.0 Safari/603.1.30");
        this.oauth.setBrowserHeader("X-Forwarded-For", "192.168.10.3");
        OAuthClient.AccessTokenResponse tokenResponse = this.codeGrant("public-client-0");
        devices = this.getDevicesOtherThanOther(tokenResponse.getAccessToken());
        Assert.assertEquals((String)"Should have a single device because all browsers (and sessions) are from the same platform (OS + OS version)", (long)1L, (long)devices.size());
        windowsDevices = devices.stream().filter(device -> "Windows".equals(device.getOs())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)windowsDevices.size());
        windowsDevices.stream().forEach(device -> {
            List sessions = device.getSessions();
            Assert.assertEquals((long)3L, (long)sessions.size());
            Assert.assertEquals((long)1L, (long)sessions.stream().filter(rep -> rep.getIpAddress().equals("127.0.0.1") && rep.getBrowser().equals("Firefox/15.0.1") && rep.getCurrent() == null).count());
            Assert.assertEquals((long)1L, (long)sessions.stream().filter(rep -> rep.getIpAddress().equals("127.0.0.1") && rep.getBrowser().equals("Edge/12.0") && rep.getCurrent() == null).count());
            Assert.assertEquals((long)1L, (long)sessions.stream().filter(rep -> rep.getIpAddress().equals("192.168.10.3") && rep.getBrowser().equals("Safari/11.0") && rep.getCurrent() != false).count());
        });
        this.oauth.setDriver(this.thirdBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (Windows 7) AppleWebKit/537.36 (KHTML, like Gecko) Version/11.0 Safari/603.1.30");
        this.oauth.setBrowserHeader("X-Forwarded-For", "192.168.10.3");
        this.codeGrant("public-client-0");
        devices = this.getDevicesOtherThanOther();
        windowsDevices = devices.stream().filter(device -> "Windows".equals(device.getOs())).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have two devices for two distinct Windows versions", (long)2L, (long)devices.size());
        Assert.assertEquals((long)2L, (long)windowsDevices.size());
        this.oauth.setDriver(firstBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (iPhone; CPU iPhone OS 5_1_1 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9B206 Safari/7534.48.3");
        this.codeGrant("public-client-0");
        this.oauth.setDriver(this.secondBrowser);
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:15.0) Gecko/20100101 Firefox/15.0.1");
        this.codeGrant("public-client-0");
        devices = this.getDevicesOtherThanOther();
        Assert.assertEquals((String)"Should have 3 devices", (long)3L, (long)devices.size());
        windowsDevices = devices.stream().filter(device -> "Windows".equals(device.getOs())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)windowsDevices.size());
        fedoraDevices = devices.stream().filter(deviceRepresentation -> "Fedora".equals(deviceRepresentation.getOs())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)fedoraDevices.size());
        List iphoneDevices = devices.stream().filter(device -> "iOS".equals(device.getOs()) && "iPhone".equals(device.getDevice())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)iphoneDevices.size());
        iphoneDevices.stream().forEach(device -> {
            Assert.assertTrue((boolean)device.isMobile());
            List sessions = device.getSessions();
            Assert.assertEquals((long)1L, (long)sessions.size());
            Assert.assertEquals((long)1L, (long)sessions.stream().filter(rep -> rep.getBrowser().equals("Mobile Safari/5.1")).count());
        });
    }

    @Test
    public void testLogout() throws IOException {
        TokenUtil viewToken = new TokenUtil("view-account-access", "password");
        String sessionId = this.oauth.doLogin("view-account-access", "password").getSessionState();
        List<SessionRepresentation> sessions = this.getSessions(viewToken.getToken());
        Assert.assertEquals((long)2L, (long)sessions.size());
        int status = SimpleHttp.doDelete((String)this.getAccountUrl("sessions/" + sessionId), (HttpClient)this.httpClient).acceptJson().auth(viewToken.getToken()).asStatus();
        Assert.assertEquals((long)403L, (long)status);
        sessions = this.getSessions(viewToken.getToken());
        Assert.assertEquals((long)2L, (long)sessions.size());
        status = SimpleHttp.doDelete((String)this.getAccountUrl("sessions/" + sessionId), (HttpClient)this.httpClient).acceptJson().auth(this.tokenUtil.getToken()).asStatus();
        Assert.assertEquals((long)204L, (long)status);
        sessions = this.getSessions(this.tokenUtil.getToken());
        Assert.assertEquals((long)1L, (long)sessions.size());
    }

    @Test
    public void testLogoutAll() throws IOException {
        this.codeGrant("public-client-0");
        this.oauth.setDriver(this.secondBrowser);
        OAuthClient.AccessTokenResponse tokenResponse = this.codeGrant("public-client-0");
        Assert.assertEquals((long)3L, (long)this.getSessions().size());
        String currentToken = tokenResponse.getAccessToken();
        int status = SimpleHttp.doDelete((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).acceptJson().auth(currentToken).asStatus();
        Assert.assertEquals((long)204L, (long)status);
        Assert.assertEquals((long)1L, (long)this.getSessions(currentToken).size());
        status = SimpleHttp.doDelete((String)this.getAccountUrl("sessions?current=true"), (HttpClient)this.httpClient).acceptJson().auth(currentToken).asStatus();
        Assert.assertEquals((long)204L, (long)status);
        status = SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).acceptJson().auth(currentToken).asStatus();
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testNullOrEmptyUserAgent() throws Exception {
        Assume.assumeTrue((String)"Browser must be htmlunit. Otherwise we are not able to set desired BrowserHeaders", (boolean)System.getProperty("browser").equals("htmlUnit"));
        this.oauth.setBrowserHeader("User-Agent", null);
        OAuthClient.AccessTokenResponse tokenResponse = this.codeGrant("public-client-0");
        List<DeviceRepresentation> devices = this.queryDevices(tokenResponse.getAccessToken());
        Assert.assertEquals((String)"Should have a single device", (long)1L, (long)devices.size());
        DeviceRepresentation device = devices.get(0);
        Assert.assertTrue((boolean)device.getCurrent());
        Assert.assertEquals((Object)"Other", (Object)device.getOs());
        Assert.assertEquals((Object)"Other", (Object)device.getDevice());
        List sessions = device.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        SessionRepresentation session = (SessionRepresentation)sessions.get(0);
        Assert.assertEquals((Object)"127.0.0.1", (Object)session.getIpAddress());
        Assert.assertEquals((long)device.getLastAccess(), (long)session.getLastAccess());
        Assert.assertEquals((long)1L, (long)session.getClients().size());
    }

    @Test
    public void testNonBrowserSession() throws Exception {
        Assume.assumeTrue((String)"Browser must be htmlunit. Otherwise we are not able to set desired BrowserHeaders", (boolean)System.getProperty("browser").equals("htmlUnit"));
        this.oauth.setBrowserHeader("User-Agent", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:15.0) Gecko/20100101 Firefox/15.0.1");
        this.codeGrant("public-client-0");
        this.oauth.setBrowserHeader("User-Agent", null);
        this.oauth.clientId("confidential-client-0");
        this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        this.oauth.clientId("confidential-client-1");
        this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        List<DeviceRepresentation> devices = this.getAllDevices();
        Assert.assertEquals((long)2L, (long)devices.size());
        Assert.assertThat(devices, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.hasProperty((String)"os", (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"Fedora"), (Matcher)Matchers.is((Object)"Other")))}));
        Assert.assertEquals((long)3L, (long)devices.stream().filter(deviceRepresentation -> "Other".equals(deviceRepresentation.getOs())).map(deviceRepresentation -> deviceRepresentation.getSessions().size()).findFirst().get().intValue());
    }

    private List<SessionRepresentation> getSessions(String sessionOne) throws IOException {
        return (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).auth(sessionOne).asJson((TypeReference)new TypeReference<List<SessionRepresentation>>(){});
    }

    private List<DeviceRepresentation> getDevicesOtherThanOther() throws IOException {
        return this.getDevicesOtherThanOther(this.tokenUtil.getToken());
    }

    private List<DeviceRepresentation> getAllDevices() throws IOException {
        return this.queryDevices(this.tokenUtil.getToken());
    }

    private List<DeviceRepresentation> getDevicesOtherThanOther(String token) throws IOException {
        return this.queryDevices(token).stream().filter(rep -> !"Other".equals(rep.getOs())).collect(Collectors.toList());
    }

    private List<DeviceRepresentation> queryDevices(String token) throws IOException {
        return (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions/devices"), (HttpClient)this.httpClient).auth(token).asJson((TypeReference)new TypeReference<List<DeviceRepresentation>>(){});
    }

    private OAuthClient.AccessTokenResponse codeGrant(String clientId) {
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
        this.oauth.openLogout();
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        return this.oauth.doAccessTokenRequest(code, "password");
    }

    private void joinSsoSession(String clientId) {
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
        this.oauth.openLoginForm();
    }

    private List<SessionRepresentation> getSessions() throws IOException {
        return (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<SessionRepresentation>>(){});
    }
}

