/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.resources.account.resources.AbstractResourceService;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.account.AbstractRestServiceTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.TokenUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class ResourcesRestServiceTest
extends AbstractRestServiceTest {
    private AuthzClient authzClient;
    private List<String> userNames = new ArrayList<String>(Arrays.asList("alice", "jdoe", "bob"));

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        super.configureTestRealm(testRealm);
        RealmRepresentation realmRepresentation = testRealm;
        realmRepresentation.setUserManagedAccessAllowed(Boolean.valueOf(true));
        testRealm.getUsers().add(this.createUser("alice", "password"));
        testRealm.getUsers().add(this.createUser("jdoe", "password"));
        testRealm.getUsers().add(this.createUser("bob", "password"));
        ClientRepresentation client = ClientBuilder.create().clientId("my-resource-server").authorizationServicesEnabled(true).serviceAccountsEnabled(true).secret("secret").name("My Resource Server").baseUrl("http://resourceserver.com").directAccessGrants().build();
        testRealm.getClients().add(client);
    }

    @Override
    public void before() {
        super.before();
        ClientResource resourceServer = this.getResourceServer();
        this.authzClient = this.createAuthzClient(resourceServer.toRepresentation());
        AuthorizationResource authorization = resourceServer.authorization();
        for (int i = 0; i < 30; ++i) {
            ResourceRepresentation resource = new ResourceRepresentation();
            resource.setOwnerManagedAccess(Boolean.valueOf(true));
            try {
                resource.setOwner(((AccessToken)JsonSerialization.readValue((byte[])new JWSInput(this.tokenUtil.getToken()).getContent(), AccessToken.class)).getSubject());
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to parse access token", cause);
            }
            resource.setName("Resource " + i);
            resource.setDisplayName("Display Name " + i);
            resource.setIconUri("Icon Uri " + i);
            resource.addScope(new String[]{"Scope A", "Scope B", "Scope C", "Scope D"});
            resource.setUri("http://resourceServer.com/resources/" + i);
            try (Response response1 = authorization.resources().create(resource);){
                resource.setId(((ResourceRepresentation)response1.readEntity(ResourceRepresentation.class)).getId());
            }
            for (String scope : Arrays.asList("Scope A", "Scope B")) {
                PermissionTicketRepresentation ticket = new PermissionTicketRepresentation();
                ticket.setGranted(true);
                ticket.setOwner(resource.getOwner().getId());
                ticket.setRequesterName(this.userNames.get(i % this.userNames.size()));
                ticket.setResource(resource.getId());
                ticket.setScopeName(scope);
                this.authzClient.protection("test-user@localhost", "password").permission().create(ticket);
            }
        }
    }

    private ClientResource getResourceServer() {
        ClientsResource clients = this.testRealm().clients();
        return clients.get(((ClientRepresentation)clients.findByClientId("my-resource-server").get(0)).getId());
    }

    @Override
    public void after() {
        super.after();
        ClientResource resourceServer = this.getResourceServer();
        ClientRepresentation representation = resourceServer.toRepresentation();
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        resourceServer.update(representation);
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        resourceServer.update(representation);
    }

    @Test
    public void testGetMyResources() {
        List<AbstractResourceService.Resource> resources = this.getMyResources();
        Assert.assertEquals((long)30L, (long)resources.size());
        this.assertMyResourcesResponse(resources);
    }

    @Test
    public void testGetMyResourcesByName() {
        Assert.assertEquals((long)11L, (long)this.getMyResources("Resource 1").size());
        Assert.assertEquals((long)0L, (long)this.getMyResources("non-existent\n").size());
        Assert.assertEquals((long)1L, (long)this.getMyResources("Resource 23").size());
    }

    @Test
    public void testGetMyResourcesPagination() {
        List<AbstractResourceService.Resource> resources = this.getMyResources(0, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", 10, -1, 10));
        Assert.assertEquals((long)10L, (long)resources.size());
        this.assertMyResourcesResponse(resources);
        resources = this.getMyResources(10, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", 20, 0, 10));
        Assert.assertEquals((long)10L, (long)resources.size());
        resources = this.getMyResources(20, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, 10, 10));
        this.getMyResources(15, 5, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", 20, 10, 5));
        Assert.assertEquals((long)10L, (long)resources.size());
        resources = this.getMyResources(30, 10);
        Assert.assertEquals((long)0L, (long)resources.size());
        this.getMyResources(5, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", 15, 0, 10));
        this.getMyResources(10, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", 20, 0, 10));
        this.getMyResources(20, 10, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, 10, 10));
        this.getMyResources(20, 20, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, 0, 20));
        this.getMyResources(30, 30, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, -1, 30));
        this.getMyResources(30, 31, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, -1, 31));
        this.getMyResources(0, 30, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, -1, 30));
        this.getMyResources(0, 31, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources", -1, -1, 31));
    }

    @Test
    public void testGetSharedWithMe() {
        for (String userName : this.userNames) {
            List<AbstractResourceService.ResourcePermission> resources = this.getSharedWithMe(userName);
            Assert.assertEquals((long)10L, (long)resources.size());
            this.assertSharedWithMeResponse(resources);
        }
    }

    @Test
    public void testGetSharedWithMeByName() {
        Assert.assertEquals((long)5L, (long)this.getSharedWithMe("jdoe", "Resource 1", -1, -1, null).size());
        Assert.assertEquals((long)0L, (long)this.getSharedWithMe("jdoe", "non-existent", -1, -1, null).size());
        Assert.assertEquals((long)10L, (long)this.getSharedWithMe("jdoe", "resource", -1, -1, null).size());
    }

    @Test
    public void testGetSharedWithMePagination() {
        for (String userName : this.userNames) {
            List<AbstractResourceService.ResourcePermission> resources = this.getSharedWithMe(userName, null, 0, 3, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-me", 3, -1, 3));
            this.assertSharedWithMeResponse(resources);
            this.getSharedWithMe(userName, null, 3, 3, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-me", 6, 0, 3));
            this.getSharedWithMe(userName, null, 6, 3, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-me", 9, 3, 3));
            this.getSharedWithMe(userName, null, 9, 3, response -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-me", -1, 6, 3));
        }
    }

    @Test
    public void testGetSharedWithOthers() {
        List<AbstractResourceService.ResourcePermission> resources = this.doGet("/shared-with-others", new TypeReference<List<AbstractResourceService.ResourcePermission>>(){});
        Assert.assertEquals((long)30L, (long)resources.size());
        this.assertSharedWithOthersResponse(resources);
    }

    @Test
    public void testGetSharedWithOthersPagination() {
        List<AbstractResourceService.ResourcePermission> resources = this.doGet("/shared-with-others?first=0&max=5", new TypeReference<List<AbstractResourceService.ResourcePermission>>(){}, (SimpleHttp.Response response) -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-others", 5, -1, 5));
        Assert.assertEquals((long)5L, (long)resources.size());
        this.assertSharedWithOthersResponse(resources);
        this.doGet("/shared-with-others?first=5&max=5", new TypeReference<List<AbstractResourceService.ResourcePermission>>(){}, (SimpleHttp.Response response) -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-others", 10, 0, 5));
        this.doGet("/shared-with-others?first=20&max=5", new TypeReference<List<AbstractResourceService.ResourcePermission>>(){}, (SimpleHttp.Response response) -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-others", 25, 15, 5));
        this.doGet("/shared-with-others?first=25&max=5", new TypeReference<List<AbstractResourceService.ResourcePermission>>(){}, (SimpleHttp.Response response) -> this.assertNextPageLink((SimpleHttp.Response)response, "/realms/test/account/resources/shared-with-others", -1, 20, 5));
    }

    @Test
    public void testGetResource() {
        AbstractResourceService.Resource resource = this.doGet("/" + this.getMyResources().get(0).getId(), AbstractResourceService.Resource.class);
        String uri = resource.getUri();
        int id = Integer.parseInt(uri.substring(uri.lastIndexOf(47) + 1));
        Assert.assertNotNull((Object)resource.getId());
        Assert.assertEquals((Object)("Resource " + id), (Object)resource.getName());
        Assert.assertEquals((Object)("Display Name " + id), (Object)resource.getDisplayName());
        Assert.assertEquals((Object)("Icon Uri " + id), (Object)resource.getIconUri());
        Assert.assertEquals((Object)"my-resource-server", (Object)resource.getClient().getClientId());
        Assert.assertEquals((Object)"My Resource Server", (Object)resource.getClient().getName());
        Assert.assertEquals((Object)"http://resourceserver.com", (Object)resource.getClient().getBaseUrl());
        Assert.assertEquals((long)4L, (long)resource.getScopes().size());
        OAuth2ErrorRepresentation response = this.doGet("/invalid_resource", OAuth2ErrorRepresentation.class);
        Assert.assertEquals((Object)"resource_not_found", (Object)response.getError());
        response = this.doGet("/" + this.getMyResources().get(0).getId(), this.authzClient.obtainAccessToken("jdoe", "password").getToken(), OAuth2ErrorRepresentation.class);
        Assert.assertEquals((Object)"invalid_resource", (Object)response.getError());
    }

    @Test
    public void testGetPermissions() throws Exception {
        AbstractResourceService.Resource resource = this.getMyResources().get(0);
        List<AbstractResourceService.Permission> shares = this.doGet("/" + resource.getId() + "/permissions", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertEquals((long)1L, (long)shares.size());
        AbstractResourceService.Permission firstShare = shares.get(0);
        ArrayList<AbstractResourceService.Permission> permissions = new ArrayList<AbstractResourceService.Permission>();
        Assert.assertTrue((boolean)this.userNames.contains(firstShare.getUsername()));
        Assert.assertEquals((long)2L, (long)firstShare.getScopes().size());
        ArrayList<String> users = new ArrayList<String>(this.userNames);
        users.remove(firstShare.getUsername());
        for (String userName : users) {
            AbstractResourceService.Permission permission = new AbstractResourceService.Permission();
            permission.setUsername(userName);
            permission.addScope(new String[]{"Scope D"});
            permissions.add(permission);
        }
        SimpleHttp.doPut((String)this.getAccountUrl("resources/" + resource.getId() + "/permissions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json(permissions).asResponse();
        shares = this.doGet("/" + resource.getId() + "/permissions", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertEquals((long)3L, (long)shares.size());
        for (AbstractResourceService.Permission user : shares) {
            Assert.assertTrue((boolean)this.userNames.contains(user.getUsername()));
            if (firstShare.getUsername().equals(user.getUsername())) {
                Assert.assertEquals((long)2L, (long)user.getScopes().size());
                continue;
            }
            Assert.assertEquals((long)1L, (long)user.getScopes().size());
        }
    }

    @Test
    public void testShareResource() throws Exception {
        LinkedList<String> users = new LinkedList<String>(Arrays.asList("jdoe", "alice"));
        ArrayList<AbstractResourceService.Permission> permissions = new ArrayList<AbstractResourceService.Permission>();
        AbstractResourceService.ResourcePermission sharedResource = null;
        for (String user : users) {
            sharedResource = this.getSharedWithMe(user).get(0);
            Assert.assertNotNull((Object)sharedResource);
            Assert.assertEquals((long)2L, (long)sharedResource.getScopes().size());
        }
        permissions.add(new AbstractResourceService.Permission((String)users.get(0), new String[]{"Scope C", "Scope D"}));
        permissions.add(new AbstractResourceService.Permission((String)users.get(users.size() - 1), new String[]{"Scope A", "Scope B", "Scope C", "Scope D"}));
        String resourceId = sharedResource.getId();
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("resources/" + resourceId + "/permissions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json(permissions).asResponse();
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        for (String user : users) {
            sharedResource = this.getSharedWithMe(user).stream().filter(resource1 -> resource1.getId().equals(resourceId)).findAny().orElse(null);
            Assert.assertNotNull((Object)sharedResource);
            if (user.equals(users.get(users.size() - 1))) {
                Assert.assertEquals((long)4L, (long)sharedResource.getScopes().size());
                continue;
            }
            Assert.assertEquals((long)2L, (long)sharedResource.getScopes().size());
        }
    }

    @Test
    public void failShareResourceInvalidPermissions() throws Exception {
        ArrayList permissions = new ArrayList();
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("resources/" + this.getMyResources().get(0).getId() + "/permissions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json(permissions).asResponse();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testEndpointPermissions() throws Exception {
        String resourceId;
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner(this.findUser("view-account-access").getId());
        resource.setName("Resource view-account-access");
        resource.setDisplayName("Display Name view-account-access");
        resource.setIconUri("Icon Uri view-account-access");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C", "Scope D"});
        resource.setUri("http://resourceServer.com/resources/view-account-access");
        try (Response response1 = this.getResourceServer().authorization().resources().create(resource);){
            resourceId = ((ResourceRepresentation)response1.readEntity(ResourceRepresentation.class)).getId();
        }
        String resourcesUrl = this.getAccountUrl("resources");
        String sharedWithOthersUrl = resourcesUrl + "/shared-with-others";
        String sharedWithMeUrl = resourcesUrl + "/shared-with-me";
        String resourceUrl = resourcesUrl + "/" + resourceId;
        String permissionsUrl = resourceUrl + "/permissions";
        String requestsUrl = resourceUrl + "/permissions/requests";
        TokenUtil viewProfileTokenUtil = new TokenUtil("view-account-access", "password");
        TokenUtil noAccessTokenUtil = new TokenUtil("no-account-access", "password");
        for (String url : Arrays.asList(resourcesUrl, sharedWithOthersUrl, sharedWithMeUrl, resourceUrl, permissionsUrl, requestsUrl)) {
            Assert.assertEquals((String)("no-account-access GET " + url), (long)403L, (long)SimpleHttp.doGet((String)url, (HttpClient)this.httpClient).acceptJson().auth(noAccessTokenUtil.getToken()).asStatus());
            Assert.assertEquals((String)("view-account-access GET " + url), (long)200L, (long)SimpleHttp.doGet((String)url, (HttpClient)this.httpClient).acceptJson().auth(viewProfileTokenUtil.getToken()).asStatus());
        }
        Assert.assertEquals((String)("no-account-access PUT " + permissionsUrl), (long)403L, (long)SimpleHttp.doPut((String)permissionsUrl, (HttpClient)this.httpClient).acceptJson().auth(noAccessTokenUtil.getToken()).json(Collections.emptyList()).asStatus());
        Assert.assertEquals((String)("view-account-access PUT " + permissionsUrl), (long)403L, (long)SimpleHttp.doPut((String)permissionsUrl, (HttpClient)this.httpClient).acceptJson().auth(viewProfileTokenUtil.getToken()).json(Collections.emptyList()).asStatus());
    }

    @Test
    public void testRevokePermission() throws Exception {
        List<String> users = Arrays.asList("jdoe", "alice");
        ArrayList<AbstractResourceService.Permission> permissions = new ArrayList<AbstractResourceService.Permission>();
        AbstractResourceService.ResourcePermission sharedResource = null;
        for (String user : users) {
            sharedResource = this.getSharedWithMe(user).get(0);
            Assert.assertNotNull((Object)sharedResource);
            Assert.assertEquals((long)2L, (long)sharedResource.getScopes().size());
        }
        permissions.add(new AbstractResourceService.Permission(users.get(0), new String[]{"Scope C"}));
        permissions.add(new AbstractResourceService.Permission(users.get(users.size() - 1), new String[]{"Scope B", "Scope D"}));
        String resourceId = sharedResource.getId();
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("resources/" + resourceId + "/permissions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json(permissions).asResponse();
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        for (String user : users) {
            sharedResource = this.getSharedWithMe(user).stream().filter(resource1 -> resource1.getId().equals(resourceId)).findAny().orElse(null);
            Assert.assertNotNull((Object)sharedResource);
            if (user.equals(users.get(users.size() - 1))) {
                Assert.assertEquals((long)2L, (long)sharedResource.getScopes().size());
                continue;
            }
            Assert.assertEquals((long)1L, (long)sharedResource.getScopes().size());
        }
    }

    @Test
    public void testGetPermissionRequests() {
        AbstractResourceService.Resource resource = this.getMyResources().get(0);
        List<AbstractResourceService.Permission> requests = this.doGet("/" + resource.getId() + "/permissions/requests", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertTrue((boolean)requests.isEmpty());
        for (String userName : this.userNames) {
            ArrayList<String> scopes = new ArrayList<String>();
            if ("bob".equals(userName)) {
                scopes.add("Scope D");
            } else if ("alice".equals(userName)) {
                scopes.add("Scope C");
            } else if ("jdoe".equals(userName)) {
                scopes.add("Scope C");
                scopes.add("Scope D");
            }
            for (String scope : scopes) {
                PermissionTicketRepresentation ticket = new PermissionTicketRepresentation();
                ticket.setGranted(false);
                ticket.setOwner("test-user@localhost");
                ticket.setRequesterName(userName);
                ticket.setResource(resource.getId());
                ticket.setScopeName(scope);
                this.authzClient.protection("test-user@localhost", "password").permission().create(ticket);
            }
        }
        requests = this.doGet("/" + resource.getId() + "/permissions/requests", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertEquals((long)3L, (long)requests.size());
        Iterator<AbstractResourceService.Permission> iterator = requests.iterator();
        while (iterator.hasNext()) {
            AbstractResourceService.Permission permission = iterator.next();
            String username = permission.getUsername();
            List scopes = permission.getScopes();
            if ("bob".equals(username)) {
                Assert.assertEquals((long)1L, (long)scopes.size());
                Assert.assertTrue((boolean)scopes.contains("Scope D"));
                iterator.remove();
                continue;
            }
            if ("alice".equals(username)) {
                Assert.assertEquals((long)1L, (long)scopes.size());
                Assert.assertTrue((boolean)scopes.contains("Scope C"));
                iterator.remove();
                continue;
            }
            if (!"jdoe".equals(username)) continue;
            Assert.assertEquals((long)2L, (long)scopes.size());
            Assert.assertTrue((boolean)scopes.contains("Scope C"));
            Assert.assertTrue((boolean)scopes.contains("Scope D"));
            iterator.remove();
        }
        Assert.assertTrue((boolean)requests.isEmpty());
    }

    @Test
    public void testApprovePermissionRequest() throws IOException {
        AbstractResourceService.Resource resource = this.getMyResources().get(0);
        List<AbstractResourceService.Permission> requests = this.doGet("/" + resource.getId() + "/permissions/requests", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertTrue((boolean)requests.isEmpty());
        for (String userName : this.userNames) {
            ArrayList<String> scopes = new ArrayList<String>();
            if ("bob".equals(userName)) {
                scopes.add("Scope D");
            } else if ("alice".equals(userName)) {
                scopes.add("Scope C");
            } else if ("jdoe".equals(userName)) {
                scopes.add("Scope C");
                scopes.add("Scope D");
            }
            for (String scope2 : scopes) {
                PermissionTicketRepresentation ticket = new PermissionTicketRepresentation();
                ticket.setGranted(false);
                ticket.setOwner("test-user@localhost");
                ticket.setRequesterName(userName);
                ticket.setResource(resource.getId());
                ticket.setScopeName(scope2);
                this.authzClient.protection("test-user@localhost", "password").permission().create(ticket);
            }
        }
        requests = this.doGet("/" + resource.getId() + "/permissions/requests", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertEquals((long)3L, (long)requests.size());
        for (AbstractResourceService.Permission permission : requests) {
            String username = permission.getUsername();
            List scopes = permission.getScopes();
            if ("bob".equals(username)) {
                scopes.clear();
                continue;
            }
            if (!"jdoe".equals(username)) continue;
            scopes.remove("Scope C");
        }
        SimpleHttp.doPut((String)this.getAccountUrl("resources/" + resource.getId() + "/permissions"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json(requests).asResponse();
        requests = this.doGet("/" + resource.getId() + "/permissions/requests", new TypeReference<List<AbstractResourceService.Permission>>(){});
        Assert.assertTrue((boolean)requests.isEmpty());
        for (String user : Arrays.asList("alice", "jdoe")) {
            AbstractResourceService.ResourcePermission sharedResource = this.getSharedWithMe(user).stream().filter(resource1 -> resource1.getId().equals(resource.getId())).findAny().orElse(null);
            Assert.assertNotNull((Object)sharedResource);
            Set scopes = sharedResource.getScopes();
            if ("alice".equals(user)) {
                Assert.assertEquals((long)1L, (long)scopes.size());
                Assert.assertTrue((boolean)scopes.stream().anyMatch(scope -> "Scope C".equals(scope.getName())));
                continue;
            }
            if (!"jdoe".equals(user)) continue;
            Assert.assertEquals((long)1L, (long)scopes.size());
            Assert.assertTrue((boolean)scopes.stream().anyMatch(scope -> "Scope D".equals(scope.getName())));
        }
    }

    private List<AbstractResourceService.ResourcePermission> getSharedWithMe(String userName) {
        return this.getSharedWithMe(userName, null, -1, -1, null);
    }

    private List<AbstractResourceService.ResourcePermission> getSharedWithMe(String userName, String name, int first, int max, Consumer<SimpleHttp.Response> responseHandler) {
        KeycloakUriBuilder uri = KeycloakUriBuilder.fromUri((String)"/shared-with-me");
        if (name != null) {
            uri.queryParam("name", new Object[]{name});
        }
        if (first > -1 && max > -1) {
            uri.queryParam("first", new Object[]{first});
            uri.queryParam("max", new Object[]{max});
        }
        return this.doGet(uri.build(new Object[0]).toString(), this.authzClient.obtainAccessToken(userName, "password").getToken(), new TypeReference<List<AbstractResourceService.ResourcePermission>>(){}, responseHandler);
    }

    private <R> R doGet(String resource, TypeReference<R> typeReference) {
        return this.doGet(resource, this.tokenUtil.getToken(), typeReference);
    }

    private <R> R doGet(String resource, TypeReference<R> typeReference, Consumer<SimpleHttp.Response> response) {
        return this.doGet(resource, this.tokenUtil.getToken(), typeReference, response);
    }

    private <R> R doGet(String resource, Class<R> type) {
        return this.doGet(resource, this.tokenUtil.getToken(), type);
    }

    private <R> R doGet(String resource, String token, TypeReference<R> typeReference) {
        try {
            return (R)this.get(resource, token).asJson(typeReference);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to fetch resource", cause);
        }
    }

    private <R> R doGet(String resource, String token, TypeReference<R> typeReference, Consumer<SimpleHttp.Response> responseHandler) {
        try {
            SimpleHttp http = this.get(resource, token);
            http.header("Accept", "application/json");
            SimpleHttp.Response response = http.asResponse();
            if (responseHandler != null) {
                responseHandler.accept(response);
            }
            Object result = JsonSerialization.readValue((String)response.asString(), typeReference);
            return (R)result;
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to fetch resource", cause);
        }
    }

    private <R> R doGet(String resource, String token, Class<R> type) {
        try {
            return (R)this.get(resource, token).asJson(type);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to fetch resource", cause);
        }
    }

    private SimpleHttp get(String resource, String token) {
        return SimpleHttp.doGet((String)this.getAccountUrl("resources" + resource), (HttpClient)this.httpClient).auth(token);
    }

    private AuthzClient createAuthzClient(ClientRepresentation client) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("secret", "secret");
        return AuthzClient.create((Configuration)new Configuration(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth", this.testRealm().toRepresentation().getRealm(), client.getClientId(), credentials, (HttpClient)this.httpClient));
    }

    private UserRepresentation createUser(String userName, String password) {
        return UserBuilder.create().username(userName).enabled(true).password(password).role("account", "manage-account").build();
    }

    private List<AbstractResourceService.Resource> getMyResources() {
        return this.getMyResources(-1, -1);
    }

    private List<AbstractResourceService.Resource> getMyResources(String name) {
        return this.getMyResources(name, -1, -1);
    }

    private List<AbstractResourceService.Resource> getMyResources(int first, int max) {
        return this.getMyResources(null, first, max);
    }

    private List<AbstractResourceService.Resource> getMyResources(String name, int first, int max) {
        KeycloakUriBuilder uri = KeycloakUriBuilder.fromUri((String)"");
        if (name != null) {
            uri.queryParam("name", new Object[]{name});
        }
        if (first > -1 && max > -1) {
            uri.queryParam("first", new Object[]{first});
            uri.queryParam("max", new Object[]{max});
        }
        return this.doGet(uri.build(new Object[0]).toString(), new TypeReference<List<AbstractResourceService.Resource>>(){});
    }

    private List<AbstractResourceService.Resource> getMyResources(int first, int max, Consumer<SimpleHttp.Response> response) {
        String query = "";
        if (first > -1 && max > -1) {
            query = "?first=" + first + "&max=" + max;
        }
        return this.doGet(query, new TypeReference<List<AbstractResourceService.Resource>>(){}, response);
    }

    private void assertSharedWithOthersResponse(List<AbstractResourceService.ResourcePermission> resources) {
        for (AbstractResourceService.ResourcePermission resource : resources) {
            String uri = resource.getUri();
            int id = Integer.parseInt(uri.substring(uri.lastIndexOf(47) + 1));
            Assert.assertNotNull((Object)resource.getId());
            Assert.assertEquals((Object)("Resource " + id), (Object)resource.getName());
            Assert.assertEquals((Object)("Display Name " + id), (Object)resource.getDisplayName());
            Assert.assertEquals((Object)("Icon Uri " + id), (Object)resource.getIconUri());
            Assert.assertEquals((Object)"my-resource-server", (Object)resource.getClient().getClientId());
            Assert.assertEquals((Object)"My Resource Server", (Object)resource.getClient().getName());
            Assert.assertEquals((Object)"http://resourceserver.com", (Object)resource.getClient().getBaseUrl());
            Assert.assertEquals((long)1L, (long)resource.getPermissions().size());
            AbstractResourceService.Permission user = (AbstractResourceService.Permission)resource.getPermissions().iterator().next();
            Assert.assertTrue((boolean)this.userNames.contains(user.getUsername()));
            Assert.assertEquals((long)2L, (long)user.getScopes().size());
        }
    }

    private void assertMyResourcesResponse(List<AbstractResourceService.Resource> resources) {
        for (AbstractResourceService.Resource resource : resources) {
            String uri = resource.getUri();
            int id = Integer.parseInt(uri.substring(uri.lastIndexOf(47) + 1));
            Assert.assertNotNull((Object)resource.getId());
            Assert.assertEquals((Object)("Resource " + id), (Object)resource.getName());
            Assert.assertEquals((Object)("Display Name " + id), (Object)resource.getDisplayName());
            Assert.assertEquals((Object)("Icon Uri " + id), (Object)resource.getIconUri());
            Assert.assertEquals((Object)"my-resource-server", (Object)resource.getClient().getClientId());
            Assert.assertEquals((Object)"My Resource Server", (Object)resource.getClient().getName());
            Assert.assertEquals((Object)"http://resourceserver.com", (Object)resource.getClient().getBaseUrl());
        }
    }

    private void assertSharedWithMeResponse(List<AbstractResourceService.ResourcePermission> resources) {
        for (AbstractResourceService.ResourcePermission resource : resources) {
            String uri = resource.getUri();
            int id = Integer.parseInt(uri.substring(uri.lastIndexOf(47) + 1));
            Assert.assertNotNull((Object)resource.getId());
            Assert.assertEquals((Object)("Resource " + id), (Object)resource.getName());
            Assert.assertEquals((Object)("Display Name " + id), (Object)resource.getDisplayName());
            Assert.assertEquals((Object)("Icon Uri " + id), (Object)resource.getIconUri());
            Assert.assertEquals((Object)"my-resource-server", (Object)resource.getClient().getClientId());
            Assert.assertEquals((Object)"My Resource Server", (Object)resource.getClient().getName());
            Assert.assertEquals((Object)"http://resourceserver.com", (Object)resource.getClient().getBaseUrl());
            Assert.assertEquals((long)2L, (long)resource.getScopes().size());
        }
    }

    private void assertNextPageLink(SimpleHttp.Response response, String uri, int nextPage, int previousPage, int max) {
        try {
            List links = response.getHeader("Link");
            if (nextPage == -1 && previousPage == -1) {
                Assert.assertNull((Object)links);
                return;
            }
            Assert.assertNotNull((Object)links);
            Assert.assertEquals((long)(nextPage > -1 && previousPage > -1 ? 2L : 1L), (long)links.size());
            for (String link : links) {
                if (link.contains("rel=\"next\"")) {
                    Assert.assertEquals((Object)("<" + this.authzClient.getConfiguration().getAuthServerUrl() + uri + "?first=" + nextPage + "&max=" + max + ">; rel=\"next\""), (Object)link);
                    continue;
                }
                Assert.assertEquals((Object)("<" + this.authzClient.getConfiguration().getAuthServerUrl() + uri + "?first=" + previousPage + "&max=" + max + ">; rel=\"prev\""), (Object)link);
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to get link header");
        }
    }
}

