/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.representations.account.UserProfileAttributeMetadata;
import org.keycloak.representations.account.UserRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.account.AccountRestServiceTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.userprofile.UserProfileContext;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AccountRestServiceWithUserProfileTest
extends AccountRestServiceTest {
    private static String UP_CONFIG_FOR_METADATA = "{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {\"scopes\":[\"profile\"]}, \"displayName\": \"${profile.firstName}\", \"validations\": {\"length\": { \"max\": 255 }}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}, \"displayName\": \"Last name\", \"annotations\": {\"formHintKey\" : \"userEmailFormFieldHint\", \"anotherKey\" : 10, \"yetAnotherKey\" : \"some value\"}},{\"name\": \"attr_with_scope_selector\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\": {\"scopes\": [\"profile\"]}},{\"name\": \"attr_required\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"attr_required_by_role\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {\"roles\" : [\"user\"]}},{\"name\": \"attr_required_by_scope\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {\"scopes\": [\"profile\"]}},{\"name\": \"attr_not_required_due_to_role\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {\"roles\" : [\"admin\"]}},{\"name\": \"attr_readonly\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}},{\"name\": \"attr_no_permission\",\"permissions\": {\"view\": [\"admin\"], \"edit\": [\"admin\"]}}]}";

    @Override
    @Before
    public void before() {
        super.before();
        this.enableDynamicUserProfile();
        this.setUserProfileConfiguration(null);
    }

    @Override
    protected boolean isDeclarativeUserProfile() {
        return true;
    }

    @Override
    @Test
    public void testGetUserProfileMetadata_EditUsernameAllowed() throws IOException {
        this.setUserProfileConfiguration(UP_CONFIG_FOR_METADATA);
        UserRepresentation user = this.getUser();
        Assert.assertNotNull((Object)user.getUserProfileMetadata());
        this.assertUserProfileAttributeMetadata(user, "username", "${username}", true, false);
        this.assertUserProfileAttributeMetadata(user, "email", "${email}", true, false);
        UserProfileAttributeMetadata uam = this.assertUserProfileAttributeMetadata(user, "firstName", "${profile.firstName}", false, false);
        Assert.assertNull((Object)uam.getAnnotations());
        Map<String, Object> vc = this.assertValidatorExists(uam, "length");
        Assert.assertEquals((Object)255, (Object)vc.get("max"));
        uam = this.assertUserProfileAttributeMetadata(user, "lastName", "Last name", true, false);
        Assert.assertNotNull((Object)uam.getAnnotations());
        Assert.assertEquals((long)3L, (long)uam.getAnnotations().size());
        this.assertAnnotationValue(uam, "formHintKey", "userEmailFormFieldHint");
        this.assertAnnotationValue(uam, "anotherKey", 10);
        this.assertUserProfileAttributeMetadata(user, "attr_with_scope_selector", "attr_with_scope_selector", false, false);
        this.assertUserProfileAttributeMetadata(user, "attr_required", "attr_required", true, false);
        this.assertUserProfileAttributeMetadata(user, "attr_required_by_role", "attr_required_by_role", true, false);
        this.assertUserProfileAttributeMetadata(user, "attr_required_by_scope", "attr_required_by_scope", false, false);
        this.assertUserProfileAttributeMetadata(user, "attr_not_required_due_to_role", "attr_not_required_due_to_role", false, false);
        this.assertUserProfileAttributeMetadata(user, "attr_readonly", "attr_readonly", false, true);
        Assert.assertNull((Object)this.getUserProfileAttributeMetadata(user, "attr_no_permission"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testGetUserProfileMetadata_EditUsernameDisallowed() throws IOException {
        RealmRepresentation realmRep;
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            this.setUserProfileConfiguration(UP_CONFIG_FOR_METADATA);
            UserRepresentation user = this.getUser();
            Assert.assertNotNull((Object)user.getUserProfileMetadata());
            this.assertUserProfileAttributeMetadata(user, "username", "${username}", true, true);
            this.assertUserProfileAttributeMetadata(user, "email", "${email}", true, false);
            UserProfileAttributeMetadata uam = this.assertUserProfileAttributeMetadata(user, "firstName", "${profile.firstName}", false, false);
            Assert.assertNull((Object)uam.getAnnotations());
            Map<String, Object> vc = this.assertValidatorExists(uam, "length");
            Assert.assertEquals((Object)255, (Object)vc.get("max"));
            uam = this.assertUserProfileAttributeMetadata(user, "lastName", "Last name", true, false);
            Assert.assertNotNull((Object)uam.getAnnotations());
            Assert.assertEquals((long)3L, (long)uam.getAnnotations().size());
            this.assertAnnotationValue(uam, "formHintKey", "userEmailFormFieldHint");
            this.assertAnnotationValue(uam, "anotherKey", 10);
            this.assertUserProfileAttributeMetadata(user, "attr_with_scope_selector", "attr_with_scope_selector", false, false);
            this.assertUserProfileAttributeMetadata(user, "attr_required", "attr_required", true, false);
            this.assertUserProfileAttributeMetadata(user, "attr_required_by_role", "attr_required_by_role", true, false);
            this.assertUserProfileAttributeMetadata(user, "attr_required_by_scope", "attr_required_by_scope", false, false);
            this.assertUserProfileAttributeMetadata(user, "attr_not_required_due_to_role", "attr_not_required_due_to_role", false, false);
            this.assertUserProfileAttributeMetadata(user, "attr_readonly", "attr_readonly", false, true);
            Assert.assertNull((Object)this.getUserProfileAttributeMetadata(user, "attr_no_permission"));
        }
        finally {
            realmRep = this.testRealm().toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.testRealm().update(realmRep);
        }
    }

    protected void assertAnnotationValue(UserProfileAttributeMetadata uam, String key, Object value) {
        Assert.assertNotNull((String)("Missing annotations for attribute " + uam.getName()), (Object)uam.getAnnotations());
        Assert.assertEquals((String)("Unexpexted value of the " + key + " annotation for attribute " + uam.getName()), (Object)value, uam.getAnnotations().get(key));
    }

    protected Map<String, Object> assertValidatorExists(UserProfileAttributeMetadata uam, String validatorId) {
        Assert.assertNotNull((String)("Missing validators for attribute " + uam.getName()), (Object)uam.getValidators());
        Assert.assertTrue((String)("Missing validtor " + validatorId + " for attribute " + uam.getName()), (boolean)uam.getValidators().containsKey(validatorId));
        return (Map)uam.getValidators().get(validatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfileEventWithAdditionalAttributesAuditing() throws IOException {
        RealmRepresentation realmRep;
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"attr1\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        UserRepresentation user = this.getUser();
        String originalUsername = user.getUsername();
        String originalFirstName = user.getFirstName();
        String originalLastName = user.getLastName();
        String originalEmail = user.getEmail();
        HashMap originalAttributes = new HashMap(user.getAttributes());
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setEmail("bobby@localhost");
            user.setFirstName("Homer");
            user.setLastName("Simpsons");
            user.getAttributes().put("attr1", Collections.singletonList("val1"));
            user.getAttributes().put("attr2", Collections.singletonList("val2"));
            user = this.updateAndGet(user);
            this.events.poll();
            this.events.expectAccount(EventType.UPDATE_PROFILE).user(user.getId()).detail("context", UserProfileContext.ACCOUNT.name()).detail("previous_email", originalEmail).detail("updated_email", "bobby@localhost").detail("previous_first_name", originalFirstName).detail("previous_last_name", originalLastName).detail("updated_first_name", "Homer").detail("updated_last_name", "Simpsons").detail("updated_attr2", "val2").assertEvent();
            this.events.assertEmpty();
        }
        finally {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername(originalUsername);
            user.setFirstName(originalFirstName);
            user.setLastName(originalLastName);
            user.setEmail(originalEmail);
            user.setAttributes(originalAttributes);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    @Override
    @Test
    public void testUpdateProfileEvent() throws IOException {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"attr1\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        super.testUpdateProfileEvent();
    }

    @Override
    @Test
    public void testUpdateProfile() throws IOException {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"attr1\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        super.testUpdateProfile();
    }

    @Override
    @Test
    public void testUpdateSingleField() throws IOException {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}}]}");
        super.testUpdateSingleField();
    }

    protected void setUserProfileConfiguration(String configuration) {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), configuration);
    }

    protected void enableDynamicUserProfile() {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        VerifyProfileTest.enableDynamicUserProfile(testRealm);
        this.testRealm().update(testRealm);
    }
}

