/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.common.enums.AccountRestApiVersion;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.ConsentRepresentation;
import org.keycloak.representations.account.ConsentScopeRepresentation;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.representations.account.UserProfileAttributeMetadata;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.account.AccountCredentialResource;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.account.AbstractRestServiceTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.userprofile.UserProfileContext;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.WEB_AUTHN, skipRestart=true, onlyForProduct=true)
public class AccountRestServiceTest
extends AbstractRestServiceTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Test
    public void testGetUserProfileMetadata_EditUsernameAllowed() throws IOException {
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        Assert.assertNotNull((Object)user.getUserProfileMetadata());
        this.assertUserProfileAttributeMetadata(user, "username", "${username}", true, false);
        this.assertUserProfileAttributeMetadata(user, "email", "${email}", true, false);
        this.assertUserProfileAttributeMetadata(user, "firstName", "${firstName}", true, false);
        this.assertUserProfileAttributeMetadata(user, "lastName", "${lastName}", true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetUserProfileMetadata_EditUsernameDisallowed() throws IOException {
        RealmRepresentation realmRep;
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            org.keycloak.representations.account.UserRepresentation user = this.getUser();
            Assert.assertNotNull((Object)user.getUserProfileMetadata());
            UserProfileAttributeMetadata upm = this.assertUserProfileAttributeMetadata(user, "username", "${username}", true, true);
            Assert.assertEquals((long)0L, (long)upm.getValidators().size());
            upm = this.assertUserProfileAttributeMetadata(user, "email", "${email}", true, false);
            Assert.assertEquals((long)1L, (long)upm.getValidators().size());
            Assert.assertTrue((boolean)upm.getValidators().containsKey("email"));
            this.assertUserProfileAttributeMetadata(user, "firstName", "${firstName}", true, false);
            this.assertUserProfileAttributeMetadata(user, "lastName", "${lastName}", true, false);
        }
        finally {
            realmRep = this.testRealm().toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.testRealm().update(realmRep);
        }
    }

    protected UserProfileAttributeMetadata getUserProfileAttributeMetadata(org.keycloak.representations.account.UserRepresentation user, String attName) {
        if (user.getUserProfileMetadata() == null) {
            return null;
        }
        for (UserProfileAttributeMetadata uam : user.getUserProfileMetadata().getAttributes()) {
            if (!attName.equals(uam.getName())) continue;
            return uam;
        }
        return null;
    }

    protected UserProfileAttributeMetadata assertUserProfileAttributeMetadata(org.keycloak.representations.account.UserRepresentation user, String attName, String displayName, boolean required, boolean readOnly) {
        UserProfileAttributeMetadata uam = this.getUserProfileAttributeMetadata(user, attName);
        Assert.assertNotNull((Object)uam);
        Assert.assertEquals((String)("Unexpected display name for attribute " + uam.getName()), (Object)displayName, (Object)uam.getDisplayName());
        Assert.assertEquals((String)("Unexpected required flag for attribute " + uam.getName()), (Object)required, (Object)uam.isRequired());
        Assert.assertEquals((String)("Unexpected readonly flag for attribute " + uam.getName()), (Object)readOnly, (Object)uam.isReadOnly());
        return uam;
    }

    @Test
    public void testGetProfile() throws IOException {
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        Assert.assertEquals((Object)"Tom", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)user.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getEmail());
        Assert.assertFalse((boolean)user.isEmailVerified());
        Assert.assertTrue((boolean)user.getAttributes().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateSingleField() throws IOException {
        RealmRepresentation realmRep;
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalUsername = user.getUsername();
        String originalFirstName = user.getFirstName();
        String originalLastName = user.getLastName();
        String originalEmail = user.getEmail();
        HashMap originalAttributes = new HashMap(user.getAttributes());
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setFirstName(null);
            user.setLastName("Bob");
            user.setEmail(null);
            user.getAttributes().clear();
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)user.getLastName(), (Object)"Bob");
            Assert.assertNull((Object)user.getFirstName());
            Assert.assertNull((Object)user.getEmail());
        }
        finally {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername(originalUsername);
            user.setFirstName(originalFirstName);
            user.setLastName(originalLastName);
            user.setEmail(originalEmail);
            user.setAttributes(originalAttributes);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfileEmailChangeSetsEmailVerified() throws IOException {
        RealmRepresentation realmRep;
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalEmail = user.getEmail();
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            UserResource userResource = this.adminClient.realm("test").users().get(user.getId());
            UserRepresentation ur = userResource.toRepresentation();
            ur.setEmailVerified(Boolean.valueOf(true));
            userResource.update(ur);
            user = this.getUser();
            Assert.assertEquals((Object)true, (Object)user.isEmailVerified());
            user.setEmail(originalEmail);
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)originalEmail, (Object)user.getEmail());
            Assert.assertEquals((Object)true, (Object)user.isEmailVerified());
            user.setEmail("bobby@localhost");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"bobby@localhost", (Object)user.getEmail());
            Assert.assertEquals((Object)false, (Object)user.isEmailVerified());
        }
        finally {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setEmail(originalEmail);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfileEvent() throws IOException {
        RealmRepresentation realmRep;
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalUsername = user.getUsername();
        String originalFirstName = user.getFirstName();
        String originalLastName = user.getLastName();
        String originalEmail = user.getEmail();
        HashMap originalAttributes = new HashMap(user.getAttributes());
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setEmail("bobby@localhost");
            user.setFirstName("Homer");
            user.setLastName("Simpsons");
            user.getAttributes().put("attr1", Collections.singletonList("val1"));
            user.getAttributes().put("attr2", Collections.singletonList("val2"));
            user = this.updateAndGet(user);
            this.events.poll();
            this.events.expectAccount(EventType.UPDATE_PROFILE).user(user.getId()).detail("context", UserProfileContext.ACCOUNT.name()).detail("previous_email", originalEmail).detail("updated_email", "bobby@localhost").detail("previous_first_name", originalFirstName).detail("previous_last_name", originalLastName).detail("updated_first_name", "Homer").detail("updated_last_name", "Simpsons").assertEvent();
            this.events.assertEmpty();
        }
        finally {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername(originalUsername);
            user.setFirstName(originalFirstName);
            user.setLastName(originalLastName);
            user.setEmail(originalEmail);
            user.setAttributes(originalAttributes);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfile() throws IOException {
        RealmRepresentation realmRep;
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalUsername = user.getUsername();
        String originalFirstName = user.getFirstName();
        String originalLastName = user.getLastName();
        String originalEmail = user.getEmail();
        HashMap originalAttributes = new HashMap(user.getAttributes());
        try {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setFirstName("Homer");
            user.setLastName("Simpsons");
            user.getAttributes().put("attr1", Collections.singletonList("val1"));
            user.getAttributes().put("attr2", Collections.singletonList("val2"));
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"Homer", (Object)user.getFirstName());
            Assert.assertEquals((Object)"Simpsons", (Object)user.getLastName());
            Assert.assertEquals((long)2L, (long)user.getAttributes().size());
            Assert.assertEquals((long)1L, (long)((List)user.getAttributes().get("attr1")).size());
            Assert.assertEquals((Object)"val1", ((List)user.getAttributes().get("attr1")).get(0));
            Assert.assertEquals((long)1L, (long)((List)user.getAttributes().get("attr2")).size());
            Assert.assertEquals((Object)"val2", ((List)user.getAttributes().get("attr2")).get(0));
            user.getAttributes().remove("attr1");
            ((List)user.getAttributes().get("attr2")).add("val3");
            user = this.updateAndGet(user);
            if (this.isDeclarativeUserProfile()) {
                Assert.assertEquals((long)2L, (long)user.getAttributes().size());
                Assert.assertTrue((boolean)((List)user.getAttributes().get("attr1")).isEmpty());
            } else {
                Assert.assertEquals((long)1L, (long)user.getAttributes().size());
            }
            Assert.assertEquals((long)2L, (long)((List)user.getAttributes().get("attr2")).size());
            Assert.assertThat((Object)((List)user.getAttributes().get("attr2")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"val2", "val3"}));
            user.setEmail("bobby@localhost");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"bobby@localhost", (Object)user.getEmail());
            user.setEmail("john-doh@localhost");
            this.updateError(user, 409, "emailExistsMessage");
            user.setEmail("test-user@localhost");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"test-user@localhost", (Object)user.getEmail());
            user.setUsername("john-doh@localhost");
            this.updateError(user, 409, "usernameExistsMessage");
            user.setUsername("test-user@localhost");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername("updatedUsername");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername("updatedUsername");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"updatedusername", (Object)user.getUsername());
            realmRep.setEditUsernameAllowed(Boolean.valueOf(false));
            realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername("updatedUsername2");
            this.updateError(user, 400, "readOnlyUsernameMessage");
        }
        finally {
            realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername(originalUsername);
            user.setFirstName(originalFirstName);
            user.setLastName(originalLastName);
            user.setEmail(originalEmail);
            user.setAttributes(originalAttributes);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfileCannotChangeThroughAttributes() throws IOException {
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalUsername = user.getUsername();
        HashMap originalAttributes = new HashMap(user.getAttributes());
        try {
            user.getAttributes().put("username", Collections.singletonList("Username"));
            user.getAttributes().put("attr2", Collections.singletonList("val2"));
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)user.getUsername(), (Object)originalUsername);
        }
        finally {
            RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
            realmRep.setEditUsernameAllowed(Boolean.valueOf(true));
            this.adminClient.realm("test").update(realmRep);
            user.setUsername(originalUsername);
            user.setAttributes(originalAttributes);
            SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
            System.out.println(response.asString());
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProfileWithRegistrationEmailAsUsername() throws IOException {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
        this.adminClient.realm("test").update(realmRep);
        org.keycloak.representations.account.UserRepresentation user = this.getUser();
        String originalFirstname = user.getFirstName();
        try {
            user.setFirstName("Homer1");
            user = this.updateAndGet(user);
            Assert.assertEquals((Object)"Homer1", (Object)user.getFirstName());
        }
        finally {
            user.setFirstName(originalFirstname);
            int status = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asStatus();
            Assert.assertEquals((long)204L, (long)status);
        }
    }

    protected org.keycloak.representations.account.UserRepresentation getUser() throws IOException {
        SimpleHttp a = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken());
        try {
            return (org.keycloak.representations.account.UserRepresentation)a.asJson(org.keycloak.representations.account.UserRepresentation.class);
        }
        catch (IOException e) {
            System.err.println("Error during user reading: " + a.asString());
            throw e;
        }
    }

    protected org.keycloak.representations.account.UserRepresentation updateAndGet(org.keycloak.representations.account.UserRepresentation user) throws IOException {
        SimpleHttp a = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user);
        try {
            Assert.assertEquals((long)204L, (long)a.asStatus());
        }
        catch (AssertionError e) {
            System.err.println("Error during user update: " + a.asString());
            throw e;
        }
        return this.getUser();
    }

    protected void updateError(org.keycloak.representations.account.UserRepresentation user, int expectedStatus, String expectedMessage) throws IOException {
        SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        Assert.assertEquals((Object)expectedMessage, (Object)((ErrorRepresentation)response.asJson(ErrorRepresentation.class)).getErrorMessage());
    }

    @Test
    public void testProfilePermissions() throws IOException {
        TokenUtil noaccessToken = new TokenUtil("no-account-access", "password");
        TokenUtil viewToken = new TokenUtil("view-account-access", "password");
        Assert.assertEquals((long)403L, (long)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).header("Accept", "application/json").auth(noaccessToken.getToken()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(noaccessToken.getToken()).json((Object)new org.keycloak.representations.account.UserRepresentation()).asStatus());
        Assert.assertEquals((long)403L, (long)SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(viewToken.getToken()).json((Object)new org.keycloak.representations.account.UserRepresentation()).asStatus());
    }

    @Test
    public void testUpdateProfilePermissions() throws IOException {
        TokenUtil noaccessToken = new TokenUtil("no-account-access", "password");
        int status = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).header("Accept", "application/json").auth(noaccessToken.getToken()).asStatus();
        Assert.assertEquals((long)403L, (long)status);
        TokenUtil viewToken = new TokenUtil("view-account-access", "password");
        status = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).header("Accept", "application/json").auth(viewToken.getToken()).asStatus();
        Assert.assertEquals((long)200L, (long)status);
    }

    @Test
    public void testCredentialsGet() throws IOException {
        this.configureBrowserFlowWithWebAuthnAuthenticator("browser-webauthn");
        RequiredActionProviderSimpleRepresentation requiredAction = new RequiredActionProviderSimpleRepresentation();
        requiredAction.setId("12345");
        requiredAction.setName("webauthn-register");
        requiredAction.setProviderId("webauthn-register");
        this.testRealm().flows().registerRequiredAction(requiredAction);
        requiredAction = new RequiredActionProviderSimpleRepresentation();
        requiredAction.setId("6789");
        requiredAction.setName("webauthn-register-passwordless");
        requiredAction.setProviderId("webauthn-register-passwordless");
        this.testRealm().flows().registerRequiredAction(requiredAction);
        List credentials = this.getCredentials();
        Assert.assertEquals((long)4L, (long)credentials.size());
        AccountCredentialResource.CredentialContainer password = credentials.get(0);
        this.assertCredentialContainerExpected(password, "password", CredentialTypeMetadata.Category.BASIC_AUTHENTICATION.toString(), "password-display-name", "password-help-text", "kcAuthenticatorPasswordClass", null, UserModel.RequiredAction.UPDATE_PASSWORD.toString(), false, 1);
        CredentialRepresentation password1 = (CredentialRepresentation)password.getUserCredentials().get(0);
        Assert.assertNull((Object)password1.getSecretData());
        Assert.assertNotNull((Object)password1.getCredentialData());
        AccountCredentialResource.CredentialContainer otp = credentials.get(1);
        this.assertCredentialContainerExpected(otp, "otp", CredentialTypeMetadata.Category.TWO_FACTOR.toString(), "otp-display-name", "otp-help-text", "kcAuthenticatorOTPClass", UserModel.RequiredAction.CONFIGURE_TOTP.toString(), null, true, 0);
        AccountCredentialResource.CredentialContainer webauthn = credentials.get(2);
        this.assertCredentialContainerExpected(webauthn, "webauthn", CredentialTypeMetadata.Category.TWO_FACTOR.toString(), "webauthn-display-name", "webauthn-help-text", "kcAuthenticatorWebAuthnClass", "webauthn-register", null, true, 0);
        AccountCredentialResource.CredentialContainer webauthnPasswordless = credentials.get(3);
        this.assertCredentialContainerExpected(webauthnPasswordless, "webauthn-passwordless", CredentialTypeMetadata.Category.PASSWORDLESS.toString(), "webauthn-passwordless-display-name", "webauthn-passwordless-help-text", "kcAuthenticatorWebAuthnPasswordlessClass", "webauthn-register-passwordless", null, true, 0);
        this.setRequiredActionEnabledStatus("webauthn-register-passwordless", false);
        credentials = this.getCredentials();
        this.assertExpectedCredentialTypes(credentials, "password", "otp", "webauthn");
        this.removeWebAuthnFlow("browser-webauthn");
        credentials = this.getCredentials();
        this.assertExpectedCredentialTypes(credentials, "password", "otp");
        credentials = (List)SimpleHttp.doGet((String)this.getAccountUrl("credentials?type=password"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<AccountCredentialResource.CredentialContainer>>(){});
        Assert.assertEquals((long)1L, (long)credentials.size());
        password = (AccountCredentialResource.CredentialContainer)credentials.get(0);
        Assert.assertEquals((Object)"password", (Object)password.getType());
        Assert.assertEquals((long)1L, (long)password.getUserCredentials().size());
        credentials = (List)SimpleHttp.doGet((String)this.getAccountUrl("credentials?type=password&user-credentials=false"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<AccountCredentialResource.CredentialContainer>>(){});
        Assert.assertEquals((long)1L, (long)credentials.size());
        password = (AccountCredentialResource.CredentialContainer)credentials.get(0);
        Assert.assertEquals((Object)"password", (Object)password.getType());
        Assert.assertNull((Object)password.getUserCredentials());
    }

    @Test
    public void testCRUDCredentialOfDifferentUser() throws IOException {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-one-configured-otp");
        CredentialRepresentation otpCredential = user.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("credentials/" + otpCredential.getId() + "/label"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)"new-label").asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = SimpleHttp.doDelete((String)this.getAccountUrl("credentials/" + otpCredential.getId()), (HttpClient)this.httpClient).acceptJson().auth(this.tokenUtil.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        CredentialRepresentation otpCredentialLoaded = user.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getUserLabel(), (Object)otpCredentialLoaded.getUserLabel()));
    }

    private List<AccountCredentialResource.CredentialContainer> getCredentials() throws IOException {
        return (List)SimpleHttp.doGet((String)this.getAccountUrl("credentials"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<List<AccountCredentialResource.CredentialContainer>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCredentialsGetDisabledOtp() throws IOException {
        AuthenticationExecutionModel.Requirement currentBrowserReq = this.setExecutionRequirement("browser", "Browser - Conditional OTP", AuthenticationExecutionModel.Requirement.DISABLED);
        AuthenticationExecutionModel.Requirement currentFBLReq = this.setExecutionRequirement("first broker login", "OTP Form", AuthenticationExecutionModel.Requirement.DISABLED);
        AuthenticationExecutionModel.Requirement currentDirectGrantReq = this.setExecutionRequirement("direct grant", "Direct Grant - Conditional OTP", AuthenticationExecutionModel.Requirement.DISABLED);
        try {
            List<AccountCredentialResource.CredentialContainer> credentials = this.getCredentials();
            Assert.assertEquals((long)1L, (long)credentials.size());
            Assert.assertEquals((Object)"password", (Object)credentials.get(0).getType());
            this.setExecutionRequirement("browser", "Browser - Conditional OTP", currentBrowserReq);
            credentials = this.getCredentials();
            Assert.assertEquals((long)2L, (long)credentials.size());
            Assert.assertEquals((Object)"otp", (Object)credentials.get(1).getType());
            this.setExecutionRequirement("browser", "Browser - Conditional OTP", AuthenticationExecutionModel.Requirement.DISABLED);
            this.setExecutionRequirement("first broker login", "OTP Form", currentFBLReq);
            credentials = this.getCredentials();
            Assert.assertEquals((long)2L, (long)credentials.size());
            Assert.assertEquals((Object)"otp", (Object)credentials.get(1).getType());
        }
        finally {
            this.setExecutionRequirement("browser", "Browser - Conditional OTP", currentBrowserReq);
            this.setExecutionRequirement("direct grant", "Direct Grant - Conditional OTP", currentDirectGrantReq);
        }
    }

    @Test
    public void testCredentialsGetWithDisabledOtpRequiredAction() throws IOException {
        List<AccountCredentialResource.CredentialContainer> credentials = this.getCredentials();
        this.assertExpectedCredentialTypes(credentials, "password", "otp");
        this.setRequiredActionEnabledStatus(UserModel.RequiredAction.CONFIGURE_TOTP.name(), false);
        credentials = this.getCredentials();
        this.assertExpectedCredentialTypes(credentials, "password");
        UserResource adminUserResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation userRep = UserBuilder.edit(adminUserResource.toRepresentation()).totpSecret("abcdefabcdef").build();
        adminUserResource.update(userRep);
        credentials = this.getCredentials();
        this.assertExpectedCredentialTypes(credentials, "password", "otp");
        AccountCredentialResource.CredentialContainer otpCredential = credentials.get(1);
        Assert.assertNull((Object)otpCredential.getCreateAction());
        Assert.assertNull((Object)otpCredential.getUpdateAction());
        this.setRequiredActionEnabledStatus(UserModel.RequiredAction.CONFIGURE_TOTP.name(), true);
        String otpCredentialId = adminUserResource.credentials().stream().filter(credential -> "otp".equals(credential.getType())).findFirst().get().getId();
        adminUserResource.removeCredential(otpCredentialId);
    }

    private void setRequiredActionEnabledStatus(String requiredActionProviderId, boolean enabled) {
        RequiredActionProviderRepresentation requiredActionRep = this.testRealm().flows().getRequiredAction(requiredActionProviderId);
        requiredActionRep.setEnabled(enabled);
        this.testRealm().flows().updateRequiredAction(requiredActionProviderId, requiredActionRep);
    }

    private void assertExpectedCredentialTypes(List<AccountCredentialResource.CredentialContainer> credentialTypes, String ... expectedCredentialTypes) {
        Assert.assertEquals((long)credentialTypes.size(), (long)expectedCredentialTypes.length);
        int i = 0;
        for (AccountCredentialResource.CredentialContainer credential : credentialTypes) {
            Assert.assertEquals((Object)credential.getType(), (Object)expectedCredentialTypes[i]);
            ++i;
        }
    }

    @Test
    public void testCredentialsForUserWithoutPassword() throws IOException {
        List<AccountCredentialResource.CredentialContainer> credentials = this.getCredentials();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user@localhost");
        for (CredentialRepresentation credential : user.credentials()) {
            if (!"password".equals(credential.getType())) continue;
            user.removeCredential(credential.getId());
        }
        credentials = this.getCredentials();
        AccountCredentialResource.CredentialContainer password = credentials.get(0);
        this.assertCredentialContainerExpected(password, "password", CredentialTypeMetadata.Category.BASIC_AUTHENTICATION.toString(), "password-display-name", "password-help-text", "kcAuthenticatorPasswordClass", UserModel.RequiredAction.UPDATE_PASSWORD.toString(), null, false, 0);
        ApiUtil.resetUserPassword((UserResource)user, (String)"password", (boolean)false);
    }

    private AuthenticationExecutionModel.Requirement setExecutionRequirement(String flowAlias, String executionDisplayName, AuthenticationExecutionModel.Requirement newRequirement) {
        List executionInfos = this.testRealm().flows().getExecutions(flowAlias);
        for (AuthenticationExecutionInfoRepresentation exInfo : executionInfos) {
            if (!executionDisplayName.equals(exInfo.getDisplayName())) continue;
            AuthenticationExecutionModel.Requirement currentRequirement = AuthenticationExecutionModel.Requirement.valueOf((String)exInfo.getRequirement());
            exInfo.setRequirement(newRequirement.toString());
            this.testRealm().flows().updateExecutions(flowAlias, exInfo);
            return currentRequirement;
        }
        throw new IllegalStateException("Not found execution '" + executionDisplayName + "' in flow '" + flowAlias + "'.");
    }

    private void configureBrowserFlowWithWebAuthnAuthenticator(String newFlowAlias) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", newFlowAlias);
        Response response = this.testRealm().flows().copy("browser", params);
        response.close();
        String flowId = AbstractAuthenticationTest.findFlowByAlias(newFlowAlias, this.testRealm().flows().getFlows()).getId();
        AuthenticationExecutionRepresentation execution = new AuthenticationExecutionRepresentation();
        execution.setParentFlow(flowId);
        execution.setAuthenticator("webauthn-authenticator");
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        response = this.testRealm().flows().addExecution(execution);
        response.close();
        execution = new AuthenticationExecutionRepresentation();
        execution.setParentFlow(flowId);
        execution.setAuthenticator("webauthn-authenticator-passwordless");
        execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        response = this.testRealm().flows().addExecution(execution);
        response.close();
    }

    private void removeWebAuthnFlow(String flowToDeleteAlias) {
        List flows = this.testRealm().flows().getFlows();
        AuthenticationFlowRepresentation flowRepresentation = AbstractAuthenticationTest.findFlowByAlias(flowToDeleteAlias, flows);
        this.testRealm().flows().deleteFlow(flowRepresentation.getId());
    }

    private void assertCredentialContainerExpected(AccountCredentialResource.CredentialContainer credential, String type, String category, String displayName, String helpText, String iconCssClass, String createAction, String updateAction, boolean removeable, int userCredentialsCount) {
        Assert.assertEquals((Object)type, (Object)credential.getType());
        Assert.assertEquals((Object)category, (Object)credential.getCategory());
        Assert.assertEquals((Object)displayName, (Object)credential.getDisplayName());
        Assert.assertEquals((Object)helpText, (Object)credential.getHelptext());
        Assert.assertEquals((Object)iconCssClass, (Object)credential.getIconCssClass());
        Assert.assertEquals((Object)createAction, (Object)credential.getCreateAction());
        Assert.assertEquals((Object)updateAction, (Object)credential.getUpdateAction());
        Assert.assertEquals((Object)removeable, (Object)credential.isRemoveable());
        Assert.assertEquals((long)userCredentialsCount, (long)credential.getUserCredentials().size());
    }

    public void testDeleteSessions() throws IOException {
        TokenUtil viewToken = new TokenUtil("view-account-access", "password");
        this.oauth.doLogin("view-account-access", "password");
        List sessions = (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).auth(viewToken.getToken()).asJson((TypeReference)new TypeReference<List<SessionRepresentation>>(){});
        Assert.assertEquals((long)2L, (long)sessions.size());
        int status = SimpleHttp.doDelete((String)this.getAccountUrl("sessions?current=false"), (HttpClient)this.httpClient).acceptJson().auth(viewToken.getToken()).asStatus();
        Assert.assertEquals((long)200L, (long)status);
        sessions = (List)SimpleHttp.doGet((String)this.getAccountUrl("sessions"), (HttpClient)this.httpClient).auth(viewToken.getToken()).asJson((TypeReference)new TypeReference<List<SessionRepresentation>>(){});
        Assert.assertEquals((long)1L, (long)sessions.size());
    }

    @Test
    public void listApplications() throws Exception {
        this.oauth.clientId("in-use-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "view-applications-access", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"in-use-client", "always-display-client", "direct-grant"}));
        this.assertClientRep(apps.get("in-use-client"), "In Use Client", null, false, true, false, null, this.inUseClientAppUri);
        this.assertClientRep(apps.get("always-display-client"), "Always Display Client", null, false, false, false, null, this.alwaysDisplayClientAppUri);
        this.assertClientRep(apps.get("direct-grant"), null, null, false, true, false, null, null);
    }

    @Test
    public void listApplicationsFiltered() throws Exception {
        this.oauth.clientId("in-use-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "view-applications-access", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").param("name", "In Use").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"in-use-client"}));
        this.assertClientRep(apps.get("in-use-client"), "In Use Client", null, false, true, false, null, this.inUseClientAppUri);
    }

    @Test
    public void listApplicationsOfflineAccess() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse offlineTokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "view-applications-access", "password");
        Assert.assertNull((Object)offlineTokenResponse.getErrorDescription());
        this.oauth.clientId("offline-client-without-base-url");
        offlineTokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "view-applications-access", "password");
        Assert.assertNull((Object)offlineTokenResponse.getErrorDescription());
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"offline-client", "offline-client-without-base-url", "always-display-client", "direct-grant"}));
        this.assertClientRep(apps.get("offline-client"), "Offline Client", null, false, true, true, null, this.offlineClientAppUri);
        this.assertClientRep(apps.get("offline-client-without-base-url"), "Offline Client Without Base URL", null, false, true, true, null, null);
    }

    @Test
    public void listApplicationsThirdParty() throws Exception {
        String appId = "third-party";
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        SimpleHttp.doDelete((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{appId, "always-display-client", "direct-grant"}));
        ClientRepresentation app = apps.get(appId);
        this.assertClientRep(app, null, "A third party application", true, false, false, null, "http://localhost:8180/auth/realms/master/app/auth");
        Assert.assertFalse((boolean)app.getConsent().getGrantedScopes().isEmpty());
        ConsentScopeRepresentation grantedScope = (ConsentScopeRepresentation)app.getConsent().getGrantedScopes().get(0);
        Assert.assertEquals((Object)clientScopeRepresentation.getId(), (Object)grantedScope.getId());
        Assert.assertEquals((Object)clientScopeRepresentation.getName(), (Object)grantedScope.getName());
    }

    @Test
    public void listApplicationsWithRootUrl() throws Exception {
        this.oauth.clientId("root-url-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "view-applications-access", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"root-url-client", "always-display-client", "direct-grant"}));
        this.assertClientRep(apps.get("root-url-client"), null, null, false, true, false, "http://localhost:8180/foo/bar", "/baz");
    }

    private void assertClientRep(ClientRepresentation clientRep, String name, String description, boolean userConsentRequired, boolean inUse, boolean offlineAccess, String rootUrl, String baseUrl) {
        Assert.assertNotNull((Object)clientRep);
        Assert.assertEquals((Object)name, (Object)clientRep.getClientName());
        Assert.assertEquals((Object)description, (Object)clientRep.getDescription());
        Assert.assertEquals((Object)userConsentRequired, (Object)clientRep.isUserConsentRequired());
        Assert.assertEquals((Object)inUse, (Object)clientRep.isInUse());
        Assert.assertEquals((Object)offlineAccess, (Object)clientRep.isOfflineAccess());
        Assert.assertEquals((Object)rootUrl, (Object)clientRep.getRootUrl());
        Assert.assertEquals((Object)baseUrl, (Object)clientRep.getBaseUrl());
        Assert.assertEquals((Object)ResolveRelative.resolveRelativeUri(null, null, (String)rootUrl, (String)baseUrl), (Object)clientRep.getEffectiveUrl());
    }

    @Test
    public void listApplicationsWithoutPermission() throws IOException {
        TokenUtil token = new TokenUtil("no-account-access", "password");
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void getNotExistingApplication() throws IOException {
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        String appId = "not-existing";
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("applications/" + appId), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void createConsentForClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation = (ConsentRepresentation)SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation.getGrantedScopes().get(0)).getId());
    }

    @Test
    public void updateConsentForClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation = (ConsentRepresentation)SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation.getGrantedScopes().get(0)).getId());
        clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(1);
        consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation2 = (ConsentRepresentation)SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation2.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)consentRepresentation.getCreatedDate(), (Object)consentRepresentation2.getCreatedDate());
        Assert.assertTrue((consentRepresentation2.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation2.getLastUpdatedDate() > consentRepresentation.getLastUpdatedDate() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation2.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation2.getGrantedScopes().get(0)).getId());
    }

    @Test
    public void createConsentForNotExistingClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "not-existing";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void createConsentForClientWithoutPermission() throws IOException {
        TokenUtil token = new TokenUtil("view-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asResponse();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void createConsentForClientWithPut() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation = (ConsentRepresentation)SimpleHttp.doPut((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation.getGrantedScopes().get(0)).getId());
    }

    @Test
    public void updateConsentForClientWithPut() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation = (ConsentRepresentation)SimpleHttp.doPut((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation.getGrantedScopes().get(0)).getId());
        clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(1);
        consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation2 = (ConsentRepresentation)SimpleHttp.doPut((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation2.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)consentRepresentation.getCreatedDate(), (Object)consentRepresentation2.getCreatedDate());
        Assert.assertTrue((consentRepresentation2.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation2.getLastUpdatedDate() > consentRepresentation.getLastUpdatedDate() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation2.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation2.getGrantedScopes().get(0)).getId());
    }

    @Test
    public void createConsentForNotExistingClientWithPut() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "not-existing";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void createConsentForClientWithoutPermissionWithPut() throws IOException {
        TokenUtil token = new TokenUtil("view-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        SimpleHttp.Response response = SimpleHttp.doPut((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asResponse();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void getConsentForClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation1 = (ConsentRepresentation)SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation1.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation1.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation1.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation1.getGrantedScopes().get(0)).getId());
        ConsentRepresentation consentRepresentation2 = (ConsentRepresentation)SimpleHttp.doGet((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertEquals((Object)consentRepresentation1.getLastUpdatedDate(), (Object)consentRepresentation2.getLastUpdatedDate());
        Assert.assertEquals((Object)consentRepresentation1.getCreatedDate(), (Object)consentRepresentation2.getCreatedDate());
        Assert.assertEquals((Object)((ConsentScopeRepresentation)consentRepresentation1.getGrantedScopes().get(0)).getId(), (Object)((ConsentScopeRepresentation)consentRepresentation2.getGrantedScopes().get(0)).getId());
    }

    @Test
    public void getConsentForNotExistingClient() throws IOException {
        TokenUtil token = new TokenUtil("view-consent-access", "password");
        String appId = "not-existing";
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void getNotExistingConsentForClient() throws IOException {
        TokenUtil token = new TokenUtil("view-consent-access", "password");
        String appId = "security-admin-console";
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void getConsentWithoutPermission() throws IOException {
        TokenUtil token = new TokenUtil("no-account-access", "password");
        String appId = "security-admin-console";
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void deleteConsentForClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "security-admin-console";
        ClientScopeRepresentation clientScopeRepresentation = (ClientScopeRepresentation)this.testRealm().clientScopes().findAll().get(0);
        ConsentScopeRepresentation consentScopeRepresentation = new ConsentScopeRepresentation();
        consentScopeRepresentation.setId(clientScopeRepresentation.getId());
        ConsentRepresentation requestedConsent = new ConsentRepresentation();
        requestedConsent.setGrantedScopes(Collections.singletonList(consentScopeRepresentation));
        ConsentRepresentation consentRepresentation = (ConsentRepresentation)SimpleHttp.doPost((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").json((Object)requestedConsent).auth(token.getToken()).asJson(ConsentRepresentation.class);
        Assert.assertTrue((consentRepresentation.getCreatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((consentRepresentation.getLastUpdatedDate() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)consentRepresentation.getGrantedScopes().size());
        Assert.assertEquals((Object)consentScopeRepresentation.getId(), (Object)((ConsentScopeRepresentation)consentRepresentation.getGrantedScopes().get(0)).getId());
        SimpleHttp.Response response = SimpleHttp.doDelete((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = SimpleHttp.doDelete((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void deleteConsentForNotExistingClient() throws IOException {
        TokenUtil token = new TokenUtil("manage-consent-access", "password");
        String appId = "not-existing";
        SimpleHttp.Response response = SimpleHttp.doDelete((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void deleteConsentWithoutPermission() throws IOException {
        TokenUtil token = new TokenUtil("view-consent-access", "password");
        String appId = "security-admin-console";
        SimpleHttp.Response response = SimpleHttp.doDelete((String)this.getAccountUrl("applications/" + appId + "/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void revokeOfflineAccess() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse offlineTokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "view-applications-access", "password");
        Assert.assertNull((Object)offlineTokenResponse.getErrorDescription());
        TokenUtil token = new TokenUtil("view-applications-access", "password");
        SimpleHttp.Response response = SimpleHttp.doDelete((String)this.getAccountUrl("applications/offline-client/consent"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asResponse();
        Assert.assertEquals((long)204L, (long)response.getStatus());
        List applications = (List)SimpleHttp.doGet((String)this.getAccountUrl("applications"), (HttpClient)this.httpClient).header("Accept", "application/json").auth(token.getToken()).asJson((TypeReference)new TypeReference<List<ClientRepresentation>>(){});
        Assert.assertFalse((boolean)applications.isEmpty());
        Map<String, ClientRepresentation> apps = applications.stream().collect(Collectors.toMap(x -> x.getClientId(), x -> x));
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"offline-client", "always-display-client", "direct-grant"}));
        this.assertClientRep(apps.get("offline-client"), "Offline Client", null, false, true, false, null, this.offlineClientAppUri);
    }

    @Test
    public void testApiVersion() throws IOException {
        this.apiVersion = AccountRestApiVersion.DEFAULT.getStrVersion();
        this.testUpdateProfile();
        this.testCredentialsGet();
    }

    @Test
    public void testInvalidApiVersion() throws IOException {
        this.apiVersion = "v2-foo";
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl("credentials"), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asResponse();
        Assert.assertEquals((Object)"API version not found", (Object)response.asJson().get("error").textValue());
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testAudience() throws Exception {
        this.oauth.clientId("custom-audience");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        SimpleHttp.Response response = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(tokenResponse.getAccessToken()).header("Accept", "application/json").asResponse();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        org.keycloak.representations.idm.ClientRepresentation clientRep = (org.keycloak.representations.idm.ClientRepresentation)this.testRealm().clients().findByClientId("custom-audience").get(0);
        ProtocolMapperRepresentation mapperRep = clientRep.getProtocolMappers().stream().filter(m -> m.getName().equals("aud")).findFirst().orElse(null);
        Assert.assertNotNull((String)"Audience mapper not found", (Object)mapperRep);
        mapperRep.getConfig().put("included.custom.audience", "account");
        this.testRealm().clients().get(clientRep.getId()).getProtocolMappers().update(mapperRep.getId(), mapperRep);
        tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        response = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(tokenResponse.getAccessToken()).header("Accept", "application/json").asResponse();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.testRealm().clients().get(clientRep.getId()).getProtocolMappers().delete(mapperRep.getId());
        tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        response = SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(tokenResponse.getAccessToken()).header("Accept", "application/json").asResponse();
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    protected boolean isDeclarativeUserProfile() {
        return false;
    }
}

