/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.enums.AccountRestApiVersion;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.TokenUtil;
import org.keycloak.testsuite.util.WebDriverLogDumper;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AccountRestServiceCorsTest
extends AbstractTestRealmKeycloakTest {
    private static final String VALID_CORS_URL = "http://localtest.me:8180/auth";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180/auth";
    @Rule
    public TokenUtil tokenUtil = new TokenUtil();
    private CloseableHttpClient client;
    private JavascriptExecutor executor;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
        this.oauth.clientId("direct-grant");
        this.executor = (JavascriptExecutor)this.driver;
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setEditUsernameAllowed(Boolean.valueOf(false));
    }

    @Test
    public void testGetProfile() throws IOException, InterruptedException {
        this.driver.navigate().to(VALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), null, true);
    }

    @Test
    public void testGetProfileInvalidOrigin() throws IOException, InterruptedException {
        this.driver.navigate().to(INVALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), null, false);
    }

    @Test
    public void testUpdateProfile() throws IOException {
        this.driver.navigate().to(VALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), "{ \"firstName\" : \"Bob\" }", true);
    }

    @Test
    public void testUpdateProfileInvalidOrigin() throws IOException {
        this.driver.navigate().to(INVALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), "{ \"firstName\" : \"Bob\" }", false);
    }

    @Test
    public void testErrorResponse() {
        this.driver.navigate().to(VALID_CORS_URL);
        Result result = this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), "{ \"username\" : \"vmuzikar\" }", true);
        Assert.assertEquals((long)400L, (long)result.getStatus());
        Assert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.containsString((String)"readOnlyUsernameMessage"));
    }

    @Test
    public void testErrorResponseInvalidOrigin() {
        this.driver.navigate().to(INVALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl(), this.tokenUtil.getToken(), "{ \"username\" : \"vmuzikar\" }", false);
    }

    @Test
    public void testGetVersionedApi() {
        this.driver.navigate().to(VALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl() + "/" + AccountRestApiVersion.DEFAULT.getStrVersion(), this.tokenUtil.getToken(), null, true);
    }

    @Test
    public void testGetVersionedApiInvalidOrigin() {
        this.driver.navigate().to(INVALID_CORS_URL);
        this.doXhr(this.executor, this.getAccountUrl() + "/" + AccountRestApiVersion.DEFAULT.getStrVersion(), this.tokenUtil.getToken(), null, false);
    }

    private String getAccountUrl() {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/realms/test/account";
    }

    private Result doXhr(JavascriptExecutor executor, String url, String token, String postData, boolean expectAllowed) {
        String js = "var r = new XMLHttpRequest();r.open('" + (postData == null ? "GET" : "POST") + "', '" + url + "', false);r.setRequestHeader('Accept','application/json');r.setRequestHeader('Content-Type','application/json');r.setRequestHeader('Authorization','bearer " + token + "');r.send(" + (postData == null ? "" : "'" + postData + "'") + ");return r.status + ':::' + r.responseText";
        Result result = null;
        Throwable error = null;
        try {
            String response = (String)executor.executeScript(js, new Object[0]);
            String[] r = response.split(":::");
            result = new Result(Integer.parseInt(r[0]), r.length == 2 ? r[1] : null);
        }
        catch (Throwable t) {
            error = t;
        }
        if (error != null) {
            if (expectAllowed) {
                throw new AssertionError((Object)("Cors request failed: " + WebDriverLogDumper.dumpBrowserLogs((WebDriver)this.driver)));
            }
            return result;
        }
        if (!expectAllowed) {
            throw new AssertionError((Object)"Expected CORS request to be rejected, but was successful");
        }
        return result;
    }

    private static class Result {
        int status;
        String result;

        public Result(int status, String result) {
            this.status = status;
            this.result = result;
        }

        public int getStatus() {
            return this.status;
        }

        public String getResult() {
            return this.result;
        }
    }
}

