/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.drone.Different;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AccountFederatedIdentityPage;
import org.keycloak.testsuite.pages.AccountLogPage;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.AccountSessionsPage;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.RoleScopeUpdater;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.userprofile.UserProfileContext;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class AccountFormServiceTest
extends AbstractTestRealmKeycloakTest {
    public static final String ROOT_URL_CLIENT = "root-url-client";
    public static final String REALM_NAME = "test";
    @Drone
    @Different
    WebDriver driver2;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected AccountPasswordPage changePasswordPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected AccountTotpPage totpPage;
    @Page
    protected AccountLogPage logPage;
    @Page
    protected AccountSessionsPage sessionsPage;
    @Page
    protected AccountApplicationsPage applicationsPage;
    @Page
    protected AccountFederatedIdentityPage federatedIdentityPage;
    @Page
    protected ErrorPage errorPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private String userId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user2 = UserBuilder.create().enabled(true).username("test-user-no-access@localhost").email("test-user-no-access@localhost").password("password").build();
        UserRepresentation realmAdmin = UserBuilder.create().enabled(true).username("realm-admin").password("password").role("realm-management", AdminRoles.REALM_ADMIN).role("account", "manage-account").build();
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("github").alias("github").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("saml").alias("mysaml").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("myoidc").displayName("MyOIDC").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("myhiddenoidc").displayName("MyHiddenOIDC").hideOnLoginPage().build());
        RealmBuilder.edit(testRealm).user(user2).user(realmAdmin);
        if (ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            this.findTestApp(testRealm).setBaseUrl(String.format("%s/auth/realms/master/app/auth", ServerURLs.getAuthServerContextRoot()));
        }
    }

    @Before
    public void before() {
        UserRepresentation user = this.findUser("test-user@localhost");
        user.setEmail("test-user@localhost");
        this.updateUser(user);
        this.userId = user.getId();
        this.setPasswordPolicy("");
        ApiUtil.resetUserPassword((UserResource)this.testRealm().users().get(this.userId), (String)"password", (boolean)false);
    }

    @Test
    public void returnToAppFromQueryParam() {
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app");
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.driver.navigate().to(String.format("%s?referrer=test-app&referrer_uri=%s/auth/realms/master/app/auth?test", this.profilePage.getPath(), ServerURLs.getAuthServerContextRoot()));
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        Assert.assertEquals((Object)(OAuthClient.APP_AUTH_ROOT + "?test"), (Object)this.driver.getCurrentUrl());
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.driver.findElement(By.linkText((String)"Authenticator")).click();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.driver.findElement(By.linkText((String)"Account")).click();
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.events.clear();
    }

    @Test
    public void referrerEscaped() {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app&referrer_uri=http%3A%2F%2Flocalhost%3A8180%2Fauth%2Frealms%2Fmaster%2Fapp%2Fauth%2Ftest%2Ffkrenu%3Fq%3D%2522%253E%253Cscript%253Ealert%25281%2529%253C%252fscript%253E");
        this.profilePage.assertCurrent();
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("<script>alert"));
    }

    @Test
    public void changePassword() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        EventRepresentation event = this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        String sessionId = event.getSessionId();
        String userId = event.getUserId();
        this.changePasswordPage.changePassword("", "new-password", "new-password");
        Assert.assertEquals((Object)"Please specify password.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_missing").assertEvent();
        this.changePasswordPage.changePassword("password", "new-password", "new-password2");
        Assert.assertEquals((Object)"Password confirmation doesn't match.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_confirm_error").assertEvent();
        this.changePasswordPage.changePassword("password", "new-password", "new-password");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
        this.changePasswordPage.logout();
        this.events.expectLogout(sessionId).detail("redirect_uri", this.changePasswordPage.getPath()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().session((String)null).error("invalid_user_credentials").removeDetail("consent").assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "new-password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setPasswordPolicy(policy);
        this.testRealm().update(testRealm);
    }

    @Test
    public void changePasswordWithBlankCurrentPassword() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("", "new", "new");
        Assert.assertEquals((Object)"Please specify password.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_missing").assertEvent();
        this.changePasswordPage.changePassword("password", "new", "new");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithLengthPasswordPolicy() {
        this.setPasswordPolicy("length(8)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "1234", "1234");
        Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "12345678", "12345678");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithDigitsPolicy() {
        this.setPasswordPolicy("digits(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword1", "invalidPassword1");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 numerical digits.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "validPassword12", "validPassword12");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithLowerCasePolicy() {
        this.setPasswordPolicy("lowerCase(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "iNVALIDPASSWORD", "iNVALIDPASSWORD");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 lower case characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "vaLIDPASSWORD", "vaLIDPASSWORD");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithUpperCasePolicy() {
        this.setPasswordPolicy("upperCase(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "Invalidpassword", "Invalidpassword");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 upper case characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "VAlidpassword", "VAlidpassword");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithSpecialCharsPolicy() {
        this.setPasswordPolicy("specialChars(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword*", "invalidPassword*");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 special characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "validPassword*#", "validPassword*#");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithNotUsernamePolicy() {
        this.setPasswordPolicy("notUsername(1)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "test-user@localhost", "test-user@localhost");
        Assert.assertEquals((Object)"Invalid password: must not be equal to the username.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "newPassword", "newPassword");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithNotEmailPolicy() {
        this.setPasswordPolicy("notEmail(1)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "test-user@localhost", "test-user@localhost");
        Assert.assertEquals((Object)"Invalid password: must not be equal to the email.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "newPassword", "newPassword");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithRegexPatternsPolicy() {
        this.setPasswordPolicy("regexPattern(^[A-Z]+#[a-z]{8}$)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword", "invalidPassword");
        Assert.assertEquals((Object)"Invalid password: fails to match regex pattern(s).", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "VALID#password", "VALID#password");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    private void assertChangePasswordSucceeds(String currentPassword, String newPassword) {
        this.changePasswordPage.changePassword(currentPassword, newPassword, newPassword);
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).user(this.userId).assertEvent();
    }

    private void assertChangePasswordFails(String currentPassword, String newPassword) {
        this.changePasswordPage.changePassword(currentPassword, newPassword, newPassword);
        Assert.assertThat((Object)this.profilePage.getError(), (Matcher)Matchers.containsString((String)"Invalid password: must not be equal to any of last"));
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).user(this.userId).error("password_rejected").assertEvent();
    }

    private void assertNumberOfStoredCredentials(int expectedNumberOfStoredCredentials) {
        Assume.assumeTrue((String)"Works only on auth-server-undertow", (boolean)AuthServerTestEnricher.AUTH_SERVER_CONTAINER.equals("auth-server-undertow"));
        String uId = this.userId;
        this.testingClient.server(REALM_NAME).run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            UserModel user = session.users().getUserById(realm, uId);
            Assert.assertThat((Object)user, (Matcher)Matchers.notNullValue());
            List storedCredentials = session.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            Assert.assertThat(storedCredentials, (Matcher)Matchers.hasSize((int)expectedNumberOfStoredCredentials));
        });
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicyThreePasswords() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordWithPasswordHistoryPolicyThreePasswords", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(3)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordWithPasswordHistoryPolicyThreePasswords", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertChangePasswordFails("password", "password");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password3");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password3", "password");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password3", "password3");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordSucceeds("password3", "password4");
        this.assertNumberOfStoredCredentials(3);
        this.assertChangePasswordFails("password4", "password");
        this.assertNumberOfStoredCredentials(3);
        this.assertChangePasswordFails("password4", "password3");
        this.assertNumberOfStoredCredentials(3);
        this.assertChangePasswordFails("password4", "password4");
        this.assertNumberOfStoredCredentials(3);
        this.assertChangePasswordSucceeds("password4", "password5");
        this.assertNumberOfStoredCredentials(3);
        this.assertChangePasswordSucceeds("password5", "password");
        this.assertNumberOfStoredCredentials(3);
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicyTwoPasswords() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordWithPasswordHistoryPolicyTwoPasswords", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(2)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordWithPasswordHistoryPolicyTwoPasswords", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertChangePasswordFails("password", "password");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password1");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password1", "password");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password1", "password1");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordSucceeds("password1", "password2");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password2", "password1");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordFails("password2", "password2");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordSucceeds("password2", "password");
        this.assertNumberOfStoredCredentials(2);
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicyOnePwds() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordWithPasswordHistoryPolicyOnePwds", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(1)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordWithPasswordHistoryPolicyOnePwds", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertChangePasswordFails("password", "password");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password6");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordFails("password6", "password6");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password6", "password");
        this.assertNumberOfStoredCredentials(1);
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicyZeroPwdsInHistory() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordWithPasswordHistoryPolicyZeroPwdsInHistory", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(0)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordWithPasswordHistoryPolicyZeroPwdsInHistory", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertChangePasswordFails("password", "password");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password1");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordFails("password1", "password1");
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password1", "password");
        this.assertNumberOfStoredCredentials(1);
    }

    @Test
    public void changePasswordToOldOneAfterPasswordHistoryPolicyExpirationChange() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordToOldOneAfterPasswordHistoryPolicyExpirationChange", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(3)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordToOldOneAfterPasswordHistoryPolicyExpirationChange", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password1");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordSucceeds("password1", "password2");
        this.assertNumberOfStoredCredentials(3);
        this.setPasswordPolicy("passwordHistory(2)");
        this.assertChangePasswordSucceeds("password2", "password");
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicyExpiration() {
        this.userId = this.createUser(REALM_NAME, "user-changePasswordWithPasswordHistoryPolicyExpiration", "password", new String[0]);
        this.setPasswordPolicy("passwordHistory(3)");
        this.changePasswordPage.open();
        this.loginPage.login("user-changePasswordWithPasswordHistoryPolicyExpiration", "password");
        this.events.expectLogin().user(this.userId).client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=password").assertEvent();
        this.assertNumberOfStoredCredentials(1);
        this.assertChangePasswordSucceeds("password", "password2");
        this.assertNumberOfStoredCredentials(2);
        this.assertChangePasswordSucceeds("password2", "password4");
        this.assertNumberOfStoredCredentials(3);
        this.setPasswordPolicy("passwordHistory(2)");
        this.assertChangePasswordSucceeds("password4", "password5");
        this.assertNumberOfStoredCredentials(2);
        this.setPasswordPolicy("passwordHistory(1)");
        this.assertChangePasswordSucceeds("password5", "password6");
        this.assertNumberOfStoredCredentials(1);
        this.setPasswordPolicy("passwordHistory(2)");
        this.assertChangePasswordSucceeds("password6", "password7");
        this.assertNumberOfStoredCredentials(2);
        this.setPasswordPolicy("passwordHistory(0)");
        this.assertChangePasswordSucceeds("password7", "password8");
        this.assertNumberOfStoredCredentials(1);
    }

    @Test
    public void changeProfile() throws Exception {
        this.setEditUsernameAllowed(false);
        this.setRegistrationEmailAsUsername(false);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("", "New last", "new@email.com");
        Assert.assertEquals((Object)"Please specify first name.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "", "new@email.com");
        Assert.assertEquals((Object)"Please specify last name.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "");
        Assert.assertEquals((Object)"Please specify email.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.clickCancel();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.expectAccount(EventType.UPDATE_PROFILE).detail("context", UserProfileContext.ACCOUNT_OLD.name()).detail("previous_first_name", "Tom").detail("updated_first_name", "New first").detail("previous_last_name", "Brady").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.clear();
        this.setEditUsernameAllowed(true);
    }

    @Test
    public void changeProfileWithoutRemoveCustomAttributes() throws Exception {
        this.setEditUsernameAllowed(false);
        this.setRegistrationEmailAsUsername(false);
        UserResource userResource = this.testRealm().users().get(this.userId);
        UserRepresentation user = userResource.toRepresentation();
        user.setAttributes(new HashMap());
        user.getAttributes().put("custom", Arrays.asList("custom-value"));
        userResource.update(user);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.expectAccount(EventType.UPDATE_PROFILE).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        user = userResource.toRepresentation();
        Assert.assertNotNull((Object)user.getAttributes());
        Assert.assertTrue((boolean)user.getAttributes().containsKey("custom"));
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.clear();
        this.setEditUsernameAllowed(true);
    }

    @Test
    public void changeProfileEmailChangeSetsEmailVerified() throws Exception {
        this.setEditUsernameAllowed(false);
        this.setRegistrationEmailAsUsername(false);
        UserResource userResource = this.testRealm().users().get(this.userId);
        UserRepresentation user = userResource.toRepresentation();
        user.setEmailVerified(Boolean.valueOf(true));
        userResource.update(user);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        this.profilePage.updateProfile(this.profilePage.getFirstName(), "New last", this.profilePage.getEmail());
        user = userResource.toRepresentation();
        Assert.assertTrue((boolean)user.isEmailVerified());
        this.events.expectAccount(EventType.UPDATE_PROFILE).detail("updated_last_name", "New last").detail("previous_last_name", "Brady").assertEvent();
        this.profilePage.updateProfile(this.profilePage.getFirstName(), this.profilePage.getLastName(), "new@email.com");
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        user = userResource.toRepresentation();
        Assert.assertFalse((boolean)user.isEmailVerified());
        this.events.expectAccount(EventType.UPDATE_PROFILE).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.clear();
        this.setEditUsernameAllowed(true);
    }

    @Test
    public void changeProfileEmailAsUsernameEnabled() throws Exception {
        this.setRegistrationEmailAsUsername(true);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertFalse((this.driver.findElements(By.id((String)"username")).size() > 0 ? 1 : 0) != 0);
        this.setRegistrationEmailAsUsername(false);
    }

    @Test
    public void changeProfileEmailAsUsernameAndEditUsernameEnabled() throws Exception {
        this.setEditUsernameAllowed(true);
        this.setRegistrationEmailAsUsername(true);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertFalse((this.driver.findElements(By.id((String)"username")).size() > 0 ? 1 : 0) != 0);
        this.profilePage.updateProfile("New First", "New Last", "new-email@email");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"New First", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New Last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new-email@email", (Object)this.profilePage.getEmail());
        List list = this.adminClient.realm(REALM_NAME).users().search(null, null, null, "new-email@email", null, null);
        Assert.assertEquals((long)1L, (long)list.size());
        UserRepresentation user = (UserRepresentation)list.get(0);
        Assert.assertEquals((Object)"new-email@email", (Object)user.getUsername());
        user.setUsername("test-user@localhost");
        user.setFirstName("Tom");
        user.setLastName("Brady");
        user.setEmail("test-user@localhost");
        this.adminClient.realm(REALM_NAME).users().get(user.getId()).update(user);
        this.setRegistrationEmailAsUsername(false);
        this.setEditUsernameAllowed(false);
    }

    private void setEditUsernameAllowed(boolean allowed) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setEditUsernameAllowed(Boolean.valueOf(allowed));
        this.testRealm().update(testRealm);
    }

    private void setRegistrationEmailAsUsername(boolean allowed) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setRegistrationEmailAsUsername(Boolean.valueOf(allowed));
        this.testRealm().update(testRealm);
    }

    private void setDuplicateEmailsAllowed(boolean allowed) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setDuplicateEmailsAllowed(Boolean.valueOf(allowed));
        this.testRealm().update(testRealm);
    }

    @Test
    public void changeUsername() {
        this.setEditUsernameAllowed(true);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Please specify username.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("test-user-no-access@localhost", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Username already exists.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"test-user-no-access@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("test-user-new@localhost", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"test-user-new@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("test-user@localhost", "Tom", "Brady", "test-user@localhost");
    }

    private void addUser(String username, String email) {
        UserRepresentation user = UserBuilder.create().username(username).enabled(true).email(email).firstName("first").lastName("last").build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void changeUsernameLoginWithOldUsername() {
        this.addUser("change-username", "change-username@localhost");
        this.setEditUsernameAllowed(true);
        this.profilePage.open();
        this.loginPage.login("change-username", "password");
        this.profilePage.updateUsername("change-username-updated");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        this.profilePage.logout();
        this.profilePage.open();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("change-username", "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.login("change-username-updated", "password");
    }

    @Test
    public void changeEmailLoginWithOldEmail() {
        this.addUser("change-email", "change-username@localhost");
        this.setEditUsernameAllowed(true);
        this.profilePage.open();
        this.loginPage.login("change-username@localhost", "password");
        this.profilePage.updateEmail("change-username-updated@localhost");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        this.profilePage.logout();
        this.profilePage.open();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("change-username@localhost", "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.login("change-username-updated@localhost", "password");
    }

    @Test
    public void changeEmailToExistingForbidden() {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("New first", "New last", "test-user-no-access@localhost");
        this.profilePage.assertCurrent();
        Assert.assertEquals((Object)"Email already exists.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user-no-access@localhost", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "test-user@localhost");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
    }

    @Test
    public void changeEmailToExistingAllowed() {
        this.setDuplicateEmailsAllowed(true);
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("New first", "New last", "test-user-no-access@localhost");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
    }

    public void totpPageSetup() {
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
    }

    public void totpPageSetupManual() {
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
    }

    @Test
    public void setupTotp() {
        this.totpPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=totp").assertEvent();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("Remove Google"));
        this.totpPageSetup();
        this.totpPage.clickManual();
        Assert.assertTrue((boolean)UIUtils.getTextFromElement((WebElement)this.driver.findElement(By.id((String)"kc-totp-secret-key"))).matches("[\\w]{4}( [\\w]{4}){7}"));
        Assert.assertEquals((Object)"Type: Time-based", (Object)this.driver.findElement(By.id((String)"kc-totp-type")).getText());
        Assert.assertEquals((Object)"Algorithm: SHA1", (Object)this.driver.findElement(By.id((String)"kc-totp-algorithm")).getText());
        Assert.assertEquals((Object)"Digits: 6", (Object)this.driver.findElement(By.id((String)"kc-totp-digits")).getText());
        Assert.assertEquals((Object)"Interval: 30", (Object)this.driver.findElement(By.id((String)"kc-totp-period")).getText());
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret() + "123"));
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.profilePage.getError());
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        Assert.assertEquals((Object)"Mobile authenticator configured.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_TOTP).assertEvent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("pficon-delete"));
        this.totpPage.removeTotp();
        this.events.expectAccount(EventType.REMOVE_TOTP).assertEvent();
        this.totpPageSetupManual();
        this.accountPage.logOut();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
    }

    @Test
    public void removeTotpAsDifferentUser() {
        UserResource user1 = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-one-configured-otp");
        CredentialRepresentation otpCredential = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        this.totpPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.totpPageSetup();
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        Assert.assertEquals((Object)"Mobile authenticator configured.", (Object)this.profilePage.getSuccess());
        String currentStateChecker = this.driver.findElement(By.id((String)"stateChecker")).getAttribute("value");
        String currentURL = this.driver.getCurrentUrl();
        String formParameters = "stateChecker=" + currentStateChecker + "&submitAction=Delete&credentialId=" + otpCredential.getId();
        URLUtils.sendPOSTRequestWithWebDriver((String)currentURL, (String)formParameters);
        Assert.assertTrue((boolean)user1.credentials().stream().anyMatch(credentialRepresentation -> credentialRepresentation.getType().equals("otp")));
        this.totpPage.removeTotp();
        this.totpPage.logout();
    }

    @Test
    public void changeProfileNoAccess() throws Exception {
        this.profilePage.open();
        this.loginPage.login("test-user-no-access@localhost", "password");
        UserRepresentation noAccessUser = this.findUser("test-user-no-access@localhost");
        this.events.expectLogin().client("account").user(noAccessUser.getId()).detail("username", "test-user-no-access@localhost").detail("redirect_uri", this.getAccountRedirectUrl()).assertEvent();
        Assert.assertTrue((String)("Expected errorPage but was " + this.driver.getTitle() + " (" + this.driver.getCurrentUrl() + "). Page source: " + this.driver.getPageSource()), (boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"No access", (Object)this.errorPage.getError());
    }

    private void setEventsEnabled(boolean eventsEnabled) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setEventsEnabled(eventsEnabled);
        this.testRealm().update(testRealm);
    }

    @Test
    public void viewLogNotEnabled() {
        this.logPage.open();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Page not found", (Object)this.errorPage.getError());
    }

    @Test
    public void viewLog() {
        this.setEventsEnabled(true);
        LinkedList<EventRepresentation> expectedEvents = new LinkedList<EventRepresentation>();
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("view", "log", "view-log@localhost", "view-log", "password", "password");
        expectedEvents.add(this.events.poll());
        expectedEvents.add(this.events.poll());
        this.profilePage.open();
        this.profilePage.updateProfile("view", "log2", "view-log@localhost");
        expectedEvents.add(this.events.poll());
        this.logPage.open();
        Assert.assertTrue((boolean)this.logPage.isCurrent());
        List actualEvents = this.logPage.getEvents();
        Assert.assertEquals((long)expectedEvents.size(), (long)actualEvents.size());
        for (EventRepresentation e : expectedEvents) {
            boolean match = false;
            for (List a : this.logPage.getEvents()) {
                if (!e.getType().toString().replace('_', ' ').toLowerCase().equals(a.get(1)) || !e.getIpAddress().equals(a.get(2)) || !e.getClientId().equals(a.get(3))) continue;
                match = true;
                break;
            }
            if (match) continue;
            Assert.fail((String)("Event not found " + e.getType()));
        }
        this.setEventsEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sessions() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("view", "sessions", "view-sessions@localhost", "view-sessions", "password", "password");
        EventRepresentation registerEvent = this.events.expectRegister("view-sessions", "view-sessions@localhost").assertEvent();
        String userId = registerEvent.getUserId();
        this.events.expectLogin().user(userId).detail("username", "view-sessions").assertEvent();
        this.sessionsPage.open();
        Assert.assertTrue((boolean)this.sessionsPage.isCurrent());
        List sessions = this.sessionsPage.getSessions();
        Assert.assertThat((Object)sessions, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((String)((List)sessions.get(0)).get(0)), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"127.0.0.1"), (Matcher)Matchers.equalTo((Object)"0:0:0:0:0:0:0:1")));
        try {
            OAuthClient oauth2 = new OAuthClient();
            oauth2.init(this.driver2);
            oauth2.doLogin("view-sessions", "password");
            EventRepresentation login2Event = this.events.expectLogin().user(userId).detail("username", "view-sessions").assertEvent();
            this.sessionsPage.open();
            sessions = this.sessionsPage.getSessions();
            Assert.assertEquals((long)2L, (long)sessions.size());
            this.sessionsPage.logoutAll();
            this.events.expectLogout(registerEvent.getSessionId());
            this.events.expectLogout(login2Event.getSessionId());
        }
        finally {
            this.driver2.close();
        }
    }

    @Test
    public void testConsoleListedInApplications() {
        this.applicationsPage.open();
        this.loginPage.login("realm-admin", "password");
        Assert.assertTrue((boolean)this.applicationsPage.isCurrent());
        Map apps = this.applicationsPage.getApplications();
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"Admin CLI", "Security Admin Console"}));
        this.events.clear();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void applicationsVisibilityNoScopesNoConsent() throws Exception {
        try (ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)REALM_NAME, (String)ROOT_URL_CLIENT).setConsentRequired(Boolean.valueOf(false)).setFullScopeAllowed(Boolean.valueOf(false)).setDefaultClientScopes(Collections.EMPTY_LIST).setOptionalClientScopes(Collections.EMPTY_LIST).update();
             RoleScopeUpdater rsu = (RoleScopeUpdater)cau.realmRoleScope().update();){
            this.applicationsPage.open();
            this.loginPage.login("john-doh@localhost", "password");
            this.applicationsPage.assertCurrent();
            Map apps = this.applicationsPage.getApplications();
            Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Account", "Account Console", "test-app", "test-app-scope", "third-party", "test-app-authz", "My Named Test App", "Test App Named - ${client_account}", "direct-grant", "custom-audience"}));
            rsu.add(this.testRealm().roles().get("user").toRepresentation()).update();
            this.driver.navigate().refresh();
            apps = this.applicationsPage.getApplications();
            Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ROOT_URL_CLIENT, "Account", "Account Console", "test-app", "test-app-scope", "third-party", "test-app-authz", "My Named Test App", "Test App Named - ${client_account}", "direct-grant", "custom-audience"}));
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void applicationsVisibilityNoScopesAndConsent() throws Exception {
        try (ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)REALM_NAME, (String)ROOT_URL_CLIENT).setConsentRequired(Boolean.valueOf(true)).setFullScopeAllowed(Boolean.valueOf(false)).setDefaultClientScopes(Collections.EMPTY_LIST).setOptionalClientScopes(Collections.EMPTY_LIST).update();){
            this.applicationsPage.open();
            this.loginPage.login("john-doh@localhost", "password");
            this.applicationsPage.assertCurrent();
            Map apps = this.applicationsPage.getApplications();
            Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ROOT_URL_CLIENT, "Account", "Account Console", "test-app", "test-app-scope", "third-party", "test-app-authz", "My Named Test App", "Test App Named - ${client_account}", "direct-grant", "custom-audience"}));
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void applications() {
        this.applicationsPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=applications").assertEvent();
        this.applicationsPage.assertCurrent();
        Map apps = this.applicationsPage.getApplications();
        Assert.assertThat(apps.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ROOT_URL_CLIENT, "Account", "Account Console", "test-app", "test-app-scope", "third-party", "test-app-authz", "My Named Test App", "Test App Named - ${client_account}", "direct-grant", "custom-audience"}));
        AccountApplicationsPage.AppEntry accountEntry = (AccountApplicationsPage.AppEntry)apps.get("Account");
        Assert.assertThat((Object)accountEntry.getRolesAvailable(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Manage account links in Account", "Manage account in Account", "View profile in Account", "Offline access"}));
        Assert.assertThat((Object)accountEntry.getClientScopesGranted(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Full Access"}));
        Assert.assertEquals((Object)(OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/"), (Object)accountEntry.getHref());
        AccountApplicationsPage.AppEntry testAppEntry = (AccountApplicationsPage.AppEntry)apps.get("test-app");
        Assert.assertEquals((long)6L, (long)testAppEntry.getRolesAvailable().size());
        Assert.assertTrue((boolean)testAppEntry.getRolesAvailable().contains("Offline access"));
        Assert.assertTrue((boolean)testAppEntry.getClientScopesGranted().contains("Full Access"));
        Assert.assertEquals((Object)OAuthClient.APP_AUTH_ROOT, (Object)testAppEntry.getHref());
        AccountApplicationsPage.AppEntry thirdPartyEntry = (AccountApplicationsPage.AppEntry)apps.get("third-party");
        Assert.assertEquals((long)3L, (long)thirdPartyEntry.getRolesAvailable().size());
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesAvailable().contains("Have User privileges"));
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesAvailable().contains("Have Customer User privileges in test-app"));
        Assert.assertEquals((long)0L, (long)thirdPartyEntry.getClientScopesGranted().size());
        Assert.assertEquals((Object)"http://localhost:8180/auth/realms/master/app/auth", (Object)thirdPartyEntry.getHref());
        AccountApplicationsPage.AppEntry testAppNamed = (AccountApplicationsPage.AppEntry)apps.get("Test App Named - ${client_account}");
        Assert.assertEquals((Object)"http://localhost:8180/varnamedapp/base", (Object)testAppNamed.getHref());
        AccountApplicationsPage.AppEntry rootUrlClient = (AccountApplicationsPage.AppEntry)apps.get(ROOT_URL_CLIENT);
        Assert.assertEquals((Object)"http://localhost:8180/foo/bar/baz", (Object)rootUrlClient.getHref());
        AccountApplicationsPage.AppEntry authzApp = (AccountApplicationsPage.AppEntry)apps.get("test-app-authz");
        Assert.assertEquals((Object)(OAuthClient.SERVER_ROOT + "/test-app-authz"), (Object)authzApp.getHref());
        AccountApplicationsPage.AppEntry namedApp = (AccountApplicationsPage.AppEntry)apps.get("My Named Test App");
        Assert.assertEquals((Object)"http://localhost:8180/namedapp/base", (Object)namedApp.getHref());
        AccountApplicationsPage.AppEntry testAppScope = (AccountApplicationsPage.AppEntry)apps.get("test-app-scope");
        Assert.assertNull((Object)testAppScope.getHref());
    }

    @Test
    public void loginToSpecificPage() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.changePasswordPage.isCurrent());
        this.events.clear();
    }

    @Test
    public void loginToSpecificPageWithReferrer() {
        this.driver.navigate().to(this.changePasswordPage.getPath() + "?referrer=account");
        System.out.println(this.driver.getCurrentUrl());
        this.loginPage.login("test-user@localhost", "password");
        System.out.println(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)this.changePasswordPage.isCurrent());
        this.events.clear();
    }

    @Test
    public void testIdentityProviderCapitalization() {
        this.loginPage.open();
        Assert.assertEquals((Object)"GitHub", (Object)this.loginPage.findSocialButton("github").getText());
        Assert.assertEquals((Object)"mysaml", (Object)this.loginPage.findSocialButton("mysaml").getText());
        Assert.assertEquals((Object)"MyOIDC", (Object)this.loginPage.findSocialButton("myoidc").getText());
    }

    @Test
    public void testIdentityProviderHiddenOnLoginPageIsVisbleInAccount() {
        this.federatedIdentityPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertNotNull((Object)this.federatedIdentityPage.findAddProvider("myhiddenoidc"));
    }

    @Test
    public void testInvalidReferrer() {
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app");
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-invalid&referrer_uri=http://localhost:8180/auth/realms/master/app/auth?test");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.events.clear();
    }

    @Test
    public void testReferrerLinkContents() {
        RealmResource testRealm = this.testRealm();
        List foundClients = testRealm.clients().findByClientId("named-test-app");
        if (foundClients.isEmpty()) {
            Assert.fail((String)"Unable to find named-test-app");
        }
        ClientRepresentation namedClient = (ClientRepresentation)foundClients.get(0);
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=" + namedClient.getClientId());
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        Assert.assertEquals((Object)("Back to " + namedClient.getName()), (Object)this.profilePage.getBackToApplicationLinkText());
        Assert.assertEquals((Object)namedClient.getBaseUrl(), (Object)this.profilePage.getBackToApplicationLinkHref());
        foundClients = testRealm.clients().findByClientId("var-named-test-app");
        if (foundClients.isEmpty()) {
            Assert.fail((String)"Unable to find var-named-test-app");
        }
        namedClient = (ClientRepresentation)foundClients.get(0);
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=" + namedClient.getClientId());
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        Assert.assertEquals((Object)"Back to Test App Named - Account", (Object)this.profilePage.getBackToApplicationLinkText());
        Assert.assertEquals((Object)namedClient.getBaseUrl(), (Object)this.profilePage.getBackToApplicationLinkHref());
        foundClients = testRealm.clients().findByClientId("test-app");
        if (foundClients.isEmpty()) {
            Assert.fail((String)"Unable to find test-app");
        }
        ClientRepresentation namelessClient = (ClientRepresentation)foundClients.get(0);
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=" + namelessClient.getClientId());
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        Assert.assertEquals((Object)("Back to " + namelessClient.getClientId()), (Object)this.profilePage.getBackToApplicationLinkText());
        Assert.assertEquals((Object)namelessClient.getBaseUrl(), (Object)this.profilePage.getBackToApplicationLinkHref());
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-invalid");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        Assert.assertNull((Object)this.profilePage.getBackToApplicationLinkText());
        this.events.clear();
    }

    @Test
    public void testNoPublicKeyCredentialRelatedElementsPresentOnEditAccountScreen() {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        int noSuchElementExceptionCount = 0;
        for (String pkcElementId : Arrays.asList("user.attributes.public_key_credential_id", "user.attributes.public_key_credential_label", "user.attributes.public_key_credential_aaguid")) {
            try {
                DroneUtils.getCurrentDriver().findElement(By.id((String)pkcElementId));
            }
            catch (NoSuchElementException nsee) {
                ++noSuchElementExceptionCount;
            }
        }
        Assert.assertEquals((long)3L, (long)noSuchElementExceptionCount);
    }
}

