/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.pages.AccountFederatedIdentityPage;
import org.keycloak.testsuite.util.UserBuilder;

public class AccountBrokerTest
extends AbstractBaseBrokerTest {
    @Page
    protected AccountFederatedIdentityPage identityPage;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.bc.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.bc.getUserLogin());
        user.setEmail(this.bc.getUserEmail());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.bc.providerRealmName());
        this.userId = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)user);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(this.userId), (String)this.bc.getUserPassword(), (boolean)false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        realm.identityProviders().create(this.bc.setUpIdentityProvider()).close();
        realm.identityProviders().get(this.bc.getIDPAlias());
    }

    @Before
    public void addClients() {
        List<ClientRepresentation> clients = this.bc.createProviderClients();
        if (clients != null) {
            RealmResource providerRealm = this.adminClient.realm(this.bc.providerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.bc.providerRealmName()));
                this.fixAuthServerHostAndPortForClientRepresentation(client);
                providerRealm.clients().create(client).close();
            }
        }
        if ((clients = this.bc.createConsumerClients()) != null) {
            RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.bc.consumerRealmName()));
                this.fixAuthServerHostAndPortForClientRepresentation(client);
                consumerRealm.clients().create(client).close();
            }
        }
    }

    @Before
    public void before() {
        Response response = this.adminClient.realm(KcOidcBrokerConfiguration.INSTANCE.consumerRealmName()).users().create(UserBuilder.create().username("accountbrokertest").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        ApiUtil.resetUserPassword((UserResource)this.adminClient.realm(KcOidcBrokerConfiguration.INSTANCE.consumerRealmName()).users().get(userId), (String)"password", (boolean)false);
    }

    @After
    public void after() {
        RealmResource consumerRealm = this.adminClient.realm(KcOidcBrokerConfiguration.INSTANCE.consumerRealmName());
        UserRepresentation userRep = ApiUtil.findUserByUsername((RealmResource)consumerRealm, (String)"accountbrokertest");
        if (userRep != null) {
            consumerRealm.users().get(userRep.getId()).remove();
        }
    }

    @Test
    public void add() {
        this.identityPage.realm(KcOidcBrokerConfiguration.INSTANCE.consumerRealmName());
        this.identityPage.open();
        this.loginPage.login("accountbrokertest", "password");
        Assert.assertTrue((boolean)this.identityPage.isCurrent());
        List identities = this.identityPage.getIdentities();
        Assert.assertEquals((long)1L, (long)identities.size());
        Assert.assertEquals((Object)"kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getProvider());
        Assert.assertEquals((Object)"", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getSubject());
        Assert.assertEquals((Object)"add-link-kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getAction().getAttribute("id"));
        ((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getAction().click();
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        Assert.assertTrue((boolean)this.identityPage.isCurrent());
        identities = this.identityPage.getIdentities();
        Assert.assertEquals((long)1L, (long)identities.size());
        Assert.assertEquals((Object)"kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getProvider());
        Assert.assertEquals((Object)"testuser", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getSubject());
        Assert.assertEquals((Object)"remove-link-kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getAction().getAttribute("id"));
        ((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getAction().click();
        Assert.assertTrue((boolean)this.identityPage.isCurrent());
        identities = this.identityPage.getIdentities();
        Assert.assertEquals((Object)"kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getProvider());
        Assert.assertEquals((Object)"", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getSubject());
        Assert.assertEquals((Object)"add-link-kc-oidc-idp", (Object)((AccountFederatedIdentityPage.FederatedIdentity)identities.get(0)).getAction().getAttribute("id"));
    }

    @Test
    public void displayEnabledIdentityProviders() {
        this.identityPage.realm(KcOidcBrokerConfiguration.INSTANCE.consumerRealmName());
        this.identityPage.open();
        this.loginPage.login("accountbrokertest", "password");
        Assert.assertTrue((boolean)this.identityPage.isCurrent());
        List identities = this.identityPage.getIdentities();
        Assert.assertEquals((long)1L, (long)identities.size());
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderResource providerResource = realm.identityProviders().get(this.bc.getIDPAlias());
        IdentityProviderRepresentation provider = providerResource.toRepresentation();
        provider.setEnabled(false);
        providerResource.update(provider);
        this.identityPage.open();
        Assert.assertTrue((boolean)this.identityPage.isCurrent());
        identities = this.identityPage.getIdentities();
        Assert.assertEquals((long)0L, (long)identities.size());
    }
}

