/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class Assert
extends org.junit.Assert {
    public static final Long DEFAULT_NUMBER_DEVIATION = 20L;

    public static <T> void assertNames(Set<T> actual, String ... expected) {
        Arrays.sort(expected);
        Object[] actualNames = Assert.names(new LinkedList<T>(actual));
        Assert.assertArrayEquals((String)("Expected: " + Arrays.toString(expected) + ", was: " + Arrays.toString(actualNames)), (Object[])expected, (Object[])actualNames);
    }

    public static <T> void assertNames(List<T> actual, String ... expected) {
        Arrays.sort(expected);
        Object[] actualNames = Assert.names(actual);
        Assert.assertArrayEquals((String)("Expected: " + Arrays.toString(expected) + ", was: " + Arrays.toString(actualNames)), (Object[])expected, (Object[])actualNames);
    }

    private static <T> String[] names(List<T> list) {
        Object[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = Assert.name(list.get(i));
        }
        Arrays.sort(names);
        return names;
    }

    private static String name(Object o1) {
        if (o1 instanceof String) {
            return (String)o1;
        }
        if (o1 instanceof RealmRepresentation) {
            return ((RealmRepresentation)o1).getRealm();
        }
        if (o1 instanceof ClientRepresentation) {
            return ((ClientRepresentation)o1).getClientId();
        }
        if (o1 instanceof IdentityProviderRepresentation) {
            return ((IdentityProviderRepresentation)o1).getAlias();
        }
        if (o1 instanceof RoleRepresentation) {
            return ((RoleRepresentation)o1).getName();
        }
        if (o1 instanceof UserRepresentation) {
            return ((UserRepresentation)o1).getUsername();
        }
        if (o1 instanceof UserFederationProviderFactoryRepresentation) {
            return ((UserFederationProviderFactoryRepresentation)o1).getId();
        }
        if (o1 instanceof GroupRepresentation) {
            return ((GroupRepresentation)o1).getName();
        }
        if (o1 instanceof ComponentRepresentation) {
            return ((ComponentRepresentation)o1).getName();
        }
        if (o1 instanceof ClientScopeRepresentation) {
            return ((ClientScopeRepresentation)o1).getName();
        }
        throw new IllegalArgumentException();
    }

    public static void assertMap(Map<String, String> config, String ... expected) {
        if (expected == null) {
            expected = new String[]{};
        }
        Assert.assertEquals((long)(config.size() * 2), (long)expected.length);
        for (int i = 0; i < expected.length; i += 2) {
            String key = expected[i];
            String value = expected[i + 1];
            Assert.assertEquals((Object)value, (Object)config.get(key));
        }
    }

    public static void assertMultivaluedMap(MultivaluedHashMap<String, String> config, String ... expected) {
        if (expected == null) {
            expected = new String[]{};
        }
        for (int i = 0; i < expected.length; i += 2) {
            String key = expected[i];
            String value = expected[i + 1];
            Assert.assertEquals((Object)value, (Object)config.getFirst((Object)key));
        }
    }

    public static void assertProviderConfigProperty(ConfigPropertyRepresentation property, String name, String label, String defaultValue, String helpText, String type) {
        Assert.assertEquals((Object)name, (Object)property.getName());
        Assert.assertEquals((Object)label, (Object)property.getLabel());
        Assert.assertEquals((Object)defaultValue, (Object)property.getDefaultValue());
        Assert.assertEquals((Object)helpText, (Object)property.getHelpText());
        Assert.assertEquals((Object)type, (Object)property.getType());
    }

    public static void assertExpiration(int actual, int expected) {
        Assert.assertExpiration((long)actual, (long)expected);
    }

    public static void assertExpiration(long actual, long expected) {
        Assert.assertExpiration(actual, expected, DEFAULT_NUMBER_DEVIATION);
    }

    public static void assertExpiration(long actual, long expected, long deviation) {
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(expected - deviation)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(expected + deviation))));
    }

    public static void assertRoleAttributes(Map<String, List<String>> expected, Map<String, List<String>> actual) {
        MatcherAssert.assertThat(actual.keySet(), (Matcher)Matchers.equalTo(expected.keySet()));
        for (String expectedKey : expected.keySet()) {
            MatcherAssert.assertThat((Object)actual.get(expectedKey).size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.get(expectedKey).size())));
            MatcherAssert.assertThat(actual.get(expectedKey), (Matcher)Matchers.containsInAnyOrder((Object[])expected.get(expectedKey).toArray()));
        }
    }
}

