/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.lang.reflect.Field;
import java.util.List;
import org.junit.After;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.OAuthClient;

public abstract class AbstractTestRealmKeycloakTest
extends AbstractKeycloakTest {
    public static final String TEST_REALM_NAME = "test";

    protected RealmResource testRealm() {
        return this.adminClient.realm(TEST_REALM_NAME);
    }

    protected UserRepresentation findUser(String userNameOrEmail) {
        List repList = this.testRealm().users().search(userNameOrEmail, Integer.valueOf(-1), Integer.valueOf(-1));
        if (repList.size() != 1) {
            throw new IllegalStateException("User search expected one result. Found " + repList.size() + " users.");
        }
        return (UserRepresentation)repList.get(0);
    }

    protected void updateUser(UserRepresentation user) {
        this.testRealm().users().get(user.getId()).update(user);
    }

    protected ClientRepresentation findTestApp(RealmRepresentation testRealm) {
        for (ClientRepresentation client : testRealm.getClients()) {
            if (!client.getClientId().equals("test-app")) continue;
            return client;
        }
        return null;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"Adding test realm for import from testrealm.json");
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(testRealm);
        this.configureTestRealm(testRealm);
    }

    @After
    public void deleteCookies() {
        this.deleteAllCookiesForRealm(TEST_REALM_NAME);
    }

    public abstract void configureTestRealm(RealmRepresentation var1);

    protected IDToken sendTokenRequestAndGetIDToken(EventRepresentation loginEvent) {
        OAuthClient.AccessTokenResponse response = this.sendTokenRequestAndGetResponse(loginEvent);
        return this.oauth.verifyIDToken(response.getIdToken());
    }

    protected OAuthClient.AccessTokenResponse sendTokenRequestAndGetResponse(EventRepresentation loginEvent) {
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Field eventsField = Reflections.findDeclaredField(this.getClass(), (String)"events");
        if (eventsField != null) {
            AssertEvents events = (AssertEvents)Reflections.getFieldValue((Field)eventsField, (Object)this, AssertEvents.class);
            events.expectCodeToToken(codeId, sessionId).assertEvent();
        }
        return response;
    }

    public static KeycloakSession inheritClientConnection(KeycloakSession parentSession, KeycloakSession currentSession) {
        Resteasy.pushContext(ClientConnection.class, (Object)parentSession.getContext().getConnection());
        return currentSession;
    }
}

