/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.model.TestTimedOutException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.KcArquillian;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.AuthServer;
import org.keycloak.testsuite.auth.page.AuthServerContextRoot;
import org.keycloak.testsuite.auth.page.WelcomePage;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.UpdatePassword;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TestCleanup;
import org.keycloak.testsuite.util.TestEventsLogger;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.WebDriver;

@RunWith(value=KcArquillian.class)
@RunAsClient
public abstract class AbstractKeycloakTest {
    protected static final String ENGLISH_LOCALE_NAME = "English";
    protected Logger log = Logger.getLogger(this.getClass());
    @ArquillianResource
    protected SuiteContext suiteContext;
    @ArquillianResource
    protected TestContext testContext;
    protected Keycloak adminClient;
    protected KeycloakTestingClient testingClient;
    @ArquillianResource
    protected OAuthClient oauth;
    protected List<RealmRepresentation> testRealmReps;
    @Drone
    protected WebDriver driver;
    @Page
    protected AuthServerContextRoot authServerContextRootPage;
    @Page
    protected AuthServer authServerPage;
    @Page
    protected AuthRealm masterRealmPage;
    @Page
    protected Account accountPage;
    @Page
    protected OIDCLogin loginPage;
    @Page
    protected UpdatePassword updatePasswordPage;
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;
    @Page
    protected WelcomePage welcomePage;
    private PropertiesConfiguration constantsProperties;
    private boolean resetTimeOffset;

    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        this.adminClient = this.testContext.getAdminClient();
        if (this.adminClient == null || this.adminClient.isClosed()) {
            this.reconnectAdminClient();
        }
        this.getTestingClient();
        this.setDefaultPageUriParameters();
        TestEventsLogger.setDriver(this.driver);
        if (!AuthServerTestEnricher.AUTH_SERVER_CLUSTER) {
            this.updateMasterAdminPassword();
        }
        this.beforeAbstractKeycloakTestRealmImport();
        if (this.testContext.getTestRealmReps().isEmpty()) {
            this.importTestRealms();
            if (!this.isImportAfterEachMethod()) {
                this.testContext.setTestRealmReps(this.testRealmReps);
            }
            this.afterAbstractKeycloakTestRealmImport();
        }
        this.oauth.init(this.driver);
    }

    public void reconnectAdminClient() throws Exception {
        this.testContext.reconnectAdminClient();
        this.adminClient = this.testContext.getAdminClient();
    }

    protected void beforeAbstractKeycloakTestRealmImport() throws Exception {
    }

    protected void postAfterAbstractKeycloak() throws Exception {
    }

    protected void afterAbstractKeycloakTestRealmImport() {
    }

    @After
    public void afterAbstractKeycloakTest() throws Exception {
        if (this.resetTimeOffset) {
            this.resetTimeOffset();
        }
        if (this.isImportAfterEachMethod()) {
            this.log.info((Object)"removing test realms after test method");
            for (RealmRepresentation testRealm : this.testRealmReps) {
                this.removeRealm(testRealm.getRealm());
            }
        } else {
            this.log.info((Object)"calling all TestCleanup");
            this.testContext.getTestRealmReps().stream().forEach(r -> this.testingClient.testing().removeUserSessions(r.getRealm()));
            for (TestCleanup cleanup : this.testContext.getCleanups().values()) {
                try {
                    if (cleanup == null) continue;
                    cleanup.executeCleanup();
                }
                catch (Exception e) {
                    this.log.error((Object)"failed cleanup!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            this.testContext.getCleanups().clear();
        }
        this.postAfterAbstractKeycloak();
        DroneUtils.resetQueue();
    }

    protected TestCleanup getCleanup(String realmName) {
        return this.testContext.getOrCreateCleanup(realmName);
    }

    protected TestCleanup getCleanup() {
        return this.getCleanup("test");
    }

    protected boolean isImportAfterEachMethod() {
        return false;
    }

    protected void updateMasterAdminPassword() {
        if (!this.suiteContext.isAdminPasswordUpdated()) {
            this.log.debug((Object)"updating admin password");
            this.welcomePage.navigateTo();
            if (!this.welcomePage.isPasswordSet()) {
                this.welcomePage.setPassword("admin", "admin");
            }
            this.suiteContext.setAdminPasswordUpdated(true);
        }
    }

    public void deleteAllCookiesForMasterRealm() {
        this.deleteAllCookiesForRealm("master");
    }

    protected void deleteAllCookiesForRealm(String realmName) {
        URLUtils.navigateToUri((String)(this.accountPage.getAuthRoot() + "/realms/" + realmName + "/super-random-page"));
        this.log.info((Object)("deleting cookies in '" + realmName + "' realm"));
        this.driver.manage().deleteAllCookies();
    }

    protected void deleteAllSessionsInRealm(String realmName) {
        this.log.info((Object)("removing all sessions from '" + realmName + "' realm..."));
        try {
            this.adminClient.realm(realmName).logoutAll();
            this.log.info((Object)"sessions successfully deleted");
        }
        catch (NotFoundException e) {
            this.log.warn((Object)"realm not found");
        }
    }

    protected void resetRealmSession(String realmName) {
        this.deleteAllCookiesForRealm(realmName);
        if (this.driver instanceof AppiumDriver) {
            try {
                this.log.info((Object)"resetting realm session");
                RealmRepresentation realmRep = this.adminClient.realm(realmName).toRepresentation();
                this.deleteAllSessionsInRealm(realmName);
                if (realmRep.isInternationalizationEnabled().booleanValue()) {
                    String locale = this.getDefaultLocaleName(realmRep.getRealm());
                    this.loginPage.localeDropdown().selectByText(locale);
                    this.log.info((Object)("locale reset to " + locale));
                }
            }
            catch (NotFoundException e) {
                this.log.warn((Object)"realm not found");
            }
        }
    }

    protected String getDefaultLocaleName(String realmName) {
        return ENGLISH_LOCALE_NAME;
    }

    public void setDefaultPageUriParameters() {
        this.masterRealmPage.setAuthRealm("master");
        this.loginPage.setAuthRealm("master");
    }

    public KeycloakTestingClient getTestingClient() {
        if (this.testingClient == null) {
            this.testingClient = this.testContext.getTestingClient();
        }
        return this.testingClient;
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public Keycloak getAdminClient() {
        return this.adminClient;
    }

    public abstract void addTestRealms(List<RealmRepresentation> var1);

    private void addTestRealms() {
        this.log.debug((Object)"loading test realms");
        if (this.testRealmReps == null) {
            this.testRealmReps = new ArrayList<RealmRepresentation>();
        }
        if (this.testRealmReps.isEmpty()) {
            this.addTestRealms(this.testRealmReps);
        }
    }

    public void fixAuthServerHostAndPortForClientRepresentation(ClientRepresentation cr) {
        cr.setBaseUrl(ServerURLs.removeDefaultPorts((String)this.replaceAuthHostWithRealHost(cr.getBaseUrl())));
        cr.setAdminUrl(ServerURLs.removeDefaultPorts((String)this.replaceAuthHostWithRealHost(cr.getAdminUrl())));
        if (cr.getRedirectUris() != null && !cr.getRedirectUris().isEmpty()) {
            ArrayList<String> fixedUrls = new ArrayList<String>(cr.getRedirectUris().size());
            for (String url : cr.getRedirectUris()) {
                fixedUrls.add(ServerURLs.removeDefaultPorts((String)this.replaceAuthHostWithRealHost(url)));
            }
            cr.setRedirectUris(fixedUrls);
        }
    }

    public String replaceAuthHostWithRealHost(String url) {
        if (url != null && (url.contains("localhost:8180") || url.contains("localhost:8543"))) {
            return url.replaceFirst("localhost:(\\d)+", ServerURLs.AUTH_SERVER_HOST + ":" + ServerURLs.AUTH_SERVER_PORT);
        }
        return url;
    }

    public void importTestRealms() {
        this.addTestRealms();
        this.log.info((Object)"importing test realms");
        for (RealmRepresentation testRealm : this.testRealmReps) {
            this.importRealm(testRealm);
        }
    }

    private void modifySamlAttributes(ClientRepresentation cr) {
        if (cr.getProtocol() != null && cr.getProtocol().equals("saml")) {
            this.log.debug((Object)("Modifying attributes of SAML client: " + cr.getClientId()));
            for (Map.Entry entry : cr.getAttributes().entrySet()) {
                cr.getAttributes().put((String)entry.getKey(), this.replaceHttpValuesWithHttps((String)entry.getValue()));
            }
        }
    }

    private void modifyRedirectUrls(ClientRepresentation cr) {
        if (cr.getRedirectUris() != null && cr.getRedirectUris().size() > 0) {
            List redirectUrls = cr.getRedirectUris();
            ArrayList<String> fixedRedirectUrls = new ArrayList<String>(redirectUrls.size());
            for (String url : redirectUrls) {
                fixedRedirectUrls.add(this.replaceHttpValuesWithHttps(url));
            }
            cr.setRedirectUris(fixedRedirectUrls);
        }
    }

    private void modifyMainUrls(ClientRepresentation cr) {
        cr.setBaseUrl(this.replaceHttpValuesWithHttps(cr.getBaseUrl()));
        cr.setAdminUrl(this.replaceHttpValuesWithHttps(cr.getAdminUrl()));
    }

    private String replaceHttpValuesWithHttps(String input) {
        if (input == null) {
            return null;
        }
        if ("".equals(input)) {
            return "";
        }
        return input.replace("http", "https").replace("8080", "8543").replace("8180", "8543");
    }

    protected void runTestWithTimeout(long timeout, final ExecutableTestMethod executableTestMethod) throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                executableTestMethod.execute();
                return null;
            }
        };
        Future<Object> result = service.submit(callable);
        service.shutdown();
        try {
            boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                service.shutdownNow();
            }
            result.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new TestTimedOutException(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected boolean modifyRealmForSSL() {
        return false;
    }

    protected void removeAllRealmsDespiteMaster() {
        this.adminClient.realms().findAll().stream().map(RealmRepresentation::getRealm).filter(realmName -> !realmName.equals("master")).forEach(this::removeRealm);
        Assert.assertThat((Object)this.adminClient.realms().findAll().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    public void importRealm(RealmRepresentation realm) {
        if (this.modifyRealmForSSL() && ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            this.log.debugf("Modifying %s for SSL", (Object)realm.getId());
            for (ClientRepresentation cr : realm.getClients()) {
                this.modifyMainUrls(cr);
                this.modifyRedirectUrls(cr);
                this.modifySamlAttributes(cr);
            }
        }
        if (!ServerURLs.AUTH_SERVER_HOST.equals("localhost")) {
            if (!ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
                realm.setSslRequired("none");
            }
            if (realm.getClients() != null) {
                for (ClientRepresentation cr : realm.getClients()) {
                    this.fixAuthServerHostAndPortForClientRepresentation(cr);
                }
            }
            if (realm.getApplications() != null) {
                for (ClientRepresentation cr : realm.getApplications()) {
                    this.fixAuthServerHostAndPortForClientRepresentation(cr);
                }
            }
        }
        this.log.debug((Object)("--importing realm: " + realm.getRealm()));
        try {
            this.adminClient.realms().realm(realm.getRealm()).remove();
            this.log.debug((Object)"realm already existed on server, re-importing");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.adminClient.realms().create(realm);
    }

    public void removeRealm(String realmName) {
        this.log.info((Object)("removing realm: " + realmName));
        try {
            this.adminClient.realms().realm(realmName).remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RealmsResource realmsResouce() {
        return this.adminClient.realms();
    }

    public String createUser(String realm, String username, String password, String ... requiredActions) {
        UserRepresentation homer = AbstractKeycloakTest.createUserRepresentation(username, password);
        homer.setRequiredActions(Arrays.asList(requiredActions));
        return ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm(realm), (UserRepresentation)homer);
    }

    public String createUser(String realm, String username, String password, String firstName, String lastName, String email, Consumer<UserRepresentation> customizer) {
        UserRepresentation user = AbstractKeycloakTest.createUserRepresentation(username, email, firstName, lastName, true, password);
        customizer.accept(user);
        return ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm(realm), (UserRepresentation)user);
    }

    public String createUser(String realm, String username, String password, String firstName, String lastName, String email) {
        UserRepresentation homer = AbstractKeycloakTest.createUserRepresentation(username, email, firstName, lastName, true, password);
        return ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm(realm), (UserRepresentation)homer);
    }

    public static UserRepresentation createUserRepresentation(String username, String email, String firstName, String lastName, List<String> groups, boolean enabled) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setGroups(groups);
        user.setEnabled(Boolean.valueOf(enabled));
        return user;
    }

    public static UserRepresentation createUserRepresentation(String username, String email, String firstName, String lastName, boolean enabled) {
        return AbstractKeycloakTest.createUserRepresentation(username, email, firstName, lastName, null, enabled);
    }

    public static UserRepresentation createUserRepresentation(String username, String email, String firstName, String lastName, boolean enabled, String password) {
        UserRepresentation user = AbstractKeycloakTest.createUserRepresentation(username, email, firstName, lastName, enabled);
        Users.setPasswordFor((UserRepresentation)user, (String)password);
        return user;
    }

    public static UserRepresentation createUserRepresentation(String username, String password) {
        UserRepresentation user = AbstractKeycloakTest.createUserRepresentation(username, null, null, null, true, password);
        return user;
    }

    public void setRequiredActionEnabled(String realm, String requiredAction, boolean enabled, boolean defaultAction) {
        AuthenticationManagementResource managementResource = this.adminClient.realm(realm).flows();
        RequiredActionProviderRepresentation action = managementResource.getRequiredAction(requiredAction);
        action.setEnabled(enabled);
        action.setDefaultAction(defaultAction);
        managementResource.updateRequiredAction(requiredAction, action);
    }

    public void setRequiredActionEnabled(String realm, String userId, String requiredAction, boolean enabled) {
        UsersResource usersResource = this.adminClient.realm(realm).users();
        UserResource userResource = usersResource.get(userId);
        UserRepresentation userRepresentation = userResource.toRepresentation();
        List requiredActions = userRepresentation.getRequiredActions();
        if (enabled && !requiredActions.contains(requiredAction)) {
            requiredActions.add(requiredAction);
        } else if (!enabled && requiredActions.contains(requiredAction)) {
            requiredActions.remove(requiredAction);
        }
        userResource.update(userRepresentation);
    }

    public void setTimeOfDay(int hour, int minute, int second) {
        this.setTimeOfDay(hour, minute, second, 0);
    }

    public void setTimeOfDay(int hour, int minute, int second, int addSeconds) {
        Calendar now = Calendar.getInstance();
        now.set(11, hour);
        now.set(12, minute);
        now.set(13, second);
        int offset = (int)((now.getTime().getTime() - System.currentTimeMillis()) / 1000L);
        this.setTimeOffset(offset + addSeconds);
    }

    public void setTimeOffset(int offset) {
        String response = this.invokeTimeOffset(offset);
        this.resetTimeOffset = offset != 0;
        this.log.debugv("Set time offset, response {0}", (Object)response);
    }

    public void resetTimeOffset() {
        String response = this.invokeTimeOffset(0);
        this.resetTimeOffset = false;
        this.log.debugv("Reset time offset, response {0}", (Object)response);
    }

    public int getCurrentTime() {
        return Time.currentTime();
    }

    protected String invokeTimeOffset(int offset) {
        Time.setOffset((int)offset);
        Map result = this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(offset)));
        return String.valueOf(result);
    }

    private void loadConstantsProperties() throws ConfigurationException {
        this.constantsProperties = new PropertiesConfiguration(System.getProperty("testsuite.constants"));
        this.constantsProperties.setThrowExceptionOnMissing(true);
    }

    protected PropertiesConfiguration getConstantsProperties() throws ConfigurationException {
        if (this.constantsProperties == null) {
            this.loadConstantsProperties();
        }
        return this.constantsProperties;
    }

    public URI getAuthServerRoot() {
        try {
            return KeycloakUriBuilder.fromUri((URI)this.suiteContext.getAuthServerInfo().getContextRoot().toURI()).path("/auth/").build(new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Logger getLogger() {
        return this.log;
    }

    protected String getAccountRedirectUrl(String realm) {
        return AccountFormService.loginRedirectUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{realm}).toString();
    }

    protected String getAccountRedirectUrl() {
        return this.getAccountRedirectUrl("test");
    }

    protected static InputStream httpsAwareConfigurationStream(InputStream input) throws IOException {
        if (!ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            return input;
        }
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        try (PrintWriter pw = new PrintWriter(out);
             Scanner s = new Scanner(input);){
            while (s.hasNextLine()) {
                String lineWithReplaces = s.nextLine().replace("http://localhost:8180/auth", ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + ServerURLs.AUTH_SERVER_PORT + "/auth");
                pw.println(lineWithReplaces);
            }
        }
        return in;
    }

    protected String getProjectName() {
        boolean isProduct = this.adminClient.serverInfo().getInfo().getProfileInfo().getName().equals("product");
        return isProduct ? Profile.PRODUCT_NAME : Profile.PROJECT_NAME;
    }

    protected static interface ExecutableTestMethod {
        public void execute() throws Exception;
    }
}

