/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet(value={"/SessionServlet"})
public class SessionServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String counterWrapperValue;
        String counter;
        if (req.getRequestURI().endsWith("/logout")) {
            req.logout();
            return;
        }
        if (req.getRequestURI().endsWith("/donotincrease")) {
            counter = this.getCounter(req);
            counterWrapperValue = this.getCounterWrapper(req);
        } else {
            counter = this.increaseAndGetCounter(req);
            counterWrapperValue = this.increaseAndGetCounterWrapper(req);
        }
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.printf("<html><head><title>%s</title></head><body>", "Session Test");
        pw.printf("Counter=%s<br>", counter);
        pw.printf("CounterWrapper=%s<br>", counterWrapperValue);
        pw.printf("Node name=%s<br>", System.getProperty("jboss.node.name", "property not specified"));
        pw.print("</body></html>");
        pw.flush();
    }

    private String getCounter(HttpServletRequest req) {
        HttpSession session = req.getSession();
        return String.valueOf(session.getAttribute("counter"));
    }

    private String increaseAndGetCounter(HttpServletRequest req) {
        HttpSession session = req.getSession();
        Integer counter = (Integer)session.getAttribute("counter");
        counter = counter == null ? 1 : counter + 1;
        session.setAttribute("counter", (Object)counter);
        return String.valueOf(counter);
    }

    private String getCounterWrapper(HttpServletRequest req) {
        HttpSession session = req.getSession();
        return String.valueOf(session.getAttribute("counterWrapper"));
    }

    private String increaseAndGetCounterWrapper(HttpServletRequest req) {
        HttpSession session = req.getSession();
        CounterWrapper counter = (CounterWrapper)session.getAttribute("counterWrapper");
        counter = counter == null ? new CounterWrapper() : counter.increase();
        session.setAttribute("counterWrapper", (Object)counter);
        return String.valueOf(counter);
    }

    public static class CounterWrapper
    implements Serializable {
        private int counter = 1;

        public String toString() {
            return String.valueOf(this.counter);
        }

        public CounterWrapper increase() {
            ++this.counter;
            return this;
        }
    }
}

