/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PrintWriter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

@WebServlet(value={"/serialization-servlet"})
public class SerializationServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        KeycloakPrincipal principal;
        PrintWriter pw = resp.getWriter();
        ByteArrayOutputStream bso = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bso);
        oos.writeObject(req.getUserPrincipal());
        oos.close();
        byte[] bytes = bso.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis){

            public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(desc.getName(), true, SerializationServlet.class.getClassLoader());
                }
                catch (Exception exception) {
                    return super.resolveClass(desc);
                }
            }
        };
        try {
            principal = (KeycloakPrincipal)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            pw.write("Deserialization failed");
            return;
        }
        KeycloakSecurityContext ctx = principal.getKeycloakSecurityContext();
        if (!(ctx instanceof RefreshableKeycloakSecurityContext)) {
            pw.write("Context was not instance of RefreshableKeycloakSecurityContext");
        }
        pw.write("Serialization/Deserialization was successful");
    }
}

