/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.InputStream;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;

public class MultiTenantResolver
implements KeycloakConfigResolver {
    public KeycloakDeployment resolve(HttpFacade.Request request) {
        InputStream is;
        String path = request.getURI();
        int multitenantIndex = path.indexOf("multi-tenant/");
        if (multitenantIndex == -1) {
            throw new IllegalStateException("Not able to resolve realm from the request path!");
        }
        String realm = path.substring(path.indexOf("multi-tenant/")).split("/")[1];
        if (realm.contains("?")) {
            realm = realm.split("\\?")[0];
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + realm + "-keycloak.json")) == null) {
            throw new IllegalStateException("Not able to find the file /" + realm + "-keycloak.json");
        }
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)is);
        return deployment;
    }
}

