/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

@WebServlet(value={"/exchange-linking"})
public class LinkAndExchangeServlet
extends HttpServlet {
    private String getPostDataString(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    public AccessTokenResponse doTokenExchange(String realm, String token, String requestedIssuer, String clientId, String clientSecret) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient client = (CloseableHttpClient)new HttpClientBuilder().disableTrustManager().build();){
            String exchangeUrl = KeycloakUriBuilder.fromUri((String)ServletTestUtils.getAuthServerUrlBase()).path("/auth/realms/{realm}/protocol/openid-connect/token").build(new Object[]{realm}).toString();
            HttpPost post = new HttpPost(exchangeUrl);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
                post.setHeader("Authorization", authorization);
            } else {
                parameters.put("client_id", clientId);
            }
            parameters.put("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange");
            parameters.put("subject_token", token);
            parameters.put("subject_token_type", "urn:ietf:params:oauth:token-type:access_token");
            parameters.put("requested_issuer", requestedIssuer);
            post.setEntity((HttpEntity)new StringEntity(this.getPostDataString(parameters)));
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 400) {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)EntityUtils.toString((HttpEntity)response.getEntity()), AccessTokenResponse.class);
                return accessTokenResponse;
            }
            try {
                throw new RuntimeException("Unknown error!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-cache");
        if (request.getRequestURI().endsWith("/link") && request.getParameter("response") == null) {
            String provider = request.getParameter("provider");
            String realm = request.getParameter("realm");
            KeycloakSecurityContext session = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
            AccessToken token = session.getToken();
            String tokenString = session.getTokenString();
            String clientId = token.getIssuedFor();
            String linkUrl = null;
            try {
                AccessTokenResponse response = this.doTokenExchange(realm, tokenString, provider, clientId, "password");
                String error = response.getError();
                if (error == null) {
                    Assert.assertNotNull((Object)response.getToken());
                    resp.setStatus(200);
                    resp.setContentType("text/html");
                    PrintWriter pw = resp.getWriter();
                    pw.printf("<html><head><title>%s</title></head><body>", "Client Linking");
                    pw.println("Account Linked");
                    pw.print("</body></html>");
                    pw.flush();
                    return;
                }
                System.out.println("*** error : " + error);
                System.out.println("*** link-url: " + response.getOtherClaims().get("account-link-url"));
                linkUrl = (String)response.getOtherClaims().get("account-link-url");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String redirectUri = KeycloakUriBuilder.fromUri((String)request.getRequestURL().toString()).replaceQuery(null).queryParam("response", new Object[]{"true"}).queryParam("realm", new Object[]{realm}).queryParam("provider", new Object[]{provider}).build(new Object[0]).toString();
            String accountLinkUrl = KeycloakUriBuilder.fromUri((String)linkUrl).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
            resp.setStatus(302);
            resp.setHeader("Location", accountLinkUrl);
        } else if (request.getRequestURI().endsWith("/link") && request.getParameter("response") != null) {
            resp.setStatus(200);
            resp.setContentType("text/html");
            PrintWriter pw = resp.getWriter();
            pw.printf("<html><head><title>%s</title></head><body>", "Client Linking");
            String error = request.getParameter("link_error");
            if (error != null) {
                pw.println("Link error: " + error);
            } else {
                pw.println("Account Linked");
            }
            pw.println("trying exchange");
            try {
                String provider = request.getParameter("provider");
                String realm = request.getParameter("realm");
                KeycloakSecurityContext session = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
                AccessToken token = session.getToken();
                String clientId = token.getIssuedFor();
                String tokenString = session.getTokenString();
                AccessTokenResponse response = this.doTokenExchange(realm, tokenString, provider, clientId, "password");
                error = (String)response.getOtherClaims().get("error");
                if (error == null) {
                    if (response.getToken() != null) {
                        pw.println("Exchange token received");
                    }
                } else {
                    pw.print("Error with exchange: " + error);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            pw.print("</body></html>");
            pw.flush();
        } else {
            resp.setStatus(200);
            resp.setContentType("text/html");
            PrintWriter pw = resp.getWriter();
            pw.printf("<html><head><title>%s</title></head><body>", "Client Linking");
            pw.println("Unknown request: " + request.getRequestURL().toString());
            pw.print("</body></html>");
            pw.flush();
        }
    }
}

