/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;

@WebServlet(value={"/input-portal"})
public class InputServlet
extends HttpServlet {
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String appBase = ServletTestUtils.getUrlBase();
        String actionUrl = appBase + "/input-portal/secured/post";
        if (req.getRequestURI().endsWith("insecure")) {
            if (System.getProperty("insecure.user.principal.unsupported") == null) {
                Assert.assertNotNull((Object)req.getUserPrincipal());
            }
            resp.setContentType("text/html");
            PrintWriter pw = resp.getWriter();
            pw.printf("<html><head><title>Input Servlet</title></head><body>%s\n", "Insecure Page");
            if (req.getUserPrincipal() != null) {
                pw.printf("UserPrincipal: " + req.getUserPrincipal().getName(), new Object[0]);
            }
            pw.print("</body></html>");
            pw.flush();
            return;
        }
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.printf("<html><head><title>%s</title></head><body>", "Input Page");
        pw.printf("<form action=\"%s\" method=\"POST\">", actionUrl);
        pw.println("<input id=\"parameter\" type=\"text\" name=\"parameter\">");
        pw.println("<input name=\"submit\" type=\"submit\" value=\"Submit\"></form>");
        pw.print("</body></html>");
        pw.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!FORM_URLENCODED.equals(req.getContentType())) {
            resp.setStatus(400);
            PrintWriter pw = resp.getWriter();
            resp.setContentType("text/plain");
            pw.printf("Expecting content type application/x-www-form-urlencoded, received " + req.getContentType() + " instead", new Object[0]);
            pw.flush();
            return;
        }
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.printf("<html><head><title>%s</title></head><body>", "Input Page");
        pw.printf("parameter=hello", new Object[0]);
        pw.print("</body></html>");
        pw.flush();
    }
}

