/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;

@WebServlet(value={"/customer-portal"})
public class CustomerServlet
extends HttpServlet {
    private static final String LINK = "<a href=\"%s\" id=\"%s\">%s</a>";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try (PrintWriter pw = resp.getWriter();){
            KeycloakSecurityContext context = (KeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName());
            if (req.getRequestURI().endsWith("logout")) {
                String line;
                resp.setStatus(200);
                pw.println("<html><body>");
                pw.println("<div id=\"customer_portal_logout\">servlet logout ok</div>");
                pw.println("</body></html>");
                StringBuilder result = new StringBuilder();
                String urlBase = ServletTestUtils.getUrlBase();
                URL url = new URL(urlBase + "/customer-db/");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("DELETE");
                conn.setRequestProperty("Authorization", "Bearer " + context.getTokenString());
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                rd.close();
                pw.println(result.toString());
                req.logout();
                pw.flush();
                return;
            }
            String urlBase = ServletTestUtils.getUrlBase();
            String serviceUrl = req.getRequestURI().endsWith("/call-customer-db-audience-required") ? urlBase + "/customer-db-audience-required/" : urlBase + "/customer-db/";
            String result = this.invokeService(serviceUrl, context);
            resp.setContentType("text/html");
            pw.println(result);
            pw.flush();
        }
    }

    private String invokeService(String serviceUrl, KeycloakSecurityContext context) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        URL url = new URL(serviceUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + context.getTokenString());
        if (conn.getResponseCode() != 200) {
            conn.getErrorStream().close();
            return "Service returned: " + conn.getResponseCode();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        return result.toString();
    }
}

