/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.adapters.saml.SamlAuthenticationError;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.AuthenticationError;
import org.w3c.dom.Document;

@Path(value="/")
public class SendUsernameServlet {
    private static boolean checkRoles = false;
    private static SamlAuthenticationError authError;
    private static Principal sentPrincipal;
    private static List<String> checkRolesList;
    @Context
    private HttpServletRequest httpServletRequest;

    @GET
    @NoCache
    public Response doGet(@QueryParam(value="checkRoles") boolean checkRolesFlag) throws IOException {
        System.out.println("In SendUsername Servlet doGet() check roles is " + (checkRolesFlag || checkRoles));
        if (this.httpServletRequest.getUserPrincipal() != null && (checkRolesFlag || checkRoles) && !this.checkRoles()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Forbidden").build();
        }
        return Response.ok((Object)this.getOutput()).header("Content-Type", (Object)(MediaType.TEXT_HTML_TYPE + ";charset=UTF-8")).build();
    }

    @POST
    @NoCache
    public Response doPost(@QueryParam(value="checkRoles") boolean checkRolesFlag) {
        System.out.println("In SendUsername Servlet doPost() check roles is " + (checkRolesFlag || checkRoles));
        if (this.httpServletRequest.getUserPrincipal() != null && (checkRolesFlag || checkRoles) && !this.checkRoles()) {
            throw new RuntimeException("User: " + this.httpServletRequest.getUserPrincipal() + " do not have required role");
        }
        return Response.ok((Object)this.getOutput()).header("Content-Type", (Object)(MediaType.TEXT_HTML_TYPE + ";charset=UTF-8")).build();
    }

    @GET
    @Path(value="getAttributes")
    public Response getSentPrincipal() throws IOException {
        System.out.println("In SendUsername Servlet getSentPrincipal()");
        sentPrincipal = this.httpServletRequest.getUserPrincipal();
        return Response.ok((Object)this.getAttributes()).header("Content-Type", (Object)(MediaType.TEXT_HTML_TYPE + ";charset=UTF-8")).build();
    }

    @GET
    @Path(value="getAssertionFromDocument")
    public Response getAssertionFromDocument() throws IOException, TransformerException {
        sentPrincipal = this.httpServletRequest.getUserPrincipal();
        DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance();
        Document doc = ((SamlPrincipal)sentPrincipal).getAssertionDocument();
        String xml = "";
        if (doc != null) {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            xml = writer.toString();
        }
        return Response.ok((Object)xml).header("Content-Type", (Object)(MediaType.TEXT_PLAIN_TYPE + ";charset=UTF-8")).build();
    }

    @GET
    @Path(value="{path}")
    public Response doGetElseWhere(@PathParam(value="path") String path, @QueryParam(value="checkRoles") boolean checkRolesFlag) throws IOException {
        System.out.println("In SendUsername Servlet doGetElseWhere() - path: " + path);
        return this.doGet(checkRolesFlag);
    }

    @POST
    @Path(value="{path}")
    public Response doPostElseWhere(@PathParam(value="path") String path, @QueryParam(value="checkRoles") boolean checkRolesFlag) throws IOException {
        System.out.println("In SendUsername Servlet doPostElseWhere() - path: " + path);
        return this.doPost(checkRolesFlag);
    }

    @POST
    @Path(value="error.html")
    public Response errorPagePost() {
        authError = (SamlAuthenticationError)this.httpServletRequest.getAttribute(AuthenticationError.class.getName());
        Integer statusCode = (Integer)this.httpServletRequest.getAttribute("javax.servlet.error.status_code");
        System.out.println("In SendUsername Servlet errorPage() status code: " + statusCode);
        return Response.ok((Object)this.getErrorOutput(statusCode)).header("Content-Type", (Object)(MediaType.TEXT_HTML_TYPE + ";charset=UTF-8")).build();
    }

    @GET
    @Path(value="error.html")
    public Response errorPageGet() {
        return this.errorPagePost();
    }

    @GET
    @Path(value="checkRoles")
    public String checkRolesEndPoint() {
        checkRoles = true;
        System.out.println("Setting checkRoles to true");
        return "Roles will be checked";
    }

    @GET
    @Path(value="uncheckRoles")
    public String uncheckRolesEndPoint() {
        checkRoles = false;
        System.out.println("Setting checkRoles to false");
        checkRolesList = Collections.singletonList("manager");
        return "Roles will not be checked";
    }

    @GET
    @Path(value="setCheckRoles")
    public String setCheckRoles(@QueryParam(value="roles") String roles) {
        checkRolesList = Arrays.asList(roles.split(","));
        checkRoles = true;
        System.out.println("Setting checkRolesList to " + checkRolesList.toString());
        return "These roles will be checked: " + checkRolesList.toString();
    }

    private boolean checkRoles() {
        for (String role : checkRolesList) {
            System.out.println("In checkRoles() checking role " + role + " for user " + this.httpServletRequest.getUserPrincipal().getName());
            if (this.httpServletRequest.isUserInRole(role)) continue;
            System.out.println("User is not in role " + role);
            return false;
        }
        return true;
    }

    private String getOutput() {
        String output = "request-path: ";
        output = output + this.httpServletRequest.getServletPath();
        output = output + "\n";
        output = output + "principal=";
        Principal principal = this.httpServletRequest.getUserPrincipal();
        if (principal == null) {
            return output + "null";
        }
        sentPrincipal = principal;
        output = output + principal.getName() + "\n";
        output = output + this.getSessionInfo() + "\n";
        output = output + this.getRoles() + "\n";
        return output;
    }

    private String getSessionInfo() {
        HttpSession session = this.httpServletRequest.getSession(false);
        if (session != null) {
            SamlSession samlSession = (SamlSession)this.httpServletRequest.getSession(false).getAttribute(SamlSession.class.getName());
            if (samlSession != null) {
                String output = "Session ID: " + samlSession.getSessionIndex() + "\n";
                XMLGregorianCalendar sessionNotOnOrAfter = samlSession.getSessionNotOnOrAfter();
                output = output + "SessionNotOnOrAfter: " + (sessionNotOnOrAfter == null ? "null" : sessionNotOnOrAfter.toString());
                return output;
            }
            return "SamlSession doesn't exist";
        }
        return "Session doesn't exist";
    }

    private String getRoles() {
        StringBuilder output = new StringBuilder("Roles: ");
        for (String role : ((SamlPrincipal)this.httpServletRequest.getUserPrincipal()).getAttributes("Roles")) {
            output.append(role).append(",");
        }
        return output.toString();
    }

    private String getErrorOutput(Integer statusCode) {
        String output = "<html><head><title>Error Page</title></head><body><h1>There was an error</h1>";
        if (statusCode != null) {
            output = output + "<br/>HTTP status code: " + statusCode;
        }
        if (authError != null) {
            output = output + "<br/>Error info: " + authError.toString();
        }
        return output + "</body></html>";
    }

    private static String joinList(String delimeter, List<String> list) {
        if (list == null || list.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i == list.size() - 1) continue;
            sb.append(delimeter);
        }
        return sb.toString();
    }

    private String getAttributes() {
        SamlPrincipal principal = (SamlPrincipal)sentPrincipal;
        StringBuilder b = new StringBuilder();
        for (Map.Entry e : principal.getAttributes().entrySet()) {
            b.append((String)e.getKey()).append(": ").append(SendUsernameServlet.joinList(",", (List)e.getValue())).append("<br />");
        }
        for (String friendlyAttributeName : principal.getFriendlyNames()) {
            b.append("friendly ").append(friendlyAttributeName).append(": ").append(SendUsernameServlet.joinList(",", principal.getFriendlyAttributes(friendlyAttributeName))).append("<br />");
        }
        return b.toString();
    }

    @GET
    @Path(value="getAssertionIssuer")
    public Response getAssertionIssuer() throws IOException {
        sentPrincipal = this.httpServletRequest.getUserPrincipal();
        SamlPrincipal principal = (SamlPrincipal)sentPrincipal;
        return Response.ok((Object)principal.getAssertion().getIssuer().getValue()).header("Content-Type", (Object)(MediaType.TEXT_HTML_TYPE + ";charset=UTF-8")).build();
    }

    static {
        checkRolesList = Collections.singletonList("manager");
    }
}

