/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;

public class SamlSPFacade
extends HttpServlet {
    public static String samlResponse;
    public static String RELAY_STATE;
    public static String sentRelayState;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handler(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handler(req, resp);
    }

    private void handler(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In SamlSPFacade Servlet handler()");
        if (req.getParameterMap().isEmpty()) {
            System.out.println("ParameterMap is empty, redirecting to keycloak server ");
            resp.setStatus(302);
            UriBuilder builder = UriBuilder.fromUri((URI)this.getSamlAuthnRequest(req));
            builder.queryParam("RelayState", new Object[]{RELAY_STATE});
            resp.setHeader("Location", builder.build(new Object[0]).toString());
            return;
        }
        System.out.println("Response was received");
        samlResponse = req.getParameter("SAMLResponse");
        sentRelayState = req.getParameter("RelayState");
        PrintWriter pw = resp.getWriter();
        pw.println("Relay state: " + sentRelayState);
        pw.println("SAML response: " + samlResponse);
        pw.flush();
    }

    private URI getSamlAuthnRequest(HttpServletRequest req) {
        try {
            BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
            SAML2Request samlReq = new SAML2Request();
            String appServerUrl = ServletTestUtils.getUrlBase() + "/employee/";
            String authServerUrl = ServletTestUtils.getAuthServerUrlBase() + "/auth/realms/demo/protocol/saml";
            AuthnRequestType loginReq = samlReq.createAuthnRequestType(UUID.randomUUID().toString(), appServerUrl, authServerUrl, "http://localhost:8280/employee/");
            loginReq.getNameIDPolicy().setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.getUri());
            return binding.redirectBinding(SAML2Request.convert((RequestAbstractType)loginReq)).requestURI(authServerUrl);
        }
        catch (IOException | ConfigurationException | ParsingException | ProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        RELAY_STATE = "http://test.com/foo/bar";
    }
}

