/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.InputStream;
import org.keycloak.adapters.saml.SamlConfigResolver;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.saml.common.exceptions.ParsingException;

public class SamlMultiTenantResolver
implements SamlConfigResolver {
    public SamlDeployment resolve(HttpFacade.Request request) {
        String realm = request.getQueryParamValue("realm");
        if (realm == null) {
            throw new IllegalStateException("Not able to resolve realm from the request path!");
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + realm + "-keycloak-saml.xml");
        if (is == null) {
            throw new IllegalStateException("Not able to find the file /" + realm + "-keycloak-saml.xml");
        }
        ResourceLoader loader = new ResourceLoader(){

            public InputStream getResourceAsStream(String path) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
        };
        try {
            return new DeploymentBuilder().build(is, loader);
        }
        catch (ParsingException e) {
            throw new IllegalStateException("Cannot load SAML deployment", e);
        }
    }
}

