/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;

@WebServlet(value={"/customer-portal-noconf"})
public class CustomerServletNoConf
extends HttpServlet {
    private static final String LINK = "<a href=\"%s\" id=\"%s\">%s</a>";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String line;
        PrintWriter pw = resp.getWriter();
        if (req.getRequestURI().endsWith("logout")) {
            resp.setStatus(200);
            pw.println("servlet logout ok");
            req.logout();
            pw.flush();
            return;
        }
        KeycloakSecurityContext context = (KeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName());
        StringBuilder result = new StringBuilder();
        String urlBase = ServletTestUtils.getUrlBase();
        URL url = new URL(urlBase + "/customer-db/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + context.getTokenString());
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        resp.setContentType("text/html");
        pw.println(result.toString());
        pw.flush();
    }
}

