/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractShowTokensServlet
extends HttpServlet {
    private static final String LINK = "<a href=\"%s\" id=\"%s\">%s</a>";

    protected String renderTokens(HttpServletRequest req) throws ServletException, IOException {
        RefreshToken refreshToken;
        RefreshableKeycloakSecurityContext ctx = (RefreshableKeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName());
        String accessTokenPretty = JsonSerialization.writeValueAsPrettyString((Object)ctx.getToken());
        try {
            refreshToken = (RefreshToken)new JWSInput(ctx.getRefreshToken()).readJsonContent(RefreshToken.class);
        }
        catch (JWSInputException e) {
            throw new IOException(e);
        }
        String refreshTokenPretty = JsonSerialization.writeValueAsPrettyString((Object)refreshToken);
        return "<span id=\"accessToken\">" + accessTokenPretty + "</span>" + ("<span id=\"refreshToken\">" + refreshTokenPretty + "</span>") + ("<span id=\"accessTokenString\">" + ctx.getTokenString() + "</span>") + ("<span id=\"refreshTokenString\">" + ctx.getRefreshToken() + "</span>");
    }
}

