/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.rotation.JWKPublicKeyLocator;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.reflections.Reflections;

public class AdapterActionsFilter
implements Filter {
    public static final String TIME_OFFSET_PARAM = "timeOffset";
    public static final String RESET_DEPLOYMENT_PARAM = "resetDeployment";
    private static final Logger log = Logger.getLogger(AdapterActionsFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletReq = (HttpServletRequest)request;
        HttpServletResponse servletResp = (HttpServletResponse)response;
        String timeOffsetParam = request.getParameter(TIME_OFFSET_PARAM);
        String resetDeploymentParam = request.getParameter(RESET_DEPLOYMENT_PARAM);
        if (timeOffsetParam != null && !timeOffsetParam.isEmpty()) {
            int timeOffset = Integer.parseInt(timeOffsetParam);
            log.infof("Time offset updated to %d for application %s", (Object)timeOffset, (Object)servletReq.getRequestURI());
            Time.setOffset((int)timeOffset);
            this.writeResponse(servletResp, "Offset set successfully");
        } else if (resetDeploymentParam != null && !resetDeploymentParam.isEmpty()) {
            AdapterDeploymentContext deploymentContext = (AdapterDeploymentContext)request.getServletContext().getAttribute(AdapterDeploymentContext.class.getName());
            Field field = Reflections.findDeclaredField(AdapterDeploymentContext.class, (String)"deployment");
            Reflections.setAccessible((AccessibleObject)field);
            KeycloakDeployment deployment = (KeycloakDeployment)Reflections.getFieldValue((Field)field, (Object)deploymentContext);
            Time.setOffset((int)0);
            deployment.setNotBefore(0);
            if (deployment.getPublicKeyLocator() instanceof JWKPublicKeyLocator) {
                deployment.setPublicKeyLocator((PublicKeyLocator)new JWKPublicKeyLocator());
            }
            log.infof("Restarted PublicKeyLocator, notBefore and timeOffset for application %s", (Object)servletReq.getRequestURI());
            this.writeResponse(servletResp, "Restarted PublicKeyLocator, notBefore and timeOffset successfully");
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void writeResponse(HttpServletResponse response, String responseText) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<html><body>" + responseText + "</body></html>");
        writer.flush();
    }
}

