/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow.lb;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.RouteIteratorFactory;
import io.undertow.server.handlers.proxy.RouteParsingStrategy;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.testsuite.utils.tls.TLSUtils;
import org.xnio.OptionMap;

public class SimpleUndertowLoadBalancer {
    private static final Logger log = Logger.getLogger(SimpleUndertowLoadBalancer.class);
    static final String DEFAULT_NODES_HTTP = "node1=http://localhost:8181,node2=http://localhost:8182";
    private final String host;
    private final int httpPort;
    private final int httpsPort;
    private final Map<String, URI> backendNodes;
    private Undertow undertow;
    private LoadBalancingProxyClient lb;
    private static final AttachmentKey<LoadBalancingProxyClient.Host> SELECTED_HOST = AttachmentKey.create(LoadBalancingProxyClient.Host.class);
    private static final AttachmentKey<Integer> REMAINING_RETRY_ATTEMPTS = AttachmentKey.create(Integer.class);

    public static void main(String[] args) throws Exception {
        String nodes = System.getProperty("keycloak.nodes", DEFAULT_NODES_HTTP);
        final SimpleUndertowLoadBalancer lb = new SimpleUndertowLoadBalancer("localhost", 8180, 8543, nodes);
        lb.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                lb.stop();
            }
        });
    }

    public SimpleUndertowLoadBalancer(String host, int httpPort, int httpsPort, String nodesString) {
        this.host = host;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.backendNodes = SimpleUndertowLoadBalancer.parseNodes(nodesString);
        log.infof("Keycloak nodes: %s", this.backendNodes);
    }

    public void start() {
        try {
            HttpHandler proxyHandler = this.createHandler();
            this.undertow = Undertow.builder().addHttpListener(this.httpPort, this.host).addHttpsListener(this.httpsPort, this.host, TLSUtils.initializeTLS()).setHandler(proxyHandler).build();
            this.undertow.start();
            this.backendNodes.forEach((route, uri) -> {
                this.lb.addHost(uri, route);
                log.debugf("Added host: %s, route: %s", (Object)uri.toString(), route);
            });
            log.infof("#### Loadbalancer started and ready to serve requests on http://%s:%d, https://%s:%d ####", new Object[]{this.host, this.httpPort, this.host, this.httpsPort});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.undertow.stop();
    }

    public void enableAllBackendNodes() {
        this.backendNodes.forEach((route, uri) -> {
            this.lb.removeHost(uri);
            this.lb.addHost(uri, route);
        });
        log.infof("Load balancer: enable all nodes. All enabled nodes: %s", (Object)this.lb.toString());
    }

    public void disableAllBackendNodes() {
        this.backendNodes.values().forEach(arg_0 -> ((LoadBalancingProxyClient)this.lb).removeHost(arg_0));
        log.infof("Load balancer: disabling all nodes", new Object[0]);
    }

    public void enableBackendNodeByName(String nodeName) {
        URI uri = this.backendNodes.get(nodeName);
        if (uri == null) {
            throw new IllegalArgumentException("Invalid node: " + nodeName);
        }
        this.lb.addHost(uri, nodeName);
        log.infof("Load balancer: enabled node '%s', All enabled nodes: %s", (Object)nodeName, (Object)this.lb.toString());
    }

    public void disableBackendNodeByName(String nodeName) {
        URI uri = this.backendNodes.get(nodeName);
        if (uri == null) {
            throw new IllegalArgumentException("Invalid node: " + nodeName);
        }
        this.lb.removeHost(uri);
        log.infof("Load balancer: disabled node '%s', All enabled nodes: %s", (Object)nodeName, (Object)this.lb.toString());
    }

    static Map<String, URI> parseNodes(String nodes) {
        StringTokenizer st = new StringTokenizer(nodes, ",");
        LinkedHashMap<String, URI> result = new LinkedHashMap<String, URI>();
        while (st.hasMoreElements()) {
            String nodeStr = st.nextToken();
            String[] node = nodeStr.trim().split("=", 2);
            result.put(node[0].trim(), URI.create(node[1].trim()));
        }
        return result;
    }

    private HttpHandler createHandler() throws Exception {
        String[] sessionIds = new String[]{"AUTH_SESSION_ID", "AUTH_SESSION_ID_LEGACY"};
        int connectionsPerThread = 20;
        int problemServerRetry = 5;
        int maxTime = 3600000;
        int requestQueueSize = 10;
        int cachedConnectionsPerThread = 10;
        int connectionIdleTimeout = 60;
        int maxRetryAttempts = this.backendNodes.size() - 1;
        this.lb = new CustomLoadBalancingClient(exchange -> exchange.getRequestHeaders().contains(Headers.UPGRADE), maxRetryAttempts).setConnectionsPerThread(connectionsPerThread).setMaxQueueSize(requestQueueSize).setSoftMaxConnectionsPerThread(cachedConnectionsPerThread).setTtl(connectionIdleTimeout).setProblemServerRetry(problemServerRetry);
        for (String id : sessionIds) {
            this.lb.addSessionCookieName(id);
        }
        return new ProxyHandler((ProxyClient)this.lb, maxTime, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    private static class ProxyCallbackDelegate
    implements ProxyCallback<ProxyConnection> {
        private final ProxyClient proxyClient;
        private final ProxyCallback<ProxyConnection> delegate;
        private final long timeoutMs;
        private final int maxRetryAttempts;

        public ProxyCallbackDelegate(ProxyClient proxyClient, ProxyCallback<ProxyConnection> delegate, long timeoutMs, int maxRetryAttempts) {
            this.proxyClient = proxyClient;
            this.delegate = delegate;
            this.timeoutMs = timeoutMs;
            this.maxRetryAttempts = maxRetryAttempts;
        }

        public void completed(HttpServerExchange exchange, ProxyConnection result) {
            LoadBalancingProxyClient.Host host = (LoadBalancingProxyClient.Host)exchange.getAttachment(SELECTED_HOST);
            if (host == null) {
                log.error((Object)"Host is null!!!");
            } else if (!host.isAvailable()) {
                log.infof("Host %s available again after failover", (Object)host.getUri());
                host.clearError();
            }
            this.delegate.completed(exchange, (Object)result);
        }

        public void failed(HttpServerExchange exchange) {
            long time = System.currentTimeMillis();
            Integer remainingAttempts = (Integer)exchange.getAttachment(REMAINING_RETRY_ATTEMPTS);
            if (remainingAttempts == null) {
                remainingAttempts = this.maxRetryAttempts;
            } else {
                Integer n = remainingAttempts;
                Integer n2 = remainingAttempts = Integer.valueOf(remainingAttempts - 1);
            }
            exchange.putAttachment(REMAINING_RETRY_ATTEMPTS, (Object)remainingAttempts);
            log.infof("Failed request to selected host. Remaining attempts: %d", (Object)remainingAttempts);
            if (remainingAttempts > 0) {
                if (this.timeoutMs > 0L && time > this.timeoutMs) {
                    this.delegate.failed(exchange);
                } else {
                    ProxyClient.ProxyTarget target = this.proxyClient.findTarget(exchange);
                    if (target != null) {
                        long remaining = this.timeoutMs > 0L ? this.timeoutMs - time : -1L;
                        this.proxyClient.getConnection(target, exchange, (ProxyCallback)this, remaining, TimeUnit.MILLISECONDS);
                    } else {
                        this.couldNotResolveBackend(exchange);
                    }
                }
            } else {
                this.couldNotResolveBackend(exchange);
            }
        }

        public void couldNotResolveBackend(HttpServerExchange exchange) {
            log.warnf("Could not resolve backend when request to: %s", (Object)exchange.getRequestURI());
            this.delegate.couldNotResolveBackend(exchange);
        }

        public void queuedRequestFailed(HttpServerExchange exchange) {
            this.delegate.queuedRequestFailed(exchange);
        }
    }

    private class CustomLoadBalancingClient
    extends LoadBalancingProxyClient {
        private final int maxRetryAttempts;

        public CustomLoadBalancingClient(ExclusivityChecker checker, int maxRetryAttempts) {
            super(checker);
            this.maxRetryAttempts = maxRetryAttempts;
        }

        protected LoadBalancingProxyClient.Host selectHost(HttpServerExchange exchange) {
            LoadBalancingProxyClient.Host host = super.selectHost(exchange);
            if (host != null) {
                log.debugf("Selected host: %s, host available: %b", (Object)host.getUri().toString(), (Object)host.isAvailable());
            } else {
                log.warn((Object)"No host available");
            }
            exchange.putAttachment(SELECTED_HOST, (Object)host);
            return host;
        }

        private LoadBalancingProxyClient.Host getRoute(String routeId) {
            Field f = Reflections.findDeclaredField(LoadBalancingProxyClient.class, (String)"routes");
            f.setAccessible(true);
            Map routes = (Map)Reflections.getFieldValue((Field)f, (Object)((Object)this), Map.class);
            return routes == null ? null : (LoadBalancingProxyClient.Host)routes.get(routeId);
        }

        protected Iterator<CharSequence> parseRoutes(HttpServerExchange exchange) {
            LoadBalancingProxyClient.Host stickyHost;
            Iterator stickyHostsIt = super.parseRoutes(exchange);
            if (stickyHostsIt == null) {
                return null;
            }
            LinkedList stickyHosts = new LinkedList();
            stickyHostsIt.forEachRemaining(stickyHosts::add);
            CharSequence stickyHostName = stickyHosts.isEmpty() ? null : (CharSequence)stickyHosts.iterator().next();
            LoadBalancingProxyClient.Host host = stickyHost = stickyHostName == null ? null : this.getRoute(stickyHostName.toString());
            if (stickyHost != null) {
                if (!stickyHost.isAvailable()) {
                    log.debugf("Sticky host %s not available. Trying different hosts", (Object)stickyHost.getUri());
                    return new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_JK, null).iterator(null);
                }
                log.debugf("Sticky host %s found and looks available", (Object)stickyHost.getUri());
            }
            return stickyHosts.iterator();
        }

        public synchronized LoadBalancingProxyClient addHost(URI host, String jvmRoute) {
            List<String> current = this.getCurrentHostRoutes();
            if (current.contains(jvmRoute)) {
                log.infof("Route '%s' already present. Skip adding", (Object)jvmRoute);
                return this;
            }
            try {
                return super.addHost(host, jvmRoute, SimpleUndertowLoadBalancer.this.undertow.getXnio().getSslProvider(OptionMap.EMPTY));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }

        public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
            long timeoutMs = timeUnit.toMillis(timeout);
            ProxyCallbackDelegate callbackDelegate = new ProxyCallbackDelegate((ProxyClient)this, callback, timeoutMs, this.maxRetryAttempts);
            super.getConnection(target, exchange, (ProxyCallback)callbackDelegate, timeout, timeUnit);
        }

        public String toString() {
            return this.getCurrentHostRoutes().toString();
        }

        private List<String> getCurrentHostRoutes() {
            Field hostsField = Reflections.findDeclaredField(LoadBalancingProxyClient.class, (String)"hosts");
            hostsField.setAccessible(true);
            LoadBalancingProxyClient.Host[] hosts = (LoadBalancingProxyClient.Host[])Reflections.getFieldValue((Field)hostsField, (Object)((Object)this));
            if (hosts == null) {
                return Collections.emptyList();
            }
            LinkedList<String> hostRoutes = new LinkedList<String>();
            for (LoadBalancingProxyClient.Host host : hosts) {
                Field hostField = Reflections.findDeclaredField(LoadBalancingProxyClient.Host.class, (String)"jvmRoute");
                hostField.setAccessible(true);
                String route = Reflections.getFieldValue((Field)hostField, (Object)host).toString();
                hostRoutes.add(route);
            }
            return hostRoutes;
        }
    }
}

