/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.undertow.api.UndertowWebArchive;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.testsuite.KeycloakServer;
import org.keycloak.testsuite.UndertowRequestFilter;
import org.keycloak.testsuite.arquillian.undertow.KeycloakOnUndertowConfiguration;
import org.keycloak.testsuite.utils.tls.TLSUtils;
import org.keycloak.testsuite.utils.undertow.UndertowDeployerHelper;
import org.keycloak.testsuite.utils.undertow.UndertowWarClassLoader;
import org.keycloak.util.JsonSerialization;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class KeycloakOnUndertow
implements DeployableContainer<KeycloakOnUndertowConfiguration> {
    protected final Logger log = Logger.getLogger(this.getClass());
    private KeycloakUndertowJaxrsServer undertow;
    private KeycloakOnUndertowConfiguration configuration;
    private KeycloakSessionFactory sessionFactory;
    Map<String, String> deployedArchivesToContextPath = new ConcurrentHashMap<String, String>();

    private DeploymentInfo createAuthServerDeploymentInfo() {
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(KeycloakApplication.class.getName());
        deployment.setProperty("resteasy.disable.html.sanitizer", (Object)true);
        deployment.getDisabledProviderClasses().add("org.jboss.resteasy.plugins.interceptors.encoding.GZIPEncodingInterceptor");
        DeploymentInfo di = this.undertow.undertowDeployment(deployment);
        di.setClassLoader(this.getClass().getClassLoader());
        di.setContextPath("/auth");
        di.setDeploymentName("Keycloak");
        if (this.configuration.getKeycloakConfigPropertyOverridesMap() != null) {
            try {
                di.addInitParameter("keycloak.server.context.config.property-overrides", JsonSerialization.writeValueAsString(this.configuration.getKeycloakConfigPropertyOverridesMap()));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        di.setDefaultServletConfig(new DefaultServletConfig(true));
        di.addWelcomePage("theme/keycloak/welcome/resources/index.html");
        InstanceHandle<Filter> filterInstance = new InstanceHandle<Filter>(){

            public Filter getInstance() {
                return new UndertowRequestFilter(KeycloakOnUndertow.this.sessionFactory);
            }

            public void release() {
            }
        };
        FilterInfo filter = Servlets.filter((String)"SessionFilter", UndertowRequestFilter.class, () -> KeycloakOnUndertow.lambda$createAuthServerDeploymentInfo$0((InstanceHandle)filterInstance));
        di.addFilter(filter);
        di.addFilterUrlMapping("SessionFilter", "/*", DispatcherType.REQUEST);
        filter.setAsyncSupported(true);
        return di;
    }

    public DeploymentInfo getDeplotymentInfoFromArchive(Archive<?> archive) {
        if (archive instanceof UndertowWebArchive) {
            return ((UndertowWebArchive)archive).getDeploymentInfo();
        }
        if (archive instanceof WebArchive) {
            return new UndertowDeployerHelper().getDeploymentInfo((UndertowContainerConfiguration)this.configuration, (WebArchive)archive);
        }
        throw new IllegalArgumentException("UndertowContainer only supports UndertowWebArchive or WebArchive.");
    }

    private HTTPContext createHttpContextForDeploymentInfo(DeploymentInfo deploymentInfo) {
        HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
        Map servlets = deploymentInfo.getServlets();
        Collection servletsInfo = servlets.values();
        for (ServletInfo servletInfo : servletsInfo) {
            httpContext.add(new Servlet(servletInfo.getName(), deploymentInfo.getContextPath()));
        }
        return httpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (this.isRemoteMode()) {
            this.log.infof("Skipped deployment of '%s' as we are in remote mode!", (Object)archive.getName());
            return new ProtocolMetaData();
        }
        DeploymentInfo di = this.getDeplotymentInfoFromArchive(archive);
        ClassLoader parentCl = Thread.currentThread().getContextClassLoader();
        UndertowWarClassLoader classLoader = new UndertowWarClassLoader(parentCl, archive);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        try {
            this.undertow.deploy(di);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentCl);
        }
        this.deployedArchivesToContextPath.put(archive.getName(), di.getContextPath());
        return new ProtocolMetaData().addContext((Object)this.createHttpContextForDeploymentInfo(di));
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Class<KeycloakOnUndertowConfiguration> getConfigurationClass() {
        return KeycloakOnUndertowConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.1");
    }

    public void setup(KeycloakOnUndertowConfiguration undertowContainerConfiguration) {
        this.configuration = undertowContainerConfiguration;
    }

    public void start() throws LifecycleException {
        this.log.info((Object)"Starting auth server on undertow.");
        if (this.isRemoteMode()) {
            this.log.info((Object)"Skip bootstrap undertow. We are in remote mode");
            return;
        }
        KeycloakServer.configureDataDirectory();
        this.log.infof("Starting auth server on embedded Undertow on: http://%s:%d", (Object)this.configuration.getBindAddress(), (Object)this.configuration.getBindHttpPort());
        long start = System.currentTimeMillis();
        if (this.undertow == null) {
            this.undertow = new KeycloakUndertowJaxrsServer();
        }
        this.undertow.start(Undertow.builder().addHttpListener(this.configuration.getBindHttpPort(), this.configuration.getBindAddress()).addHttpsListener(this.configuration.getBindHttpsPort(), this.configuration.getBindAddress(), TLSUtils.initializeTLS()).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED).setWorkerThreads(this.configuration.getWorkerThreads()).setIoThreads(this.configuration.getWorkerThreads() / 8));
        if (this.configuration.getRoute() != null) {
            this.log.info((Object)("Using route: " + this.configuration.getRoute()));
        }
        DeploymentInfo di = this.createAuthServerDeploymentInfo();
        this.undertow.deploy(di);
        this.sessionFactory = KeycloakApplication.getSessionFactory();
        this.setupDevConfig();
        this.log.infof("Auth server started in %dms on http://%s:%d/auth", (Object)(System.currentTimeMillis() - start), (Object)this.configuration.getBindAddress(), (Object)this.configuration.getBindHttpPort());
    }

    protected void setupDevConfig() {
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransactionManager().begin();
            if (new ApplianceBootstrap(session).isNoMasterUser()) {
                new ApplianceBootstrap(session).createMasterRealmUser("admin", "admin");
            }
            session.getTransactionManager().commit();
        }
    }

    public void stop() throws LifecycleException {
        if (this.isRemoteMode()) {
            this.log.info((Object)"Skip stopping undertow. We are in remote mode");
            return;
        }
        this.log.info((Object)"Stopping auth server.");
        this.sessionFactory.close();
        this.undertow.stop();
    }

    private boolean isRemoteMode() {
        return this.configuration.isRemoteMode();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (this.isRemoteMode()) {
            this.log.infof("Skipped undeployment of '%s' as we are in remote mode!", (Object)archive.getName());
            return;
        }
        Field containerField = Reflections.findDeclaredField(UndertowJaxrsServer.class, (String)"container");
        Reflections.setAccessible((AccessibleObject)containerField);
        ServletContainer container = (ServletContainer)Reflections.getFieldValue((Field)containerField, (Object)((Object)this.undertow));
        DeploymentManager deploymentMgr = container.getDeployment(archive.getName());
        if (deploymentMgr != null) {
            DeploymentInfo deployment = deploymentMgr.getDeployment().getDeploymentInfo();
            try {
                deploymentMgr.stop();
            }
            catch (ServletException se) {
                throw new DeploymentException(se.getMessage(), (Throwable)se);
            }
            deploymentMgr.undeploy();
            Field rootField = Reflections.findDeclaredField(UndertowJaxrsServer.class, (String)"root");
            Reflections.setAccessible((AccessibleObject)rootField);
            PathHandler root = (PathHandler)Reflections.getFieldValue((Field)rootField, (Object)((Object)this.undertow));
            String path = this.deployedArchivesToContextPath.get(archive.getName());
            root.removePrefixPath(path);
            container.removeDeployment(deployment);
        } else {
            this.log.warnf("Deployment '%s' not found", (Object)archive.getName());
        }
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static /* synthetic */ InstanceHandle lambda$createAuthServerDeploymentInfo$0(InstanceHandle filterInstance) throws InstantiationException {
        return filterInstance;
    }

    private static class KeycloakUndertowJaxrsServer
    extends UndertowJaxrsServer {
        private KeycloakUndertowJaxrsServer() {
        }

        public KeycloakUndertowJaxrsServer start(Undertow.Builder builder) {
            try {
                Field f = UndertowJaxrsServer.class.getDeclaredField("root");
                f.setAccessible(true);
                HttpHandler origRootHandler = (HttpHandler)f.get((Object)this);
                ProxyPeerAddressHandler wrappedHandler = new ProxyPeerAddressHandler(origRootHandler);
                this.server = builder.setHandler((HttpHandler)wrappedHandler).build();
                this.server.start();
                return this;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

