/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow.lb;

import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.undertow.lb.SimpleUndertowLoadBalancer;

public class SimpleUndertowLoadBalancerConfiguration
extends UndertowContainerConfiguration {
    public static final int DEFAULT_HTTPS_PORT = Integer.valueOf(System.getProperty("auth.server.https.port", "8543"));
    protected static final Logger log = Logger.getLogger(SimpleUndertowLoadBalancerConfiguration.class);
    private String nodes = "node1=http://localhost:8181,node2=http://localhost:8182";
    private int bindHttpPortOffset = 0;
    private int bindHttpsPortOffset = 0;
    private int bindHttpsPort = DEFAULT_HTTPS_PORT;

    public String getNodes() {
        return this.nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public int getBindHttpPortOffset() {
        return this.bindHttpPortOffset;
    }

    public void setBindHttpPortOffset(int bindHttpPortOffset) {
        this.bindHttpPortOffset = bindHttpPortOffset;
    }

    public int getBindHttpsPortOffset() {
        return this.bindHttpsPortOffset;
    }

    public void setBindHttpsPortOffset(int bindHttpsPortOffset) {
        this.bindHttpsPortOffset = bindHttpsPortOffset;
    }

    public int getBindHttpsPort() {
        return this.bindHttpsPort;
    }

    public void setBindHttpsPort(int bindHttpsPort) {
        this.bindHttpsPort = bindHttpsPort;
    }

    public void validate() throws ConfigurationException {
        super.validate();
        try {
            SimpleUndertowLoadBalancer.parseNodes(this.nodes);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.setBindHttpPort(this.getBindHttpPort() + this.bindHttpPortOffset);
        this.setBindHttpsPort(this.getBindHttpsPort() + this.bindHttpsPortOffset);
        log.info((Object)("SimpleUndertowLoadBalancer will listen on ports: " + this.getBindHttpPort() + " " + this.getBindHttpsPort()));
    }
}

