/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.logging.Logger;
import org.keycloak.util.JsonSerialization;

public class KeycloakOnUndertowConfiguration
extends UndertowContainerConfiguration {
    public static final int DEFAULT_HTTPS_PORT = Integer.valueOf(System.getProperty("auth.server.https.port", "8543"));
    protected static final Logger log = Logger.getLogger(KeycloakOnUndertowConfiguration.class);
    private int workerThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
    private String resourcesHome;
    private boolean remoteMode;
    private String route;
    private String keycloakConfigPropertyOverrides;
    private HashMap<String, Object> keycloakConfigPropertyOverridesMap;
    private int bindHttpPortOffset = 0;
    private int bindHttpsPortOffset = 0;
    private int bindHttpsPort = DEFAULT_HTTPS_PORT;

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public String getResourcesHome() {
        return this.resourcesHome;
    }

    public void setResourcesHome(String resourcesHome) {
        this.resourcesHome = resourcesHome;
    }

    public int getBindHttpPortOffset() {
        return this.bindHttpPortOffset;
    }

    public void setBindHttpPortOffset(int bindHttpPortOffset) {
        this.bindHttpPortOffset = bindHttpPortOffset;
    }

    public int getBindHttpsPortOffset() {
        return this.bindHttpsPortOffset;
    }

    public void setBindHttpsPortOffset(int bindHttpsPortOffset) {
        this.bindHttpsPortOffset = bindHttpsPortOffset;
    }

    public int getBindHttpsPort() {
        return this.bindHttpsPort;
    }

    public void setBindHttpsPort(int bindHttpsPort) {
        this.bindHttpsPort = bindHttpsPort;
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public boolean isRemoteMode() {
        return this.remoteMode;
    }

    public void setRemoteMode(boolean remoteMode) {
        this.remoteMode = remoteMode;
    }

    public String getKeycloakConfigPropertyOverrides() {
        return this.keycloakConfigPropertyOverrides;
    }

    public void setKeycloakConfigPropertyOverrides(String keycloakConfigPropertyOverrides) {
        this.keycloakConfigPropertyOverrides = keycloakConfigPropertyOverrides;
    }

    public Map<String, Object> getKeycloakConfigPropertyOverridesMap() {
        return this.keycloakConfigPropertyOverridesMap;
    }

    public void validate() throws ConfigurationException {
        super.validate();
        int basePort = this.getBindHttpPort();
        int newPort = basePort + this.bindHttpPortOffset;
        this.setBindHttpPort(newPort);
        int baseHttpsPort = this.getBindHttpsPort();
        int newHttpsPort = baseHttpsPort + this.bindHttpsPortOffset;
        this.setBindHttpsPort(newHttpsPort);
        log.info((Object)("KeycloakOnUndertow will listen for http on port: " + newPort + " and for https on port: " + newHttpsPort));
        if (this.keycloakConfigPropertyOverrides != null) {
            try {
                TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                this.keycloakConfigPropertyOverridesMap = (HashMap)JsonSerialization.sysPropertiesAwareMapper.readValue(this.keycloakConfigPropertyOverrides, (TypeReference)typeRef);
            }
            catch (IOException ex) {
                throw new ConfigurationException((Throwable)ex);
            }
        }
    }
}

