/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow;

import io.undertow.Undertow;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.undertow.api.UndertowWebArchive;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.testsuite.arquillian.undertow.UndertowAppServerConfiguration;
import org.keycloak.testsuite.arquillian.undertow.saml.util.RestSamlApplicationConfig;
import org.keycloak.testsuite.utils.undertow.UndertowDeployerHelper;
import org.keycloak.testsuite.utils.undertow.UndertowWarClassLoader;

public class UndertowAppServer
implements DeployableContainer<UndertowAppServerConfiguration> {
    private static final Logger log = Logger.getLogger(UndertowAppServer.class);
    private UndertowContainerConfiguration configuration;
    private UndertowJaxrsServer undertow;
    Map<String, String> deployedArchivesToContextPath = new ConcurrentHashMap<String, String>();

    public Class<UndertowAppServerConfiguration> getConfigurationClass() {
        return UndertowAppServerConfiguration.class;
    }

    public void setup(UndertowAppServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        long start = System.currentTimeMillis();
        this.undertow = new UndertowJaxrsServer();
        this.undertow.start(Undertow.builder().addHttpListener(this.configuration.getBindHttpPort(), this.configuration.getBindAddress()));
        log.infof("App server started in %dms on http://%s:%d/", (Object)(System.currentTimeMillis() - start), (Object)this.configuration.getBindAddress(), (Object)this.configuration.getBindHttpPort());
    }

    public void stop() throws LifecycleException {
        this.undertow.stop();
        log.info((Object)"App Server stopped.");
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        DeploymentInfo di;
        File tmpUndertowJSPDirectory;
        log.info((Object)("Deploying archive " + archive.getName()));
        String ioTMPDir = System.getProperty("java.io.tmpdir", "");
        if (!ioTMPDir.isEmpty() && (tmpUndertowJSPDirectory = new File((ioTMPDir = ioTMPDir.endsWith("/") ? ioTMPDir : ioTMPDir + "/") + "org/apache/jsp")).exists()) {
            try {
                FileUtils.deleteDirectory((File)tmpUndertowJSPDirectory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (archive instanceof UndertowWebArchive) {
            di = ((UndertowWebArchive)archive).getDeploymentInfo();
        } else if (archive instanceof WebArchive) {
            WebArchive webArchive = (WebArchive)archive;
            Optional applicationClassNode = archive.getContent(archivePath -> archivePath.get().startsWith("/WEB-INF/classes/") && archivePath.get().endsWith("Application.class")).values().stream().findFirst();
            if (this.isJaxrsApp(webArchive)) {
                di = new UndertowDeployerHelper().getDeploymentInfo(this.configuration, webArchive, this.undertow.undertowDeployment(this.discoverPathAnnotatedClasses(webArchive)));
            } else if (applicationClassNode.isPresent()) {
                String applicationPath = ((Node)applicationClassNode.get()).getPath().get();
                ResteasyDeployment deployment = new ResteasyDeployment();
                deployment.setApplicationClass(this.extractClassName(applicationPath));
                di = new UndertowDeployerHelper().getDeploymentInfo(this.configuration, (WebArchive)archive, this.undertow.undertowDeployment(deployment));
            } else {
                di = new UndertowDeployerHelper().getDeploymentInfo(this.configuration, webArchive);
            }
        } else {
            throw new IllegalArgumentException("UndertowContainer only supports UndertowWebArchive or WebArchive.");
        }
        if ("ROOT.war".equals(archive.getName())) {
            di.setContextPath("/");
        }
        ClassLoader parentCl = Thread.currentThread().getContextClassLoader();
        UndertowWarClassLoader classLoader = new UndertowWarClassLoader(parentCl, archive);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        try {
            this.undertow.deploy(di);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentCl);
        }
        this.deployedArchivesToContextPath.put(archive.getName(), di.getContextPath());
        return new ProtocolMetaData().addContext((Object)this.createHttpContextForDeploymentInfo(di));
    }

    private String extractClassName(String applicationPath) {
        applicationPath = applicationPath.substring(0, applicationPath.lastIndexOf(".class")).replaceFirst("^/WEB-INF/classes/", "");
        return applicationPath.replaceAll("/", ".");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        log.info((Object)("Undeploying archive " + archive.getName()));
        Field containerField = Reflections.findDeclaredField(UndertowJaxrsServer.class, (String)"container");
        Reflections.setAccessible((AccessibleObject)containerField);
        ServletContainer container = (ServletContainer)Reflections.getFieldValue((Field)containerField, (Object)this.undertow);
        DeploymentManager deploymentMgr = container.getDeployment(archive.getName());
        if (deploymentMgr != null) {
            DeploymentInfo deployment = deploymentMgr.getDeployment().getDeploymentInfo();
            try {
                deploymentMgr.stop();
            }
            catch (ServletException se) {
                throw new DeploymentException(se.getMessage(), (Throwable)se);
            }
            deploymentMgr.undeploy();
            Field rootField = Reflections.findDeclaredField(UndertowJaxrsServer.class, (String)"root");
            Reflections.setAccessible((AccessibleObject)rootField);
            PathHandler root = (PathHandler)Reflections.getFieldValue((Field)rootField, (Object)this.undertow);
            String path = this.deployedArchivesToContextPath.get(archive.getName());
            root.removePrefixPath(path);
            container.removeDeployment(deployment);
        } else {
            log.warnf("Deployment '%s' not found", (Object)archive.getName());
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private HTTPContext createHttpContextForDeploymentInfo(DeploymentInfo deploymentInfo) {
        HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
        Map servlets = deploymentInfo.getServlets();
        Collection servletsInfo = servlets.values();
        for (ServletInfo servletInfo : servletsInfo) {
            httpContext.add(new Servlet(servletInfo.getName(), deploymentInfo.getContextPath()));
        }
        return httpContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJaxrsApp(WebArchive archive) throws DeploymentException {
        if (!archive.contains("/WEB-INF/web.xml")) {
            return false;
        }
        try (InputStream stream = archive.get("/WEB-INF/web.xml").getAsset().openStream();){
            boolean bl = IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8")).contains(Application.class.getName());
            return bl;
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to read archive.", (Throwable)e);
        }
    }

    private ResteasyDeployment discoverPathAnnotatedClasses(WebArchive webArchive) {
        Set<Class<?>> classes = webArchive.getContent(archivePath -> archivePath.get().startsWith("/WEB-INF/classes/") && archivePath.get().endsWith(".class")).values().stream().filter(node -> node.getAsset() instanceof ClassAsset).map(node -> ((ClassAsset)node.getAsset()).getSource()).filter(clazz -> clazz.isAnnotationPresent(Path.class)).collect(Collectors.toSet());
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplication((Application)new RestSamlApplicationConfig(classes));
        return deployment;
    }
}

