/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow.container;

import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.keycloak.testsuite.utils.annotation.UseServletFilter;
import org.keycloak.testsuite.utils.arquillian.DeploymentArchiveProcessorUtils;

public class UndertowDeploymentArchiveProcessor
implements ApplicationArchiveProcessor {
    private final Logger log = Logger.getLogger(UndertowDeploymentArchiveProcessor.class);

    public void process(Archive<?> archive, TestClass testClass) {
        if (DeploymentArchiveProcessorUtils.checkRunOnServerDeployment(archive)) {
            return;
        }
        if (!System.getProperty("app.server", "undertow").equals("undertow")) {
            return;
        }
        this.modifyWebXML(archive, testClass);
        this.modifyOIDCAdapterConfig(archive, "/WEB-INF/keycloak.json");
        this.modifySAMLAdapterConfig(archive, "/WEB-INF/keycloak-saml.xml");
        this.modifySAMLAdapterConfig(archive, "/WEB-INF/classes/tenant1-keycloak-saml.xml");
        this.modifySAMLAdapterConfig(archive, "/WEB-INF/classes/tenant2-keycloak-saml.xml");
        this.modifyOIDCAdapterConfig(archive, "/keycloak.json");
    }

    private void modifyWebXML(Archive<?> archive, TestClass testClass) {
        if (!archive.contains("/WEB-INF/web.xml")) {
            return;
        }
        if (!testClass.getJavaClass().isAnnotationPresent(UseServletFilter.class)) {
            return;
        }
        this.log.debug((Object)("Modifying WEB.XML in " + archive.getName() + " for Servlet Filter."));
        DeploymentArchiveProcessorUtils.modifyWebXMLForServletFilter(archive, (TestClass)testClass);
    }

    private void modifyOIDCAdapterConfig(Archive<?> archive, String adapterConfigPath) {
        if (!archive.contains(adapterConfigPath)) {
            return;
        }
        this.log.debug((Object)("Modifying adapter config " + adapterConfigPath + " in " + archive.getName()));
        DeploymentArchiveProcessorUtils.modifyOIDCAdapterConfig(archive, (String)adapterConfigPath);
    }

    private void modifySAMLAdapterConfig(Archive<?> archive, String adapterConfigPath) {
        if (!archive.contains(adapterConfigPath)) {
            return;
        }
        this.log.debug((Object)("Modifying adapter config " + adapterConfigPath + " in " + archive.getName()));
        DeploymentArchiveProcessorUtils.modifySAMLAdapterConfig(archive, (String)adapterConfigPath);
    }
}

