/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow.container;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.keycloak.testsuite.arquillian.container.AppServerContainerProvider;
import org.keycloak.testsuite.arquillian.undertow.UndertowAppServer;

public class UndertowAppServerProvider
implements AppServerContainerProvider {
    private Node configuration;
    private static final String containerName = "undertow";

    public String getName() {
        return containerName;
    }

    public List<Node> getContainers() {
        ArrayList<Node> containers = new ArrayList<Node>();
        containers.add(this.standaloneContainer());
        return containers;
    }

    private void createChild(String name, String text) {
        this.configuration.createChild("property").attribute("name", name).text(text);
    }

    private Node standaloneContainer() {
        Node container = new Node("container");
        container.attribute("mode", "manual");
        container.attribute("qualifier", "app-server-undertow");
        this.configuration = container.createChild("configuration");
        this.createChild("enabled", "true");
        this.createChild("bindAddress", "0.0.0.0");
        this.createChild("bindHttpPort", "8280");
        this.createChild("adapterImplClass", UndertowAppServer.class.getName());
        return container;
    }

    private Node haNodeContainer(int number) {
        Node container = new Node("container");
        container.attribute("mode", "manual");
        container.attribute("qualifier", "app-server-undertow-ha-node-" + number);
        this.configuration = container.createChild("configuration");
        this.createChild("enabled", "true");
        this.createChild("bindAddress", "localhost");
        this.createChild("bindHttpPort", "8280");
        this.createChild("bindHttpPortOffset", Integer.toString(number));
        this.createChild("adapterImplClass", UndertowAppServer.class.getName());
        return container;
    }
}

