/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.keycloak.testsuite.arquillian.container.AppServerContainerProvider;

public class AppServerContainerService {
    private static AppServerContainerService service;
    private final ServiceLoader<AppServerContainerProvider> loader = ServiceLoader.load(AppServerContainerProvider.class);

    private AppServerContainerService() {
    }

    public static synchronized AppServerContainerService getInstance() {
        if (service == null) {
            service = new AppServerContainerService();
        }
        return service;
    }

    public List<Node> getContainers(String appServerName) {
        List<Node> containers = null;
        try {
            Iterator<AppServerContainerProvider> definitions = this.loader.iterator();
            ArrayList<AppServerContainerProvider> availableDefinitions = new ArrayList<AppServerContainerProvider>();
            while (definitions != null && definitions.hasNext()) {
                availableDefinitions.add(definitions.next());
            }
            for (AppServerContainerProvider def : availableDefinitions) {
                if (!def.getName().equals(appServerName)) continue;
                containers = def.getContainers();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            containers = null;
            throw serviceError;
        }
        return containers;
    }
}

