/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.example.ws.Product;
import org.keycloak.example.ws.UnknownProductFault;

public class ProductPortalServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        try (PrintWriter out = resp.getWriter();){
            out.println("<html><head><title>Product Portal Page</title></head><body>");
            String logoutUri = KeycloakUriBuilder.fromUri((String)"http://localhost:8080/auth").path("/realms/{realm-name}/protocol/openid-connect/logout").queryParam("redirect_uri", new Object[]{"http://localhost:8181/product-portal"}).build(new Object[]{"demo"}).toString();
            String acctUri = KeycloakUriBuilder.fromUri((String)"http://localhost:8080/auth").path("/realms/{realm-name}/account").queryParam("referrer", new Object[]{"product-portal"}).build(new Object[]{"demo"}).toString();
            out.println("<p>Goto: <a href=\"/customer-portal\">customers</a> | <a href=\"" + logoutUri + "\">logout</a> | <a href=\"" + acctUri + "\">manage acct</a></p>");
            out.println("Servlet User Principal <b>" + req.getUserPrincipal() + "</b> made this request.");
            String unsecuredWsClientResponse = this.sendWsReq(req, "1", false);
            String securedWsClientResponse = this.sendWsReq(req, "1", true);
            String securedWsClient2Response = this.sendWsReq(req, "2", true);
            out.println("<p>Product with ID 1 - unsecured request (it should end with failure): <b>" + unsecuredWsClientResponse + "</b></p><br>");
            out.println("<p>Product with ID 1 - secured request: <b>" + securedWsClientResponse + "</b></p><br>");
            out.println("<p>Product with ID 2 - secured request: <b>" + securedWsClient2Response + "</b></p><br>");
            out.println("</body></html>");
            out.flush();
        }
    }

    private String sendWsReq(HttpServletRequest req, String productId, boolean secured) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(Product.class);
        factory.setAddress("http://localhost:8282/ProductServiceCF");
        Product simpleClient = (Product)factory.create();
        Holder _getProduct_productId = new Holder((Object)productId);
        Holder _getProduct_name = new Holder();
        if (secured) {
            Client clientProxy = ClientProxy.getClient((Object)simpleClient);
            KeycloakSecurityContext session = (KeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName());
            if (session == null) {
                throw new RuntimeException("Keycloak Security Context is null.");
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Authorization", Collections.singletonList("Bearer " + session.getTokenString()));
            clientProxy.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
        }
        try {
            simpleClient.getProduct((Holder<String>)_getProduct_productId, (Holder<String>)_getProduct_name);
            return String.format("Product received: id=%s, name=%s", _getProduct_productId.value, _getProduct_name.value);
        }
        catch (UnknownProductFault upf) {
            return "UnknownProductFault has occurred. Details: " + upf.toString();
        }
        catch (WebServiceException wse) {
            String error = "Can't receive product. Reason: " + wse.getMessage();
            if (wse.getCause() != null) {
                Throwable cause = wse.getCause();
                error = error + " Details: " + cause.getClass().getName() + ": " + cause.getMessage();
            }
            return error;
        }
    }
}

