/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example;

import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.representations.AccessToken;

public class CamelHelloProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        KeycloakPrincipal keycloakPrincipal = (KeycloakPrincipal)exchange.getProperty(KeycloakPrincipal.class.getName(), KeycloakPrincipal.class);
        if (keycloakPrincipal == null) {
            HttpServletRequest req = (HttpServletRequest)exchange.getIn().getBody(HttpServletRequest.class);
            keycloakPrincipal = (KeycloakPrincipal)req.getUserPrincipal();
        }
        AccessToken accessToken = keycloakPrincipal.getKeycloakSecurityContext().getToken();
        String username = accessToken.getPreferredUsername();
        String fullName = accessToken.getName();
        exchange.getOut().setBody((Object)("Hello " + username + "! Your full name is " + fullName + "."));
    }
}

