/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.testsuite.util.cli.AbstractCommand;

public class SyncDummyFederationProviderCommand
extends AbstractCommand {
    @Override
    protected void doRunCommand(KeycloakSession session) {
        int waitTime = this.getIntArg(0);
        int changedSyncPeriod = this.getIntArg(1);
        RealmModel realm = session.realms().getRealmByName("master");
        UserStorageProviderModel fedProviderModel = KeycloakModelUtils.findUserStorageProviderByName((String)"cluster-dummy", (RealmModel)realm);
        if (fedProviderModel == null) {
            MultivaluedHashMap cfg = fedProviderModel.getConfig();
            this.updateConfig((MultivaluedHashMap<String, String>)cfg, waitTime);
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setProviderId("sync-dummy");
            model.setPriority(1);
            model.setName("cluster-dummy");
            model.setFullSyncPeriod(-1);
            model.setChangedSyncPeriod(changedSyncPeriod);
            model.setLastSync(-1);
            fedProviderModel = new UserStorageProviderModel(realm.addComponentModel((ComponentModel)model));
        } else {
            MultivaluedHashMap cfg = fedProviderModel.getConfig();
            this.updateConfig((MultivaluedHashMap<String, String>)cfg, waitTime);
            fedProviderModel.setChangedSyncPeriod(changedSyncPeriod);
            realm.updateComponent((ComponentModel)fedProviderModel);
        }
        new UserStorageSyncManager().notifyToRefreshPeriodicSync(session, realm, fedProviderModel, false);
        this.log.infof("User federation provider created and sync was started", (Object)waitTime);
    }

    private void updateConfig(MultivaluedHashMap<String, String> cfg, int waitTime) {
        cfg.putSingle((Object)"wait-time", (Object)String.valueOf(waitTime));
    }

    @Override
    public String getName() {
        return "startSyncDummy";
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <wait-time-before-sync-commit-in-seconds> <changed-sync-period-in-seconds>";
    }
}

