/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.testsuite.util.cli.AbstractCommand;
import org.keycloak.testsuite.util.cli.BatchTaskRunner;

public class LdapManyObjectsInitializerCommand
extends AbstractCommand {
    @Override
    public String getName() {
        return "createLdapObjects";
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <realm-name> <groups-dn> <start-offset-users> <count-users> <start-offset-groups> <count-groups> .\nSee javadoc of class LdapManyObjectsInitializerCommand for additional details.";
    }

    @Override
    protected void doRunCommand(KeycloakSession session) {
        String realmName = this.getArg(0);
        String groupsDn = this.getArg(1);
        int startOffsetUsers = this.getIntArg(2);
        int countUsers = this.getIntArg(3);
        int batchCount = 100;
        int startOffsetGroups = this.getIntArg(4);
        int countGroups = this.getIntArg(5);
        RealmModel realm = session.realms().getRealmByName(realmName);
        List components = realm.getComponentsStream(realm.getId(), UserStorageProvider.class.getName()).collect(Collectors.toList());
        if (components.size() != 1) {
            this.log.errorf("Expected 1 LDAP Provider, but found: %d providers", (Object)components.size());
            throw new AbstractCommand.HandledException();
        }
        ComponentModel ldapModel = (ComponentModel)components.get(0);
        this.getMapperModel(realm, ldapModel, "streetMapper");
        ComponentModel groupMapperModel = this.getMapperModel(realm, ldapModel, "groupsMapper");
        HashSet createdUserDNs = new HashSet();
        BatchTaskRunner.runInBatches(startOffsetUsers, countUsers, batchCount, session.getKeycloakSessionFactory(), (kcSession, firstIt, countInIt) -> {
            LDAPStorageProvider ldapProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, ldapModel);
            RealmModel appRealm = session.realms().getRealmByName(realmName);
            for (int i = firstIt; i < firstIt + countInIt; ++i) {
                String username = "user-" + i;
                String firstName = "John-" + i;
                String lastName = "Doe-" + i;
                String email = "user" + i + "@email.cz";
                LDAPObject createdUser = LdapManyObjectsInitializerCommand.addLDAPUser(ldapProvider, appRealm, username, firstName, lastName, email, groupsDn, startOffsetGroups, countGroups);
                createdUserDNs.add(createdUser.getDn().toString());
            }
            this.log.infof("Created LDAP users from: %d to %d", (Object)firstIt, (Object)(firstIt + countInIt - 1));
        });
        BatchTaskRunner.runInBatches(startOffsetGroups, countGroups, batchCount, session.getKeycloakSessionFactory(), (kcSession, firstIt, countInIt) -> {
            LDAPStorageProvider ldapProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, ldapModel);
            RealmModel appRealm = session.realms().getRealmByName(realmName);
            GroupLDAPStorageMapper groupMapper = (GroupLDAPStorageMapper)session.getProvider(LDAPStorageMapper.class, groupMapperModel);
            for (int i = firstIt; i < firstIt + countInIt; ++i) {
                String groupName = "group" + i;
                HashMap groupAttrs = new HashMap();
                groupAttrs.put("member", new HashSet(createdUserDNs));
                groupMapper.createLDAPGroup(groupName, groupAttrs);
            }
            this.log.infof("Created LDAP groups from: %d to %d", (Object)firstIt, (Object)(firstIt + countInIt - 1));
        });
    }

    private ComponentModel getMapperModel(RealmModel realm, ComponentModel ldapModel, String mapperName) {
        Optional<ComponentModel> first = realm.getComponentsStream(ldapModel.getId(), LDAPStorageMapper.class.getName()).filter(component -> Objects.equals(component.getName(), mapperName)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        this.log.errorf("Not present LDAP mapper called '%s'", (Object)mapperName);
        throw new RuntimeException();
    }

    private static LDAPObject addLDAPUser(LDAPStorageProvider ldapProvider, RealmModel realm, final String username, final String firstName, final String lastName, final String email, final String groupsDN, final int startOffsetGroups, final int countGroups) {
        UserModelDelegate helperUser = new UserModelDelegate(null){

            public String getUsername() {
                return username;
            }

            public String getFirstName() {
                return firstName;
            }

            public String getLastName() {
                return lastName;
            }

            public String getEmail() {
                return email;
            }

            public Stream<String> getAttributeStream(String name) {
                if ("firstName".equals(name)) {
                    return Stream.of(firstName);
                }
                if ("lastName".equals(name)) {
                    return Stream.of(lastName);
                }
                if ("email".equals(name)) {
                    return Stream.of(email);
                }
                if ("username".equals(name)) {
                    return Stream.of(username);
                }
                if ("street".equals(name)) {
                    Stream.Builder<String> builder = Stream.builder();
                    for (int i = startOffsetGroups; i < startOffsetGroups + countGroups; ++i) {
                        String groupName = "group" + i;
                        LDAPDn groupDn = LDAPDn.fromString((String)groupsDN);
                        groupDn.addFirst("cn", groupName);
                        builder.add(groupDn.toString());
                    }
                    return builder.build();
                }
                return Stream.empty();
            }
        };
        return LDAPUtils.addUserToLDAP((LDAPStorageProvider)ldapProvider, (RealmModel)realm, (UserModel)helperUser);
    }
}

