/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.cli;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.testsuite.util.cli.AbstractCommand;

public class LdapManyGroupsInitializerCommand
extends AbstractCommand {
    @Override
    public String getName() {
        return "createLdapGroups";
    }

    @Override
    public String printUsage() {
        return super.printUsage() + " <realm-name> <groups-dn> <start-offset-top-groups> <top-groups-count> <subgroups-in-every-top-group>.\nSee javadoc of class LdapManyGroupsInitializerCommand for additional details.";
    }

    @Override
    protected void doRunCommand(KeycloakSession session) {
        String realmName = this.getArg(0);
        String groupsDn = this.getArg(1);
        int startOffsetTopGroups = this.getIntArg(2);
        int topGroupsCount = this.getIntArg(3);
        int subgroupsInEveryGroup = this.getIntArg(4);
        RealmModel realm = session.realms().getRealmByName(realmName);
        List components = realm.getComponentsStream(realm.getId(), UserStorageProvider.class.getName()).collect(Collectors.toList());
        if (components.size() != 1) {
            this.log.errorf("Expected 1 LDAP Provider, but found: %d providers", (Object)components.size());
            throw new AbstractCommand.HandledException();
        }
        ComponentModel ldapModel = (ComponentModel)components.get(0);
        ComponentModel groupMapperModel = this.getMapperModel(realm, ldapModel, "groupsMapper");
        int i = startOffsetTopGroups;
        while (i < startOffsetTopGroups + topGroupsCount) {
            int iFinal = i++;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                LDAPStorageProvider ldapProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, ldapModel);
                RealmModel appRealm = session.realms().getRealmByName(realmName);
                GroupLDAPStorageMapper groupMapper = (GroupLDAPStorageMapper)session.getProvider(LDAPStorageMapper.class, groupMapperModel);
                HashSet<String> childGroupDns = new HashSet<String>();
                for (int j = 0; j < subgroupsInEveryGroup; ++j) {
                    String groupName = "group-" + iFinal + "-" + j;
                    LDAPObject createdGroup = groupMapper.createLDAPGroup(groupName, new HashMap());
                    childGroupDns.add(createdGroup.getDn().toString());
                }
                String topGroupName = "group-" + iFinal;
                HashMap groupAttrs = new HashMap();
                groupAttrs.put("member", new HashSet(childGroupDns));
                groupMapper.createLDAPGroup(topGroupName, groupAttrs);
            });
        }
    }

    private ComponentModel getMapperModel(RealmModel realm, ComponentModel ldapModel, String mapperName) {
        Optional<ComponentModel> first = realm.getComponentsStream(ldapModel.getId(), LDAPStorageMapper.class.getName()).filter(component -> Objects.equals(component.getName(), mapperName)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        this.log.errorf("Not present LDAP mapper called '%s'", (Object)mapperName);
        throw new RuntimeException();
    }
}

